/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.productpricing.controller;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.intentioninvest.enumerate.BusStatusEmun;
import com.els.modules.productpricing.entity.InventoryItem;
import com.els.modules.productpricing.entity.InventoryTopmanItem;
import com.els.modules.productpricing.entity.ProductPricingHead;
import com.els.modules.productpricing.enumerate.ProductPricingStatusEmun;
import com.els.modules.productpricing.service.InventoryItemService;
import com.els.modules.productpricing.service.InventoryTopmanItemService;
import com.els.modules.productpricing.service.ProductPricingHeadService;
import com.els.modules.productpricing.vo.ProductPricingHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/productPricingHead"})
@Api(tags={"\u4ea7\u54c1\u6838\u4ef7\u8868\u5934"})
public class ProductPricingHeadController
extends BaseController<ProductPricingHead, ProductPricingHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ProductPricingHeadController.class);
    @Autowired
    private ProductPricingHeadService productPricingHeadService;
    @Autowired
    private InventoryItemService inventoryItemService;
    @Autowired
    private InventoryTopmanItemService inventoryTopmanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ProductPricingHead productPricingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)productPricingHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        IPage pageList = this.productPricingHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u7ba1\u7406", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/save"})
    public Result<?> add(@RequestBody ProductPricingHeadVO productPricingHeadPage) {
        ProductPricingHead productPricingHead = new ProductPricingHead();
        BeanUtils.copyProperties((Object)((Object)productPricingHeadPage), (Object)((Object)productPricingHead));
        if (StrUtil.isBlank((CharSequence)productPricingHeadPage.getId())) {
            this.productPricingHeadService.saveMain(productPricingHead, productPricingHeadPage.getInventoryItemList(), productPricingHeadPage.getInventoryTopmanItemList());
        } else {
            this.productPricingHeadService.updateMain(productPricingHead, productPricingHeadPage.getInventoryItemList(), productPricingHeadPage.getInventoryTopmanItemList(), ProductPricingStatusEmun.NEWLY_BUILD);
        }
        return Result.ok((Object)((Object)productPricingHead));
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u7ba1\u7406", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    public Result<?> cancel(@RequestBody ProductPricingHeadVO productPricingHeadPage) {
        ProductPricingHead productPricingHead = (ProductPricingHead)((Object)((ProductPricingHeadService)this.service).getById((Serializable)((Object)productPricingHeadPage.getId())));
        if (Arrays.asList(ProductPricingStatusEmun.BE_QUOTED.getValue(), ProductPricingStatusEmun.APPROVED.getValue(), ProductPricingStatusEmun.APPROVAL.getValue()).contains(productPricingHead.getBusStatus()) && !AuditStatusEnum.AUDIT_DOING.getValue().equals(productPricingHead.getResultAuditStatus())) {
            productPricingHead.setBusStatus(BusStatusEmun.TO_VOID.getValue());
            ((ProductPricingHeadService)this.service).updateById((Object)productPricingHead);
        } else {
            Assert.isTrue((boolean)false, (String)"\u8be5\u5355\u636e\u72b6\u6001\u4e0d\u652f\u6301\u4f5c\u5e9f", (Object[])new Object[0]);
        }
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u8868\u7ba1\u7406", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ProductPricingHeadVO productPricingHeadPage) {
        ProductPricingHead productPricingHead = new ProductPricingHead();
        BeanUtils.copyProperties((Object)((Object)productPricingHeadPage), (Object)((Object)productPricingHead));
        this.productPricingHeadService.updateMain(productPricingHead, productPricingHeadPage.getInventoryItemList(), productPricingHeadPage.getInventoryTopmanItemList(), ProductPricingStatusEmun.NEWLY_BUILD);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u8868\u7ba1\u7406", value="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody ProductPricingHeadVO productPricingHeadPage) {
        ProductPricingHead productPricingHead = new ProductPricingHead();
        BeanUtils.copyProperties((Object)((Object)productPricingHeadPage), (Object)((Object)productPricingHead));
        productPricingHead.setBusStatus(ProductPricingStatusEmun.BE_QUOTED.getValue());
        this.productPricingHeadService.updateMain(productPricingHead, productPricingHeadPage.getInventoryItemList(), productPricingHeadPage.getInventoryTopmanItemList(), ProductPricingStatusEmun.BE_QUOTED);
        return this.commonSuccessResult(3);
    }

    @PostMapping(value={"/approvedPrice"})
    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u8868\u7ba1\u7406", value="\u5df2\u6838\u4ef7")
    public Result<?> approvedPrice(@RequestBody ProductPricingHeadVO productPricingHeadPage) {
        ProductPricingHead productPricingHead = new ProductPricingHead();
        BeanUtils.copyProperties((Object)((Object)productPricingHeadPage), (Object)((Object)productPricingHead));
        this.productPricingHeadService.updateMain(productPricingHead, productPricingHeadPage.getInventoryItemList(), productPricingHeadPage.getInventoryTopmanItemList(), ProductPricingStatusEmun.APPROVED);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u8868\u7ba1\u7406", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.productPricingHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u4ea7\u54c1\u6838\u4ef7\u8868\u7ba1\u7406", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.productPricingHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ProductPricingHead productPricingHead = (ProductPricingHead)((Object)this.productPricingHeadService.getById((Serializable)((Object)id)));
        ProductPricingHeadVO productPricingHeadVO = new ProductPricingHeadVO();
        BeanUtils.copyProperties((Object)((Object)productPricingHead), (Object)((Object)productPricingHeadVO));
        List<InventoryItem> inventoryItemList = this.inventoryItemService.selectByMainId(id);
        productPricingHeadVO.setInventoryItemList(inventoryItemList);
        List<InventoryTopmanItem> inventoryTopmanItemList = this.inventoryTopmanItemService.selectByMainId(id);
        productPricingHeadVO.setInventoryTopmanItemList(inventoryTopmanItemList);
        return Result.ok((Object)((Object)productPricingHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u6838\u4ef7\u8868\u5934id\u67e5\u8be2\u4ea7\u54c1\u6e05\u5355", notes="\u901a\u8fc7\u4ea7\u54c1\u6838\u4ef7\u8868\u5934id\u67e5\u8be2\u4ea7\u54c1\u6e05\u5355")
    @GetMapping(value={"/queryInventoryItemByMainId"})
    public Result<?> queryInventoryItemListByMainId(@RequestParam(name="id") String id) {
        List<InventoryItem> inventoryItemList = this.inventoryItemService.selectByMainId(id);
        return Result.ok(inventoryItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u6838\u4ef7\u8868\u5934id\u67e5\u8be2\u9002\u7528\u7684\u8fbe\u4eba", notes="\u901a\u8fc7\u4ea7\u54c1\u6838\u4ef7\u8868\u5934id\u67e5\u8be2\u9002\u7528\u7684\u8fbe\u4eba")
    @GetMapping(value={"/queryInventoryTopmanItemByMainId"})
    public Result<?> queryInventoryTopmanItemListByMainId(@RequestParam(name="id") String id) {
        List<InventoryTopmanItem> inventoryTopmanItemList = this.inventoryTopmanItemService.selectByMainId(id);
        return Result.ok(inventoryTopmanItemList);
    }

    @GetMapping(value={"/counts"})
    public Result<?> counts(ProductPricingHead productPricingHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)productPricingHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)this.getTenantId());
        queryWrapper.select(new String[]{"bus_status", "count(0) as quantity"});
        queryWrapper.groupBy((Object)"bus_status");
        List list = ((ProductPricingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(ProductPricingHead::getBusStatus, ProductPricingHead::getQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "busStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("productPricingStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "busStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

