/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.promotional.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.SubaccountOrgRpcService;
import com.els.modules.promotional.dto.AsyncDTO;
import com.els.modules.promotional.dto.CountDTO;
import com.els.modules.promotional.dto.OrgCountDTO;
import com.els.modules.promotional.dto.SampleDeliveryCountDTO;
import com.els.modules.promotional.dto.TopManCountDTO;
import com.els.modules.promotional.entity.PromotionalDataHead;
import com.els.modules.promotional.entity.PromotionalDataItem;
import com.els.modules.promotional.mapper.PromotionalDataHeadMapper;
import com.els.modules.promotional.service.PromotionalDataHeadService;
import com.els.modules.promotional.service.PromotionalDataItemService;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.assertj.core.util.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PromotionalDataHeadServiceImpl
extends BaseServiceImpl<PromotionalDataHeadMapper, PromotionalDataHead>
implements PromotionalDataHeadService {
    @Autowired
    private PromotionalDataItemService promotionalDataItemService;
    @Autowired
    private SubaccountOrgRpcService subaccountOrgRpcService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void add(PromotionalDataHead promotionalDataHead) {
        ((PromotionalDataHeadMapper)this.baseMapper).insert((Object)promotionalDataHead);
    }

    @Override
    public void edit(PromotionalDataHead promotionalDataHead) {
        int count = ((PromotionalDataHeadMapper)this.baseMapper).updateById((Object)promotionalDataHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PromotionalDataHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PromotionalDataHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PromotionalDataHead selectOneByOnlyParam(String subAccount, int countYear, int countMonth, String elsAccount) {
        return (PromotionalDataHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataHead::getSubAccount, (Object)subAccount)).eq(PromotionalDataHead::getCountYear, (Object)countYear)).eq(PromotionalDataHead::getCountMonth, (Object)countMonth)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PromotionalDataHead::getDeleted, (Object)"0")));
    }

    @Override
    public List<PromotionalDataHead> findByTimes(String startTime, String endTime) {
        return ((PromotionalDataHeadMapper)this.baseMapper).findByTimes(startTime, endTime, TenantContext.getTenant());
    }

    private Map<String, Map<Pair<Integer, Integer>, List<PromotionalDataItem>>> getOrderData(String startTime, String endTime) {
        List<PromotionalDataItem> promotionalDataItems = this.promotionalDataItemService.findOrder(startTime, endTime, TenantContext.getTenant());
        Map<String, List<PromotionalDataItem>> subMap = promotionalDataItems.stream().collect(Collectors.groupingBy(PromotionalDataItem::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthData((List<PromotionalDataItem>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<PromotionalDataItem>> yearMonthData = this.getYearMonthData((List<PromotionalDataItem>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<TopManCountDTO>>> getTopmanCountData(List<TopManCountDTO> dataItems) {
        Map<String, List<TopManCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthTopmanCountData((List<TopManCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<TopManCountDTO>> yearMonthData = this.getYearMonthTopmanCountData((List<TopManCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>>> getSampleDeliveryCountData(List<SampleDeliveryCountDTO> dataItems) {
        Map<String, List<SampleDeliveryCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getSampleDeliveryCountCountData((List<SampleDeliveryCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>> yearMonthData = this.getSampleDeliveryCountCountData((List<SampleDeliveryCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    private Map<String, Map<Pair<Integer, Integer>, List<OrgCountDTO>>> getOrgCountData(List<OrgCountDTO> dataItems) {
        Map<String, List<OrgCountDTO>> subMap = dataItems.stream().collect(Collectors.groupingBy(CountDTO::getSubAccount));
        HashMap endMap = Maps.newHashMap();
        subMap.forEach((k, v) -> {
            if (!endMap.containsKey(k)) {
                endMap.put(k, this.getYearMonthOrgCountData((List<OrgCountDTO>)v));
            } else {
                Map var = (Map)endMap.get(k);
                Map<Pair<Integer, Integer>, List<OrgCountDTO>> yearMonthData = this.getYearMonthOrgCountData((List<OrgCountDTO>)v);
                var.forEach((x, y) -> {
                    if (!var.containsKey(yearMonthData.get(x))) {
                        var.put(x, Optional.ofNullable(yearMonthData.get(x)).orElse(Lists.newArrayList()));
                    } else if (CollUtil.isNotEmpty((Collection)((Collection)yearMonthData.get(x)))) {
                        y.addAll((Collection)yearMonthData.get(x));
                    }
                });
            }
        });
        return endMap;
    }

    @Override
    public List<CountDTO> async(AsyncDTO asyncDto) {
        String startTime = asyncDto.getStartTime() + "-01 00:00:00";
        String endTime = asyncDto.getEndTime() + "-31 23:59:59";
        List<TopManCountDTO> topManCountDTOS = ((PromotionalDataHeadMapper)this.baseMapper).findTopManNum(startTime, endTime, TenantContext.getTenant());
        List<OrgCountDTO> orgCountDtos = ((PromotionalDataHeadMapper)this.baseMapper).findOrgNum(startTime, endTime, TenantContext.getTenant());
        List<SampleDeliveryCountDTO> sampleDeliveryCountDTOs = ((PromotionalDataHeadMapper)this.baseMapper).findSampleDeliveryNum(startTime, endTime, TenantContext.getTenant());
        Map<String, Map<Pair<Integer, Integer>, List<PromotionalDataItem>>> orderMap = this.getOrderData(startTime, endTime);
        Map<String, Map<Pair<Integer, Integer>, List<TopManCountDTO>>> subTopmanCountMap = this.getTopmanCountData(topManCountDTOS);
        Map<String, Map<Pair<Integer, Integer>, List<OrgCountDTO>>> subOrgCountMap = this.getOrgCountData(orgCountDtos);
        Map<String, Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>>> sampleDeliveryCountMap = this.getSampleDeliveryCountData(sampleDeliveryCountDTOs);
        HashSet subAccoountSet = Sets.newHashSet();
        HashSet yearMonthCount = Sets.newHashSet();
        subAccoountSet.addAll(orderMap.keySet());
        subAccoountSet.addAll(subTopmanCountMap.keySet());
        subAccoountSet.addAll(subOrgCountMap.keySet());
        subAccoountSet.addAll(sampleDeliveryCountMap.keySet());
        orderMap.entrySet().forEach(k -> yearMonthCount.addAll(((Map)k.getValue()).keySet()));
        subTopmanCountMap.entrySet().forEach(k -> yearMonthCount.addAll(((Map)k.getValue()).keySet()));
        subOrgCountMap.entrySet().forEach(k -> yearMonthCount.addAll(((Map)k.getValue()).keySet()));
        sampleDeliveryCountMap.entrySet().forEach(k -> yearMonthCount.addAll(((Map)k.getValue()).keySet()));
        String elsAccount = TenantContext.getTenant();
        String company = this.subaccountOrgRpcService.getSubaccountOrgCode();
        ArrayList dbItems = Lists.newArrayList();
        ArrayList heads = Lists.newArrayList();
        for (String subAccount : subAccoountSet) {
            Map<String, String> am = ((PromotionalDataHeadMapper)this.baseMapper).getEmployeeName(subAccount, elsAccount);
            for (Pair yearMonth : yearMonthCount) {
                List<SampleDeliveryCountDTO> sampleDeliveryCountDTOS;
                Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>> sample1;
                List<TopManCountDTO> topManCountDTOS1;
                Map<Pair<Integer, Integer>, List<TopManCountDTO>> topman1;
                List<OrgCountDTO> orgCountDTOS;
                List<PromotionalDataItem> promotionalDataItems;
                PromotionalDataHead head = new PromotionalDataHead();
                head.setSubAccount(subAccount);
                head.setElsAccount(elsAccount);
                head.setCompany(company);
                head.setCountYear((Integer)yearMonth.getKey());
                head.setCountMonth((Integer)yearMonth.getValue());
                head.setStartTime((Date)DateUtil.beginOfMonth((Date)DateUtil.parse((CharSequence)(yearMonth.getKey() + "-" + yearMonth.getValue()), (String)"yyyy-MM")));
                head.setEndTime((Date)DateUtil.endOfMonth((Date)DateUtil.parse((CharSequence)(yearMonth.getKey() + "-" + yearMonth.getValue()), (String)"yyyy-MM")));
                boolean addFlag = false;
                if (ObjectUtil.isNotEmpty(am)) {
                    head.setEmployeeName(am.get("employeeName"));
                    head.setEmployeeNo(am.get("employeeNo"));
                    head.setDeptName(am.get("deptName"));
                    head.setDeptNo(am.get("deptNo"));
                }
                head.setId(IdWorker.getIdStr());
                Map<Pair<Integer, Integer>, List<PromotionalDataItem>> o1 = orderMap.get(subAccount);
                BigDecimal orderVal = BigDecimal.ZERO;
                BigDecimal orderSales = BigDecimal.ZERO;
                if (ObjectUtil.isNotEmpty(o1) && CollUtil.isNotEmpty(promotionalDataItems = o1.get(yearMonth))) {
                    addFlag = true;
                    for (PromotionalDataItem dataItem : promotionalDataItems) {
                        dataItem.setHeadId(head.getId());
                        orderVal = orderVal.add(dataItem.getOrderVal());
                        orderSales = orderSales.add(new BigDecimal(dataItem.getOrderQty()));
                    }
                    dbItems.addAll(promotionalDataItems);
                }
                head.setCommissionSales(orderSales);
                head.setCommissionSalesVol(orderVal);
                Map<Pair<Integer, Integer>, List<OrgCountDTO>> org1 = subOrgCountMap.get(subAccount);
                if (ObjectUtil.isNotEmpty(org1) && CollUtil.isNotEmpty(orgCountDTOS = org1.get(yearMonth))) {
                    addFlag = true;
                    head.setStrOrgNum(orgCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getStrOrgNum())).collect(Collectors.summingInt(x -> x.getStrOrgNum())));
                    head.setCoopOrgNum(orgCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getCoopOrgNum())).collect(Collectors.summingInt(x -> x.getCoopOrgNum())));
                    head.setIntentOrgNum(orgCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getIntentOrgNum())).collect(Collectors.summingInt(x -> x.getIntentOrgNum())));
                }
                if (ObjectUtil.isNotEmpty(topman1 = subTopmanCountMap.get(subAccount)) && CollUtil.isNotEmpty(topManCountDTOS1 = topman1.get(yearMonth))) {
                    addFlag = true;
                    head.setStrManNum(topManCountDTOS1.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getStrManNum())).collect(Collectors.summingInt(x -> x.getStrManNum())));
                    head.setCoopManNum(topManCountDTOS1.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getCoopManNum())).collect(Collectors.summingInt(x -> x.getCoopManNum())));
                    head.setIntentManNum(topManCountDTOS1.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getIntentManNum())).collect(Collectors.summingInt(x -> x.getIntentManNum())));
                }
                if (ObjectUtil.isNotEmpty(sample1 = sampleDeliveryCountMap.get(subAccount)) && CollUtil.isNotEmpty(sampleDeliveryCountDTOS = sample1.get(yearMonth))) {
                    addFlag = true;
                    head.setSendSampleNum(sampleDeliveryCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getAllNum())).collect(Collectors.summingInt(x -> x.getAllNum())));
                    head.setSignedSampleNum(sampleDeliveryCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getReceivedNum())).collect(Collectors.summingInt(x -> x.getReceivedNum())));
                    head.setBesignedSampleNum(sampleDeliveryCountDTOS.stream().filter(x -> ObjectUtil.isNotEmpty((Object)x.getShippedNum())).collect(Collectors.summingInt(x -> x.getShippedNum())));
                }
                if (!addFlag) continue;
                heads.add(head);
            }
        }
        ArrayList checkDto = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)heads)) {
            for (PromotionalDataHead head : heads) {
                long count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataHead::getSubAccount, (Object)head.getSubAccount())).eq(PromotionalDataHead::getCountYear, (Object)head.getCountYear())).eq(PromotionalDataHead::getCountMonth, (Object)head.getCountMonth())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
                if (count <= 0L) continue;
                CountDTO countDTO = new CountDTO();
                countDTO.setCountYear(head.getCountYear());
                countDTO.setCountMonth(head.getCountMonth());
                countDTO.setSubAccount(head.getSubAccount());
                if (CollUtil.isNotEmpty(asyncDto.getCountDTOS())) {
                    if (asyncDto.getCountDTOS().contains(countDTO)) continue;
                    checkDto.add(countDTO);
                    continue;
                }
                checkDto.add(countDTO);
            }
        } else {
            Assert.isTrue((boolean)false, (String)"\u672a\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u540c\u6b65");
        }
        if (CollUtil.isEmpty((Collection)checkDto) && CollUtil.isNotEmpty((Collection)heads)) {
            for (PromotionalDataHead head : heads) {
                this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataHead::getSubAccount, (Object)head.getSubAccount())).eq(PromotionalDataHead::getCountYear, (Object)head.getCountYear())).eq(PromotionalDataHead::getCountMonth, (Object)head.getCountMonth())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
            }
            this.saveBatch(heads);
            if (CollUtil.isNotEmpty((Collection)dbItems)) {
                for (PromotionalDataItem item : dbItems) {
                    this.promotionalDataItemService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PromotionalDataItem::getSubAccount, (Object)item.getSubAccount())).eq(PromotionalDataItem::getCountYear, (Object)item.getCountYear())).eq(PromotionalDataItem::getCountMonth, (Object)item.getCountMonth())).eq(BaseEntity::getElsAccount, (Object)elsAccount));
                }
                this.promotionalDataItemService.saveBatch(dbItems);
            }
        }
        return checkDto;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.endOfMonth((Date)DateUtil.parse((CharSequence)"2023-6", (String)"yyyy-MM")));
    }

    private Map<Pair<Integer, Integer>, List<PromotionalDataItem>> getYearMonthData(List<PromotionalDataItem> data) {
        HashMap var = Maps.newHashMap();
        for (PromotionalDataItem datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<TopManCountDTO>> getYearMonthTopmanCountData(List<TopManCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (TopManCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<OrgCountDTO>> getYearMonthOrgCountData(List<OrgCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (OrgCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }

    private Map<Pair<Integer, Integer>, List<SampleDeliveryCountDTO>> getSampleDeliveryCountCountData(List<SampleDeliveryCountDTO> data) {
        HashMap var = Maps.newHashMap();
        for (SampleDeliveryCountDTO datum : data) {
            Pair m = new Pair((Object)datum.getCountYear(), (Object)datum.getCountMonth());
            if (!var.containsKey(m)) {
                var.put(m, Arrays.asList(datum));
                continue;
            }
            ((List)var.get(m)).add(datum);
        }
        return var;
    }
}

