/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsItemQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsLiveRecordVO;
import com.els.modules.companystore.dto.CompanyGoodsTopmanItemQueryDTO;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.CompanyGoodsItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveRecord;
import com.els.modules.companystore.entity.CompanyGoodsVideoItem;
import com.els.modules.companystore.entity.CompanyGoodsVideoRecord;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.excel.CompanyGoodsHeadExportServiceImpl;
import com.els.modules.companystore.excel.CompanyGoodsHeadStatisticsExportServiceImpl;
import com.els.modules.companystore.excel.CompanyGoodsTopmanItemExportServiceImpl;
import com.els.modules.companystore.job.ProductManageJob;
import com.els.modules.companystore.query.CompanyGoodsHeadQueryParam;
import com.els.modules.companystore.query.CompanyTopmanRecordQueryParam;
import com.els.modules.companystore.request.ProductListV2Request;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyGoodsLiveItemService;
import com.els.modules.companystore.service.CompanyGoodsLiveRecordService;
import com.els.modules.companystore.service.CompanyGoodsTopmanRecordService;
import com.els.modules.companystore.service.CompanyGoodsVideoItemService;
import com.els.modules.companystore.service.CompanyGoodsVideoRecordService;
import com.els.modules.companystore.vo.CompanyGoodsHeadStatisticsVO;
import com.els.modules.companystore.vo.CompanyGoodsHeadVO;
import com.els.modules.companystore.vo.CompanyGoodsVideoRecordVO;
import com.els.modules.companystore.vo.CompanyTopmanItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/companystore/companyGoodsHead"})
@Api(tags={"\u4f01\u4e1a\u5546\u54c1\u4fe1\u606f\u5934"})
public class CompanyGoodsHeadController
extends BaseController<CompanyGoodsHead, CompanyGoodsHeadService> {
    private static final Logger log = LoggerFactory.getLogger(CompanyGoodsHeadController.class);
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private CompanyGoodsTopmanRecordService companyGoodsTopmanRecordService;
    @Autowired
    private CompanyGoodsVideoItemService companyGoodsVideoItemService;
    @Autowired
    private CompanyGoodsVideoRecordService companyGoodsVideoRecordService;
    @Autowired
    private CompanyGoodsLiveItemService companyGoodsLiveItemService;
    @Autowired
    private CompanyGoodsLiveRecordService companyGoodsLiveRecordService;
    @Autowired
    private ProductManageJob productManageJob;
    @Autowired
    private ProductListV2Request productListV2Request;

    @ApiOperation(value="\u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyGoodsHead> queryWrapper = CompanyGoodsHeadQueryParam.getQueryParam(companyGoodsHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.companyGoodsHeadService.categoryListConvert(queryDTO);
        IPage<CompanyGoodsHead> pageList = this.companyGoodsHeadService.queryPage((Page<CompanyGoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5546\u54c1\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CompanyGoodsHeadVO headVO) {
        CompanyGoodsHead companyGoodsHead = new CompanyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyGoodsHead));
        companyGoodsHead.setBusAccount(this.getTenantId());
        this.companyGoodsHeadService.saveMain(companyGoodsHead, headVO);
        return Result.ok((Object)((Object)companyGoodsHead));
    }

    @ApiOperation(value="\u5546\u54c1\u8be6\u60c5", notes="\u5546\u54c1\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CompanyGoodsHeadVO headVO = this.companyGoodsHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u7edf\u8ba1", notes="\u57fa\u7840\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/goodsStat"})
    public Result<?> goodsStat(CompanyGoodsTopmanItemQueryDTO queryDTO) {
        CompanyGoodsHeadStatisticsVO vo = this.companyGoodsHeadService.goodsStatNew(queryDTO);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868", notes="\u57fa\u7840\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> goodsList(CompanyGoodsItem item, CompanyGoodsTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsHeadStatisticsVO> pageList = this.companyGoodsHeadService.queryCompanyGoodsItemPage((Page<CompanyGoodsItem>)page, (QueryWrapper<CompanyGoodsItem>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(CompanyStoreOrderItem item, CompanyTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyStoreOrderItem> queryWrapper = CompanyTopmanRecordQueryParam.getQueryParam(item, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyTopmanItemVO> pageList = this.companyGoodsTopmanRecordService.queryTopmanPage((Page<CompanyStoreOrderItem>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u7c7b\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u5206\u7c7b\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u53e3\u7891\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u53e3\u7891\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u7edf\u8ba1", notes="\u89c6\u9891\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/videoStat"})
    public Result<?> videoStat(CompanyGoodsItemQueryDTO queryDTO) {
        List<CompanyGoodsVideoItem> itemList = this.companyGoodsVideoItemService.videoList(queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u5217\u8868", notes="\u89c6\u9891\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/videoList"})
    public Result<?> videoList(CompanyGoodsVideoRecord videoList, CompanyGoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)videoList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsVideoRecordVO> pageList = this.companyGoodsVideoRecordService.queryVideoPage((Page<CompanyGoodsVideoRecord>)page, (QueryWrapper<CompanyGoodsVideoRecord>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1", notes="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/liveStat"})
    public Result<?> liveStat(CompanyGoodsItemQueryDTO queryDTO) {
        List<CompanyGoodsLiveItem> itemList = this.companyGoodsLiveItemService.videoList(queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u5217\u8868", notes="\u76f4\u64ad\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/liveList"})
    public Result<?> liveList(CompanyGoodsLiveRecord liveList, CompanyGoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)liveList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsLiveRecordVO> pageList = this.companyGoodsLiveRecordService.queryLivePage((Page<CompanyGoodsLiveRecord>)page, (QueryWrapper<CompanyGoodsLiveRecord>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa", notes="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyGoodsHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/statisticsExportXls"})
    public ModelAndView statisticsExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyGoodsHeadStatisticsExportServiceImpl.class);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/topmanExportXls"})
    public ModelAndView topmanExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyGoodsTopmanItemExportServiceImpl.class);
    }

    @GetMapping(value={"/test"})
    public Result<?> test(@RequestParam String shopId) throws IOException {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, -90);
        Date threeDate = calendar.getTime();
        long endTime = new Date().getTime() / 1000L;
        long startTime = threeDate.getTime() / 1000L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", 0);
        map.put("check_status", 3);
        map.put("product_type", 0);
        map.put("start_time", startTime);
        map.put("end_time", endTime);
        map.put("page", 1);
        map.put("size", 1000);
        map.put("update_start_time", startTime);
        map.put("update_end_time", endTime);
        this.productListV2Request.httpGet("4463798", "product.listV2", map);
        return null;
    }

    @GetMapping(value={"/task"})
    public void test() {
        this.productManageJob.execute("{\"jobImplName\":\"productManageJobRpcServiceImpl\",\"tenantId\":\"100000\"}");
    }
}

