/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.utils.SignUtil;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductListV2Request {
    @Autowired
    private DouDianProperties douDianProperties;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;

    public void httpGet(String shopId, String method, Map<String, Object> param) throws IOException {
        String line;
        String appKey = this.douDianProperties.getAppKey();
        String appSecret = this.douDianProperties.getAppSecret();
        String url = this.douDianProperties.getUrl();
        AccessTokenData authorizeToken = this.companyStoreHeadService.getAuthorizeToken(shopId);
        String accessToken = "b532c94f-84d8-49f3-9b01-b36b532573d4";
        String paramJson = JSON.toJSONString(param);
        System.out.println("paramJson=" + paramJson);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        System.out.println("timestamp=" + timestamp);
        String sign = SignUtil.sign((String)appKey, (String)appSecret, (String)method, (String)timestamp, (String)paramJson, (String)"2");
        System.out.println("sign=" + sign);
        System.out.println("method=" + method);
        String authUrl = url + "/" + method.replace(".", "/") + "?app_key=" + URLEncoder.encode(appKey, "UTF-8") + "&method=" + URLEncoder.encode(method, "UTF-8") + "&access_token=" + URLEncoder.encode(accessToken, "UTF-8") + "&timestamp=" + URLEncoder.encode(timestamp, "UTF-8") + "&v=" + URLEncoder.encode(this.douDianProperties.getVersion(), "UTF-8") + "&param_json=" + URLEncoder.encode(paramJson, "UTF-8") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
        System.out.println("authUrl=" + authUrl);
        URL urlConnect = new URL(authUrl);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        StringBuilder result = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        System.out.println("litai:" + line);
        Map map = (Map)JSONObject.parseObject((String)result.toString(), Map.class);
        Map data = (Map)map.get("data");
        System.out.println("data1111=" + data);
        List data1 = (List)data.get("data");
        ArrayList companyGoodsHeadList = new ArrayList();
        data1.forEach(a -> {
            CompanyGoodsHead companyGoodsHead = new CompanyGoodsHead();
            companyGoodsHead.setPicture((String)a.get("img"));
            companyGoodsHead.setCategory((String)((Map)a.get("category_detail")).get("first_cname"));
            companyGoodsHead.setShopId(shopId);
            companyGoodsHead.setStoreName("\u6296\u5e97\u5f00\u653e\u5e73\u53f0\u6d4b\u8bd5\u4e13\u7528\u65d7\u8230\u5e97");
            companyGoodsHead.setPrice(new BigDecimal((Integer)a.get("discount_price")));
            companyGoodsHead.setCommissionRate(new BigDecimal((Integer)a.get("cos_ratio")));
            companyGoodsHeadList.add(companyGoodsHead);
        });
        if (CollectionUtils.isNotEmpty(companyGoodsHeadList)) {
            this.companyGoodsHeadService.saveOrUpdateBatch(companyGoodsHeadList);
        }
    }

    public static void main(String[] args) {
        String str = "{\n\t\"code\": 10000,\n\t\"data\": {\n\t\t\"data\": [{\n\t\t\t\"category_detail\": {\n\t\t\t\t\"first_cid\": 20005,\n\t\t\t\t\"first_cname\": \"\u5973\u88c5\",\n\t\t\t\t\"fourth_cid\": 0,\n\t\t\t\t\"fourth_cname\": \"\",\n\t\t\t\t\"second_cid\": 20219,\n\t\t\t\t\"second_cname\": \"\u534a\u8eab\u88d9\",\n\t\t\t\t\"third_cid\": 0,\n\t\t\t\t\"third_cname\": \"\"\n\t\t\t},\n\t\t\t\"check_status\": 3,\n\t\t\t\"cos_ratio\": 0,\n\t\t\t\"create_time\": 1656044684,\n\t\t\t\"description\": \"\\u003cimg src=\\\"https://p3-aio.ecombdimg.com/obj/ecom-shop-material/v1_ALSUvYM_70868009470405839400798_065468e7a97a0b31ce88337e340a42f2_sx_321041_www1365-1365\\\" style=\\\"width:100%;\\\"\\u003e\\u003cimg src=\\\"https://p6-aio.ecombdimg.com/obj/ecom-shop-material/v1_ALSUvYM_70893468317459254070798_271cef52de9905ec1eb8c2dd3c2e8755_sx_311219_www800-800\\\" style=\\\"width:100%;\\\"\\u003e\\u003cimg src=\\\"https://p3-aio.ecombdimg.com/obj/ecom-shop-material/v1_ALSUvYM_70630259408755264040798_16991a88a61d1a1f4ab8bc526fcb7762_sx_388998_www800-800\\\" style=\\\"width:100%;\\\"\\u003e\",\n\t\t\t\"discount_price\": 1,\n\t\t\t\"extra\": \"{\\\"category_detail\\\":{\\\"first_cid\\\":20005,\\\"second_cid\\\":20219,\\\"third_cid\\\":0,\\\"fourth_cid\\\":0,\\\"first_cname\\\":\\\"\u5973\u88c5\\\",\\\"second_cname\\\":\\\"\u534a\u8eab\u88d9\\\",\\\"third_cname\\\":\\\"\\\",\\\"fourth_cname\\\":\\\"\\\",\\\"is_leaf\\\":true},\\\"class_quality\\\":\\\"\\\",\\\"is_publish\\\":1,\\\"quality_opId\\\":\\\"7112657698772320548\\\",\\\"quality_report\\\":\\\"\\\"}\",\n\t\t\t\"img\": \"https://p3-aio.ecombdimg.com/obj/ecom-shop-material/v1_ALSUvYM_70868009470405839400798_065468e7a97a0b31ce88337e340a42f2_sx_321041_www1365-1365\",\n\t\t\t\"is_package_product\": false,\n\t\t\t\"market_price\": 1,\n\t\t\t\"mobile\": \"40012345\",\n\t\t\t\"name\": \"\u3010\u6d4b\u8bd5\u5546\u54c1\u52ff\u62cd\u3011dy\u6d4b\u8bd5\u4e0a\u8863-\u5404\u79cd\u7f16\u78013\",\n\t\t\t\"out_product_id\": 0,\n\t\t\t\"outer_product_id\": \"\",\n\t\t\t\"pay_type\": 1,\n\t\t\t\"product_id\": 3556328879700475991,\n\t\t\t\"product_type\": 0,\n\t\t\t\"recommend_remark\": \"\",\n\t\t\t\"spec_id\": 1736488708295703,\n\t\t\t\"status\": 0,\n\t\t\t\"update_time\": 1656044699\n\t\t}\n\t\t\n\t\t],\n\t\t\"page\": 1,\n\t\t\"size\": 1000,\n\t\t\"total\": 101\n\t},\n\t\"err_no\": 0,\n\t\"log_id\": \"2022062413255801015803116219083344\",\n\t\"message\": \"success\",\n\t\"msg\": \"success\",\n\t\"sub_code\": \"\",\n\t\"sub_msg\": \"\"\n}";
        Map map = (Map)JSONObject.parseObject((String)str, Map.class);
        System.out.println(map.get("code"));
        Map data = (Map)map.get("data");
        List data1 = (List)data.get("data");
        System.out.println("data1=" + data1);
        System.out.println("aaaa=" + data1.get(0));
        data1.forEach(a -> System.out.println("aaaaa=" + a));
    }
}

