/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.utils.TimeTranslateUtil;
import com.els.common.vo.CountVO;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.CompanyGoodsItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveRecord;
import com.els.modules.companystore.entity.CompanyGoodsTopmanItem;
import com.els.modules.companystore.entity.CompanyGoodsTopmanRecord;
import com.els.modules.companystore.entity.CompanyGoodsVideoItem;
import com.els.modules.companystore.entity.CompanyGoodsVideoRecord;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.mapper.CompanyGoodsHeadMapper;
import com.els.modules.companystore.mapper.CompanyGoodsItemMapper;
import com.els.modules.companystore.mapper.CompanyGoodsLiveItemMapper;
import com.els.modules.companystore.mapper.CompanyGoodsLiveRecordMapper;
import com.els.modules.companystore.mapper.CompanyGoodsTopmanItemMapper;
import com.els.modules.companystore.mapper.CompanyGoodsTopmanRecordMapper;
import com.els.modules.companystore.mapper.CompanyGoodsVideoItemMapper;
import com.els.modules.companystore.mapper.CompanyGoodsVideoRecordMapper;
import com.els.modules.companystore.mapper.CompanyStoreOrderItemMapper;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyGoodsItemService;
import com.els.modules.companystore.vo.CompanyGoodsHeadStatisticsVO;
import com.els.modules.companystore.vo.CompanyGoodsHeadVO;
import com.els.modules.companystore.vo.CompanyTabCountVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyGoodsHeadServiceImpl
extends BaseServiceImpl<CompanyGoodsHeadMapper, CompanyGoodsHead>
implements CompanyGoodsHeadService {
    @Autowired
    private CompanyGoodsHeadMapper companyGoodsHeadMapper;
    @Autowired
    private CompanyGoodsItemService companyGoodsItemService;
    @Autowired
    private CompanyGoodsItemMapper companyGoodsItemMapper;
    @Autowired
    private CompanyGoodsTopmanItemMapper companyGoodsTopmanItemMapper;
    @Autowired
    private CompanyGoodsTopmanRecordMapper companyGoodsTopmanRecordMapper;
    @Autowired
    private CompanyGoodsVideoItemMapper companyGoodsVideoItemMapper;
    @Autowired
    private CompanyGoodsVideoRecordMapper companyGoodsVideoRecordMapper;
    @Autowired
    private CompanyGoodsLiveItemMapper companyGoodsLiveItemMapper;
    @Autowired
    private CompanyGoodsLiveRecordMapper companyGoodsLiveRecordMapper;
    @Autowired
    private CompanyStoreOrderItemMapper companyStoreOrderItemMapper;

    @Override
    public IPage<CompanyGoodsHead> queryPage(Page<CompanyGoodsHead> page, QueryWrapper<CompanyGoodsHead> queryWrapper, CompanyGoodsHeadQueryDTO queryDTO) {
        IPage<CompanyGoodsHead> goodsHeadPage = ((CompanyGoodsHeadMapper)this.baseMapper).goodsHeadPage(page, queryWrapper, queryDTO);
        return goodsHeadPage;
    }

    @Override
    public CompanyGoodsHeadQueryDTO categoryConvert(CompanyGoodsHeadQueryDTO queryDTO) {
        String category = queryDTO.getGoodsCategory();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                category = category.replace(",", "|");
            } else if (category.contains("\u5168\u90e8")) {
                category = "";
            }
            queryDTO.setGoodsCategory(category);
        }
        return queryDTO;
    }

    @Override
    public CompanyGoodsHeadQueryDTO categoryListConvert(CompanyGoodsHeadQueryDTO queryDTO) {
        String category = queryDTO.getGoodsCategory();
        ArrayList<String> categorys = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            if (category.contains(",")) {
                String[] strings;
                for (String string : strings = category.split(",")) {
                    String[] strs = string.split("-");
                    categorys.add(strs[1]);
                    categorys.add(strs[2]);
                }
            } else if (category.contains("\u5168\u90e8")) {
                categorys.add("");
            } else {
                String[] strs = category.split("-");
                categorys.add(strs[1]);
                categorys.add(strs[2]);
            }
            String finalCategory = StringUtils.join(categorys, (String)"|");
            queryDTO.setGoodsCategory(finalCategory);
        }
        return queryDTO;
    }

    @Override
    public QueryWrapper<CompanyGoodsHead> criteriaQuery(QueryWrapper<CompanyGoodsHead> queryWrapper, CompanyGoodsHeadQueryDTO queryDTO) {
        List<CompanyGoodsItem> goodsItems;
        String goodsRate;
        String goodsPrice = queryDTO.getGoodsPrice();
        if (StringUtils.isNotBlank((CharSequence)goodsPrice)) {
            String price;
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.lambda().gt(CompanyGoodsHead::getPrice, (Object)new BigDecimal(prices[0]));
                queryWrapper.lambda().le(CompanyGoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                price = goodsPrice.substring(goodsPrice.indexOf("<") + 1);
                queryWrapper.lambda().lt(CompanyGoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                price = goodsPrice.substring(goodsPrice.indexOf(">") + 1);
                queryWrapper.lambda().gt(CompanyGoodsHead::getPrice, (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().gt(CompanyGoodsHead::getCommissionRate, (Object)split);
                queryWrapper.lambda().le(CompanyGoodsHead::getCommissionRate, (Object)split1);
            }
            if (goodsRate.contains(">=")) {
                strings = goodsRate.split(">=");
                String split1 = strings[1].split("%")[0];
                queryWrapper.lambda().ge(CompanyGoodsHead::getCommissionRate, (Object)split1);
            }
        }
        if (CollectionUtil.isNotEmpty(goodsItems = this.companyGoodsItemService.queryList(queryDTO))) {
            List ids = goodsItems.stream().map(CompanyGoodsItem::getGoodsId).distinct().collect(Collectors.toList());
            queryWrapper.lambda().in(BaseEntity::getId, ids);
        } else {
            queryWrapper.lambda().eq(BaseEntity::getId, null);
        }
        return queryWrapper;
    }

    @Override
    public CompanyGoodsHeadStatisticsVO goodsStatNew(CompanyGoodsTopmanItemQueryDTO queryDTO) {
        CompanyGoodsItem item = this.companyGoodsItemService.queryCompanyGoodsItem(queryDTO.getGoodsId(), queryDTO.getTopmanTimeSelect());
        CompanyGoodsHeadStatisticsVO vo = new CompanyGoodsHeadStatisticsVO();
        if (item != null) {
            BeanUtil.copyProperties((Object)((Object)item), (Object)vo, (String[])new String[0]);
        }
        return vo;
    }

    @Override
    public List<CompanyGoodsHeadStatisticsVO> queryCompanyGoodsItemPage(Page<CompanyGoodsItem> page, QueryWrapper<CompanyGoodsItem> queryWrapper, CompanyGoodsTopmanItemQueryDTO queryDTO) {
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        List<CompanyStoreOrderItem> itemList = this.companyStoreOrderItemMapper.companyGoodsList(queryWrapper, queryDTO);
        return this.replenishStatistics(queryDTO, itemList);
    }

    private List<CompanyGoodsHeadStatisticsVO> replenishStatistics(CompanyGoodsTopmanItemQueryDTO queryDTO, List<CompanyStoreOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<CompanyGoodsHeadStatisticsVO> voList = new ArrayList<CompanyGoodsHeadStatisticsVO>();
        for (CompanyStoreOrderItem item : list) {
            CompanyGoodsHeadStatisticsVO vo = new CompanyGoodsHeadStatisticsVO();
            BigDecimal salesNumLive = BigDecimal.ZERO;
            BigDecimal salesNumVideo = BigDecimal.ZERO;
            BigDecimal topmanNum = BigDecimal.ZERO;
            BigDecimal videosNum = BigDecimal.ZERO;
            BigDecimal livesNum = BigDecimal.ZERO;
            vo.setStatisticTime(DateUtil.format((Date)item.getOrderTime(), (String)"yyyy-MM-dd"));
            if (StringUtils.isNotBlank((CharSequence)item.getLiveId())) {
                livesNum = new BigDecimal(1);
                salesNumLive = new BigDecimal(item.getGoodsQuantity());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getVideoId())) {
                videosNum = new BigDecimal(1);
                salesNumVideo = new BigDecimal(item.getGoodsQuantity());
            }
            BigDecimal salesNum = salesNumLive.add(salesNumVideo);
            BigDecimal salesAmountMin = item.getPrice().multiply(salesNum);
            BigDecimal salesAmountMax = item.getPrice().multiply(salesNum);
            if (StringUtils.isNotBlank((CharSequence)item.getTopmanId())) {
                topmanNum = new BigDecimal(1);
            }
            vo.setSalesNum(salesNum);
            vo.setSalesNumLive(salesNumLive);
            vo.setSalesNumVideo(salesNumVideo);
            vo.setSalesAmountMin(salesAmountMin);
            vo.setSalesAmountMax(salesAmountMax);
            vo.setTopmanNum(topmanNum);
            vo.setVideosNum(videosNum);
            vo.setLivesNum(livesNum);
            voList.add(vo);
        }
        if (CollectionUtils.isEmpty(voList)) {
            return Collections.emptyList();
        }
        List statisticTimes = voList.stream().map(CompanyGoodsHeadStatisticsVO::getStatisticTime).distinct().collect(Collectors.toList());
        Map<String, List<CompanyGoodsHeadStatisticsVO>> map = voList.stream().collect(Collectors.groupingBy(CompanyGoodsHeadStatisticsVO::getStatisticTime));
        ArrayList<CompanyGoodsHeadStatisticsVO> finalList = new ArrayList<CompanyGoodsHeadStatisticsVO>();
        for (String statisticTime : statisticTimes) {
            List<CompanyGoodsHeadStatisticsVO> svs = map.get(statisticTime);
            CompanyGoodsHeadStatisticsVO vo = new CompanyGoodsHeadStatisticsVO();
            vo.setSalesNum(svs.stream().map(CompanyGoodsHeadStatisticsVO::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setSalesAmountMin(svs.stream().map(CompanyGoodsHeadStatisticsVO::getSalesAmountMin).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setSalesAmountMax(svs.stream().map(CompanyGoodsHeadStatisticsVO::getSalesAmountMax).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setTopmanNum(svs.stream().map(CompanyGoodsHeadStatisticsVO::getTopmanNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setVideosNum(svs.stream().map(CompanyGoodsHeadStatisticsVO::getVideosNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setLivesNum(svs.stream().map(CompanyGoodsHeadStatisticsVO::getLivesNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setStatisticTime(statisticTime);
            finalList.add(vo);
        }
        if (CollectionUtil.isNotEmpty(finalList)) {
            finalList.sort((o1, o2) -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date dt1 = format.parse(o1.getStatisticTime());
                    Date dt2 = format.parse(o2.getStatisticTime());
                    return Long.compare(dt2.getTime(), dt1.getTime());
                }
                catch (Exception e) {
                    return 0;
                }
            });
        }
        return finalList;
    }

    @Override
    public CompanyGoodsHeadVO queryById(String id) {
        CompanyGoodsHeadVO goodsHeadVO = new CompanyGoodsHeadVO();
        CompanyGoodsHead companyGoodsHead = (CompanyGoodsHead)((Object)this.getById((Serializable)((Object)id)));
        if (companyGoodsHead == null) {
            return goodsHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)companyGoodsHead), (Object)((Object)goodsHeadVO));
        String timeSelect = "30";
        CompanyGoodsItem goodsItem = this.companyGoodsItemService.queryGoodsItem(id, timeSelect);
        if (goodsItem != null) {
            goodsHeadVO.setSalesNum(goodsItem.getSalesNum());
            goodsHeadVO.setSalesAmountMin(goodsItem.getSalesAmountMin());
            goodsHeadVO.setSalesAmountMax(goodsItem.getSalesAmountMax());
            goodsHeadVO.setSalesNumLive(goodsItem.getSalesNumLive());
            goodsHeadVO.setSalesNumVideo(goodsItem.getSalesNumVideo());
            goodsHeadVO.setTopmanNum(goodsItem.getTopmanNum());
            goodsHeadVO.setLivesNum(goodsItem.getLivesNum());
            goodsHeadVO.setVideosNum(goodsItem.getVideosNum());
            goodsHeadVO.setBrowsesNum(goodsItem.getBrowsesNum());
            goodsHeadVO.setConvertRate(goodsItem.getConvertRate());
        }
        return goodsHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadVO headVO) {
        this.companyGoodsHeadMapper.insert((Object)companyGoodsHead);
        super.setHeadDefaultValue((BaseEntity)companyGoodsHead);
        this.insertData(companyGoodsHead, headVO);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadVO headVO) {
        this.companyGoodsHeadMapper.updateById((Object)companyGoodsHead);
        this.companyGoodsTopmanItemMapper.deleteByMainId(companyGoodsHead.getId());
        this.companyGoodsVideoItemMapper.deleteByMainId(companyGoodsHead.getId());
        this.companyGoodsVideoRecordMapper.deleteByMainId(companyGoodsHead.getId());
        this.companyGoodsLiveItemMapper.deleteByMainId(companyGoodsHead.getId());
        this.companyGoodsLiveRecordMapper.deleteByMainId(companyGoodsHead.getId());
        this.insertData(companyGoodsHead, headVO);
    }

    private void insertData(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadVO headVO) {
        List<CompanyGoodsTopmanRecord> records;
        List<CompanyGoodsItem> companyGoodsItemList = headVO.getCompanyGoodsItem();
        List<CompanyGoodsTopmanItem> companyGoodsTopmanItemList = headVO.getCompanyGoodsTopmanItemList();
        List<CompanyGoodsTopmanRecord> companyGoodsTopmanRecordList = headVO.getCompanyGoodsTopmanRecordList();
        List<CompanyGoodsVideoItem> companyGoodsVideoItemList = headVO.getCompanyGoodsVideoItemList();
        List<CompanyGoodsVideoRecord> companyGoodsVideoRecordList = headVO.getCompanyGoodsVideoRecordList();
        List<CompanyGoodsLiveItem> companyGoodsLiveItemList = headVO.getCompanyGoodsLiveItemList();
        List<CompanyGoodsLiveRecord> companyGoodsLiveRecordList = headVO.getCompanyGoodsLiveRecordList();
        if (!CollectionUtils.isEmpty(companyGoodsItemList)) {
            for (CompanyGoodsItem companyGoodsItem : companyGoodsItemList) {
                companyGoodsItem.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsItem, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsItemList.isEmpty()) {
                this.companyGoodsItemMapper.insertBatchSomeColumn(companyGoodsItemList);
            }
        }
        if (!CollectionUtils.isEmpty(companyGoodsTopmanRecordList)) {
            for (CompanyGoodsTopmanRecord companyGoodsTopmanRecord : companyGoodsTopmanRecordList) {
                companyGoodsTopmanRecord.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsTopmanRecord, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsTopmanRecordList.isEmpty()) {
                this.companyGoodsTopmanRecordMapper.insertBatchSomeColumn(companyGoodsTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.companyGoodsTopmanRecordMapper.selectByMainId(companyGoodsHead.getId()))) {
            for (CompanyGoodsTopmanRecord companyGoodsTopmanRecord : records) {
                if (CollectionUtils.isEmpty(companyGoodsTopmanItemList)) continue;
                for (CompanyGoodsTopmanItem entity2 : companyGoodsTopmanItemList) {
                    entity2.setRecordId(companyGoodsTopmanRecord.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)companyGoodsHead);
                }
                if (companyGoodsTopmanItemList.isEmpty()) continue;
                this.companyGoodsTopmanItemMapper.insertBatchSomeColumn(companyGoodsTopmanItemList);
            }
        }
        if (!CollectionUtils.isEmpty(companyGoodsVideoItemList)) {
            for (CompanyGoodsVideoItem companyGoodsVideoItem : companyGoodsVideoItemList) {
                companyGoodsVideoItem.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsVideoItem, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsVideoItemList.isEmpty()) {
                this.companyGoodsVideoItemMapper.insertBatchSomeColumn(companyGoodsVideoItemList);
            }
        }
        if (!CollectionUtils.isEmpty(companyGoodsVideoRecordList)) {
            for (CompanyGoodsVideoRecord companyGoodsVideoRecord : companyGoodsVideoRecordList) {
                companyGoodsVideoRecord.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsVideoRecord, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsVideoRecordList.isEmpty()) {
                this.companyGoodsVideoRecordMapper.insertBatchSomeColumn(companyGoodsVideoRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(companyGoodsLiveItemList)) {
            for (CompanyGoodsLiveItem companyGoodsLiveItem : companyGoodsLiveItemList) {
                companyGoodsLiveItem.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsLiveItem, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsLiveItemList.isEmpty()) {
                this.companyGoodsLiveItemMapper.insertBatchSomeColumn(companyGoodsLiveItemList);
            }
        }
        if (!CollectionUtils.isEmpty(companyGoodsLiveRecordList)) {
            for (CompanyGoodsLiveRecord companyGoodsLiveRecord : companyGoodsLiveRecordList) {
                companyGoodsLiveRecord.setGoodsId(companyGoodsHead.getId());
                SysUtil.setSysParam((BaseEntity)companyGoodsLiveRecord, (BaseEntity)companyGoodsHead);
            }
            if (!companyGoodsLiveRecordList.isEmpty()) {
                this.companyGoodsLiveRecordMapper.insertBatchSomeColumn(companyGoodsLiveRecordList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.companyGoodsTopmanItemMapper.deleteByMainId(id);
        this.companyGoodsVideoItemMapper.deleteByMainId(id);
        this.companyGoodsVideoRecordMapper.deleteByMainId(id);
        this.companyGoodsLiveItemMapper.deleteByMainId(id);
        this.companyGoodsLiveRecordMapper.deleteByMainId(id);
        this.companyGoodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.companyGoodsTopmanItemMapper.deleteByMainId(serializable.toString());
            this.companyGoodsVideoItemMapper.deleteByMainId(serializable.toString());
            this.companyGoodsVideoRecordMapper.deleteByMainId(serializable.toString());
            this.companyGoodsLiveItemMapper.deleteByMainId(serializable.toString());
            this.companyGoodsLiveRecordMapper.deleteByMainId(serializable.toString());
            this.companyGoodsHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<CountVO> categoryCounts(CompanyGoodsHeadQueryDTO queryDTO, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CompanyTabCountVO> list = ((CompanyGoodsHeadMapper)this.baseMapper).tabCountList(queryDTO);
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "goodsCategory", null, Integer.valueOf(list.size())));
        if (CollectionUtil.isNotEmpty(list)) {
            List types = list.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getType())).map(CompanyTabCountVO::getType).distinct().collect(Collectors.toList());
            LinkedHashSet<String> finalTypes = new LinkedHashSet<String>();
            for (String type : types) {
                if (type.contains("-")) {
                    String[] split = type.split("-");
                    finalTypes.add(split[1]);
                    continue;
                }
                finalTypes.add(type);
            }
            for (String finalType : finalTypes) {
                long count = list.stream().filter(h -> h.getType().contains(finalType)).count();
                result.add(new CountVO(I18nUtil.translate((String)"", (String)finalType), "goodsCategory", finalType, Integer.valueOf((int)count)));
            }
        }
        return result;
    }

    @Override
    public CompanyGoodsHead selectByGoodsId(String goodsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CompanyGoodsHead::getGoodsId, (Object)goodsId);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)0);
        return (CompanyGoodsHead)((Object)((CompanyGoodsHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    @Transactional
    public void insertBatch(List<List<CompanyGoodsHead>> goodsList) {
        this.delete();
        goodsList.stream().filter(a -> a.size() > 0).forEach(((CompanyGoodsHeadMapper)this.baseMapper)::insertBatch);
    }

    @Override
    public void delete() {
        ((CompanyGoodsHeadMapper)this.baseMapper).delete();
    }
}

