/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.doudian.open.api.order_searchList.OrderSearchListRequest;
import com.doudian.open.api.order_searchList.OrderSearchListResponse;
import com.doudian.open.api.order_searchList.data.OrderSearchListData;
import com.doudian.open.api.order_searchList.data.ShopOrderListItem;
import com.doudian.open.api.order_searchList.param.OrderSearchListParam;
import com.doudian.open.core.AccessToken;
import com.doudian.open.core.DoudianOpConfig;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.companystore.dto.InitDouDianPullDTO;
import com.els.modules.companystore.entity.CompanyStoreOrderHead;
import com.els.modules.companystore.mapper.CompanyStoreOrderHeadMapper;
import com.els.modules.companystore.service.CompanyStoreOrderHeadService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CompanyStoreOrderHeadServiceImpl
extends BaseServiceImpl<CompanyStoreOrderHeadMapper, CompanyStoreOrderHead>
implements CompanyStoreOrderHeadService {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreOrderHeadServiceImpl.class);
    @Autowired
    private DoudianOpConfig doudianOpConfig;

    @Override
    public void add(CompanyStoreOrderHead companyStoreOrderHead) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).insert((Object)companyStoreOrderHead);
    }

    @Override
    public void edit(CompanyStoreOrderHead companyStoreOrderHead) {
        int count = ((CompanyStoreOrderHeadMapper)this.baseMapper).updateById((Object)companyStoreOrderHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((CompanyStoreOrderHeadMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void initPull() {
        ArrayList pullDTOS = Lists.newArrayList();
        String appId = "7109351973857560100";
        String accessTokenStr = "b532c94f-84d8-49f3-9b01-b36b532573d4";
        String refreshTokenStr = "e3ae870c-835d-4fff-a098-806300a8d00c";
        AccessToken accessToken = AccessToken.wrap((String)accessTokenStr, (String)refreshTokenStr);
        InitDouDianPullDTO dto = new InitDouDianPullDTO();
        dto.setAccessToken(accessToken);
        dto.setElsAccount("307000");
        pullDTOS.add(dto);
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, -90);
        Date threeDate = calendar.getTime();
        long endTime = new Date().getTime() / 1000L;
        long startTime = threeDate.getTime() / 1000L;
        List db = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{CompanyStoreOrderHead::getOrderId}).eq(BaseEntity::getElsAccount, (Object)"307000")).eq(BaseEntity::getDeleted, (Object)"0"));
        Map<String, String> dbOrderIds = db.stream().collect(Collectors.toMap(x -> x.getOrderId(), y -> y.getOrderId()));
        long page = 0L;
        Iterator iterator = pullDTOS.iterator();
        if (iterator.hasNext()) {
            InitDouDianPullDTO init = (InitDouDianPullDTO)iterator.next();
            while (true) {
                OrderSearchListRequest request = new OrderSearchListRequest();
                request.setConfig(this.doudianOpConfig);
                OrderSearchListParam param = (OrderSearchListParam)request.getParam();
                param.setCreateTimeStart(Long.valueOf(startTime));
                param.setCreateTimeEnd(Long.valueOf(endTime));
                param.setSize(Long.valueOf(100L));
                param.setPage(Long.valueOf(page++));
                param.setOrderBy("create_time");
                param.setOrderAsc(Boolean.valueOf(false));
                OrderSearchListResponse response = (OrderSearchListResponse)request.execute(accessToken);
                if (response.isSuccess()) {
                    if (CollUtil.isEmpty((Collection)((OrderSearchListData)response.getData()).getShopOrderList())) {
                        return;
                    }
                    this.handleDb((OrderSearchListData)response.getData(), init.getElsAccount(), dbOrderIds);
                    continue;
                }
                log.error("\u5904\u7406\u603b\u8ba2\u5355\u62c9\u53d6\u5f02\u5e38{}", (Object)response.getMessage());
            }
        }
    }

    @Override
    public CompanyStoreOrderHead getByOrderIdAndShopId(String orderId, String shopId) {
        return (CompanyStoreOrderHead)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CompanyStoreOrderHead::getOrderId, (Object)orderId)).eq(BaseEntity::getDeleted, (Object)"0")).eq(CompanyStoreOrderHead::getShopId, (Object)shopId)));
    }

    private void handleDb(OrderSearchListData orderSearchListData, String elsAccount, Map<String, String> dbOrderIds) {
        List shopOrderListItems = orderSearchListData.getShopOrderList();
        ArrayList adds = Lists.newArrayList();
        ArrayList updates = Lists.newArrayList();
        for (ShopOrderListItem item : shopOrderListItems) {
            CompanyStoreOrderHead companyStoreOrderHead = new CompanyStoreOrderHead();
            companyStoreOrderHead.setPlatform(item.getBTypeDesc());
            companyStoreOrderHead.setShopId(item.getShopId().toString());
            companyStoreOrderHead.setShopId(item.getShopId().toString());
            companyStoreOrderHead.setOrderId(item.getOrderId());
            companyStoreOrderHead.setOrderStatus(item.getOrderStatus().toString());
            companyStoreOrderHead.setOrderStatusDesc(item.getOrderStatusDesc());
            companyStoreOrderHead.setPayTime(new Date(item.getPayTime() * 1000L));
            companyStoreOrderHead.setOrderTime(new Date(item.getCreateTime() * 1000L));
            long time = item.getOrderExpireTime() * 1000L;
            Date expireDate = new Date(companyStoreOrderHead.getOrderTime().getTime() + time);
            companyStoreOrderHead.setExpireTime(expireDate);
            companyStoreOrderHead.setOrderOpdateTime(new Date(item.getUpdateTime() * 1000L));
            companyStoreOrderHead.setCancelReasons(item.getCancelReason());
            companyStoreOrderHead.setOrderAmount(BigDecimal.valueOf(item.getOrderAmount()));
            companyStoreOrderHead.setPayAmount(BigDecimal.valueOf(item.getPayAmount()));
            companyStoreOrderHead.setOrderSource(item.getBTypeDesc());
            companyStoreOrderHead.setRemark(item.getSellerWords());
            companyStoreOrderHead.setSync("0");
            companyStoreOrderHead.setElsAccount(elsAccount);
            companyStoreOrderHead.setCreateTime(new Date());
            if (dbOrderIds.containsKey(item.getOrderId())) {
                companyStoreOrderHead.setId(dbOrderIds.get(item.getOrderId()));
                updates.add(companyStoreOrderHead);
                continue;
            }
            adds.add(companyStoreOrderHead);
        }
        if (CollUtil.isNotEmpty((Collection)adds)) {
            this.saveBatch(adds);
        }
        if (CollUtil.isNotEmpty((Collection)updates)) {
            this.updateBatchById(updates);
        }
    }
}

