/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTop;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.enumerate.MyGoodsSpreaderItemStatusEnum;
import com.els.modules.alliance.mapper.GoodsSquareMapper;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsSpreaderItemService;
import com.els.modules.alliance.service.MyGoodsTopService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoodsSquareServiceImpl
extends BaseServiceImpl<GoodsSquareMapper, GoodsSquare>
implements GoodsSquareService {
    @Autowired
    private MyGoodsTopService myGoodsTopService;
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private MyGoodsSpreaderItemService myGoodsSpreaderItemService;
    @Autowired
    private TemplateHeadService templateHeadService;

    @Override
    public IPage<GoodsSquare> queryPage(GoodsSquare goodsSquare, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.put("column", new String[]{"flag,update_time"});
        parameterMap.put("order", new String[]{"desc"});
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)goodsSquare), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((GoodsSquareMapper)this.baseMapper).queryPage((Page<GoodsSquare>)page, (QueryWrapper<GoodsSquare>)queryWrapper, loginUser.getElsAccount(), loginUser.getSubAccount());
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void addSpreader(String id) {
        LoginUser loginUser = SysUtil.getLoginUser();
        GoodsSquare goodsSquare = this.addSpreaderCheck(id, loginUser);
        MyGoodsSpreaderItem spreaderItem = new MyGoodsSpreaderItem();
        spreaderItem.setElsAccount(goodsSquare.getElsAccount());
        spreaderItem.setSubAccount(goodsSquare.getSubAccount());
        spreaderItem.setToElsAccount(loginUser.getElsAccount());
        spreaderItem.setToSubAccount(loginUser.getSubAccount());
        spreaderItem.setHeadId(goodsSquare.getRelationId());
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        spreaderItem.setStartTime(goodsSquare.getStartTime());
        spreaderItem.setEndTime(goodsSquare.getEndTime());
        spreaderItem.setMerchantName(goodsSquare.getMerchantName());
        spreaderItem.setSpreaderElsAccount(loginUser.getElsAccount());
        spreaderItem.setCompanyName(loginUser.getEnterpriseName());
        spreaderItem.setSpreaderSubAccount(loginUser.getSubAccount());
        spreaderItem.setSpreaderName(loginUser.getRealname());
        this.myGoodsSpreaderItemService.save((Object)spreaderItem);
        MyPromotionalHead promotional = new MyPromotionalHead();
        BeanUtils.copyProperties((Object)((Object)goodsSquare), (Object)((Object)promotional));
        promotional.setElsAccount(loginUser.getElsAccount());
        promotional.setSubAccount(loginUser.getSubAccount());
        promotional.setToElsAccount(goodsSquare.getElsAccount());
        promotional.setToSubAccount(goodsSquare.getSubAccount());
        promotional.setRelationId(goodsSquare.getRelationId());
        if ("1".equals(goodsSquare.getIsNeedConfirm())) {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue());
        } else {
            promotional.setItemStatus(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)promotional.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"myPromotional");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            promotional.setTemplateNumber(templateHead.getTemplateNumber());
            promotional.setTemplateName(templateHead.getTemplateName());
            promotional.setTemplateVersion(templateHead.getTemplateVersion());
            promotional.setTemplateAccount(templateHead.getElsAccount());
        }
        promotional.setId("");
        this.myPromotionalHeadService.save((Object)promotional);
    }

    @Override
    public void topOrCancel(String id, Boolean flag) {
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsSquare == null) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (flag.booleanValue()) {
            MyGoodsTop top = new MyGoodsTop();
            top.setElsAccount(loginUser.getElsAccount());
            top.setSubAccount(loginUser.getSubAccount());
            top.setHeadId(goodsSquare.getId());
            top.setPlatform(goodsSquare.getPlatform());
            this.myGoodsTopService.save((Object)top);
        } else {
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            this.myGoodsTopService.deleteTop(id, elsAccount, subAccount, goodsSquare.getPlatform());
        }
    }

    @Override
    public void delMain(String id) {
        ((GoodsSquareMapper)this.baseMapper).deleteByMainId(id);
    }

    private GoodsSquare addSpreaderCheck(String id, LoginUser loginUser) {
        GoodsSquare goodsSquare = (GoodsSquare)((Object)((GoodsSquareMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsSquare == null) {
            throw new ELSBootException("\u5934\u6570\u636eID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        MyGoodsSpreaderItem spreaderItem = this.myGoodsSpreaderItemService.getMyGoodsSpreaderItem(goodsSquare.getRelationId(), loginUser.getElsAccount(), loginUser.getSubAccount());
        if (spreaderItem != null) {
            throw new ELSBootException("\u5df2\u63a8\u5e7f\u8be5\u5546\u54c1");
        }
        return goodsSquare;
    }
}

