/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companyinfo.service.impl;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companyinfo.entity.McnMediumPitcherHead;
import com.els.modules.companyinfo.entity.McnMediumPitcherItem;
import com.els.modules.companyinfo.enumerate.MediumPitcherTemplateStatusEnum;
import com.els.modules.companyinfo.mapper.McnMediumPitcherHeadMapper;
import com.els.modules.companyinfo.mapper.McnMediumPitcherItemMapper;
import com.els.modules.companyinfo.service.McnMediumPitcherHeadService;
import com.els.modules.companyinfo.vo.McnMediumPitcherHeadVO;
import com.els.modules.popularize.exception.PopularizeProjectDataCheckException;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class McnMediumPitcherHeadServiceImpl
extends BaseServiceImpl<McnMediumPitcherHeadMapper, McnMediumPitcherHead>
implements McnMediumPitcherHeadService {
    @Autowired
    private McnMediumPitcherHeadMapper mcnMediumPitcherHeadMapper;
    @Autowired
    private McnMediumPitcherItemMapper mcnMediumPitcherItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(McnMediumPitcherHead mcnMediumPitcherHead, List<McnMediumPitcherItem> mcnMediumPitcherItemList) {
        if ("0".equals(mcnMediumPitcherHead.getNeedAudit())) {
            mcnMediumPitcherHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            if (mcnMediumPitcherItemList.isEmpty()) {
                mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.INVALID.getValue());
            } else {
                mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.TAKE_EFFECT.getValue());
            }
        } else {
            mcnMediumPitcherHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.INVALID.getValue());
        }
        this.mcnMediumPitcherHeadMapper.insert((Object)mcnMediumPitcherHead);
        super.setHeadDefaultValue((BaseEntity)mcnMediumPitcherHead);
        this.insertData(mcnMediumPitcherHead, mcnMediumPitcherItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(McnMediumPitcherHeadVO mcnMediumPitcherHeadPage) {
        this.validated(mcnMediumPitcherHeadPage);
        this.check(mcnMediumPitcherHeadPage.getId());
        McnMediumPitcherHead mcnMediumPitcherHead = new McnMediumPitcherHead();
        BeanUtils.copyProperties((Object)((Object)mcnMediumPitcherHeadPage), (Object)((Object)mcnMediumPitcherHead));
        LoginUser loginUser = SysUtil.getLoginUser();
        mcnMediumPitcherHead.setElsAccount(loginUser.getElsAccount());
        mcnMediumPitcherHead.setSubElsAccount(loginUser.getSubAccount());
        List<McnMediumPitcherItem> mcnMediumPitcherItemList = mcnMediumPitcherHeadPage.getMcnMediumPitcherItemList();
        if ("0".equals(mcnMediumPitcherHead.getNeedAudit())) {
            mcnMediumPitcherHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            if (mcnMediumPitcherItemList.isEmpty()) {
                mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.INVALID.getValue());
            } else {
                mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.TAKE_EFFECT.getValue());
            }
        } else {
            mcnMediumPitcherHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            mcnMediumPitcherHead.setTemplateStatus(MediumPitcherTemplateStatusEnum.INVALID.getValue());
        }
        int count = this.mcnMediumPitcherHeadMapper.updateById((Object)mcnMediumPitcherHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        this.mcnMediumPitcherItemMapper.deleteByMainId(mcnMediumPitcherHead.getId());
        this.insertData(mcnMediumPitcherHead, mcnMediumPitcherItemList);
    }

    private void check(String id) {
        McnMediumPitcherHead mcnTopmanCooperateHead = (McnMediumPitcherHead)((Object)super.getById((Serializable)((Object)id)));
        if (mcnTopmanCooperateHead == null) {
            throw new PopularizeProjectDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!"0".equals(mcnTopmanCooperateHead.getItemStatus())) {
            throw new PopularizeProjectDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u6210\u5458\u884c\u72b6\u6001\u662f\u65b0\u5efa\u7684\u5a92\u4ecb\u6295\u624b\u6548\u80fd");
        }
        if (!TenantContext.getTenant().equals(mcnTopmanCooperateHead.getElsAccount())) {
            throw new PopularizeProjectDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
        List<McnMediumPitcherItem> mcnMediumPitcherItems = this.mcnMediumPitcherItemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(mcnMediumPitcherItems)) {
            boolean flag = false;
            for (McnMediumPitcherItem mcnMediumPitcherItem : mcnMediumPitcherItems) {
                if ("4".equals(mcnMediumPitcherItem.getStatus())) continue;
                flag = true;
                break;
            }
            if (flag) {
                throw new PopularizeProjectDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u72b6\u6001\u662f\u65b0\u5efa\u7684\u5a92\u4ecb\u6295\u624b\u6548\u80fd");
            }
        }
    }

    private void insertData(McnMediumPitcherHead mcnMediumPitcherHead, List<McnMediumPitcherItem> mcnMediumPitcherItemList) {
        if (!CollectionUtils.isEmpty(mcnMediumPitcherItemList)) {
            for (McnMediumPitcherItem entity : mcnMediumPitcherItemList) {
                entity.setHeadId(mcnMediumPitcherHead.getId());
                entity.setReceiptsNum(this.invokeBaseRpcService.getNextCode("mcnMediumPitcherReceiptsNum", (Object)entity));
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)mcnMediumPitcherHead);
                entity.setStatus("4");
                entity.setItemStatus("2");
            }
            if (!mcnMediumPitcherItemList.isEmpty()) {
                this.mcnMediumPitcherItemMapper.insertBatchSomeColumn(mcnMediumPitcherItemList);
            }
        }
    }

    @Override
    public void validated(McnMediumPitcherHeadVO headVO) {
        Assert.isTrue((headVO.getCost() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notCost", (String)"\u6210\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((headVO.getVisitorVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notVisitorVolumn", (String)"\u6d4f\u89c8\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((headVO.getOrderVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notOrderVolumn", (String)"\u4e0b\u5355\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((headVO.getSalesVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notSalesVolumn", (String)"\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((headVO.getProfit() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notProfit", (String)"\u5229\u6da6\u4e0d\u80fd\u4e3a\u7a7a"));
        BigDecimal conversionRate = headVO.getOrderVolumn().divide(headVO.getVisitorVolumn(), 4, 4);
        headVO.setConversionRate(conversionRate);
        List<McnMediumPitcherItem> itemList = headVO.getMcnMediumPitcherItemList();
        if (!CollectionUtils.isEmpty(itemList)) {
            for (McnMediumPitcherItem item : itemList) {
                Assert.isTrue((item.getCost() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notCost", (String)"\u6210\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getVisitorVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notVisitorVolumn", (String)"\u6d4f\u89c8\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getOrderVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notOrderVolumn", (String)"\u4e0b\u5355\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getSalesVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notSalesVolumn", (String)"\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getProfit() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notProfit", (String)"\u5229\u6da6\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)item.getTag(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTag", (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.isTrue((item.getGrade() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notGrade", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a"));
                BigDecimal converRate = item.getOrderVolumn().divide(item.getVisitorVolumn(), 4, 4);
                item.setConversionRate(converRate);
            }
        }
    }
}

