/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companyinfo.service.impl;

import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.companyinfo.entity.McnTopmanCooperateHead;
import com.els.modules.companyinfo.mapper.McnTopmanCooperateHeadMapper;
import com.els.modules.companyinfo.service.McnTopmanCooperateHeadService;
import com.els.modules.popularize.exception.PopularizeProjectDataCheckException;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McnTopmanCooperateHeadServiceImpl
extends BaseServiceImpl<McnTopmanCooperateHeadMapper, McnTopmanCooperateHead>
implements McnTopmanCooperateHeadService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveMcnTopmanCooperateHead(McnTopmanCooperateHead mcnTopmanCooperateHead) {
        this.validated(mcnTopmanCooperateHead);
        mcnTopmanCooperateHead.setReceiptsNum(this.invokeBaseRpcService.getNextCode("mcnTopmanCooperateReceiptsNum", (Object)mcnTopmanCooperateHead));
        ((McnTopmanCooperateHeadMapper)this.baseMapper).insert((Object)mcnTopmanCooperateHead);
    }

    @Override
    public void updateMcnTopmanCooperateHead(McnTopmanCooperateHead mcnTopmanCooperateHead) {
        this.validated(mcnTopmanCooperateHead);
        this.check(mcnTopmanCooperateHead.getId());
        ((McnTopmanCooperateHeadMapper)this.baseMapper).updateById((Object)mcnTopmanCooperateHead);
    }

    private void check(String id) {
        McnTopmanCooperateHead mcnTopmanCooperateHead = (McnTopmanCooperateHead)((Object)super.getById((Serializable)((Object)id)));
        if (mcnTopmanCooperateHead == null) {
            throw new PopularizeProjectDataCheckException.NotExist("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!"0".equals(mcnTopmanCooperateHead.getStatus())) {
            throw new PopularizeProjectDataCheckException.InvalidState("\u5934\u90e8ID" + id + "\u64cd\u4f5c\u7684\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u72b6\u6001\u662f\u65b0\u5efa\u7684\u8fbe\u4eba\u6548\u80fd");
        }
        if (!TenantContext.getTenant().equals(mcnTopmanCooperateHead.getElsAccount())) {
            throw new PopularizeProjectDataCheckException.NoPermission("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c");
        }
    }

    private void validated(McnTopmanCooperateHead mcnTopmanCooperateHead) {
        Assert.hasText((String)mcnTopmanCooperateHead.getTopmanId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTopman", (String)"\u8fbe\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)mcnTopmanCooperateHead.getTopmanName(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTopman", (String)"\u8fbe\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getCost() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notCost", (String)"\u6210\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getVisitorVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notVisitorVolumn", (String)"\u6d4f\u89c8\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getOrderVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notOrderVolumn", (String)"\u4e0b\u5355\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getSalesVolumn() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notSalesVolumn", (String)"\u9500\u552e\u989d\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getProfit() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notProfit", (String)"\u5229\u6da6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)mcnTopmanCooperateHead.getTag(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTag", (String)"\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((mcnTopmanCooperateHead.getGrade() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notGrade", (String)"\u8bc4\u5206\u4e0d\u80fd\u4e3a\u7a7a"));
        BigDecimal conversionRate = mcnTopmanCooperateHead.getOrderVolumn().divide(mcnTopmanCooperateHead.getVisitorVolumn(), 4, 4);
        mcnTopmanCooperateHead.setConversionRate(conversionRate);
    }
}

