/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.vo.CountVO;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.excel.CompanyStoreHeadExportServiceImpl;
import com.els.modules.companystore.query.CompanyGoodsHeadQueryParam;
import com.els.modules.companystore.query.CompanyStoreHeadQueryParam;
import com.els.modules.companystore.query.CompanyTopmanRecordQueryParam;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreTopmanRecordService;
import com.els.modules.companystore.vo.CompanyStoreHeadVO;
import com.els.modules.companystore.vo.CompanyTopmanItemVO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/companystore/companyStoreHead"})
@Api(tags={"\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934"})
public class CompanyStoreHeadController
extends BaseController<CompanyStoreHead, CompanyStoreHeadService> {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreHeadController.class);
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private CompanyStoreTopmanRecordService companyStoreTopmanRecordService;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private SmsRpcService smsRpcService;

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868", notes="\u5e97\u94fa\u5217\u8868")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(CompanyStoreHead companyStoreHead, CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyStoreHead> queryWrapper = CompanyStoreHeadQueryParam.getQueryParam(companyStoreHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<CompanyStoreHead> pageList = this.companyStoreHeadService.queryPage((Page<CompanyStoreHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody SmsDto smsDto) {
        Result result = new Result();
        smsDto.setMobile("13799766536");
        SmsResult smsResult = this.smsRpcService.sendSms(smsDto);
        result.setSuccess(smsResult.isSuccess());
        result.setMessage(smsResult.getMessage());
        return result;
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CompanyStoreHeadVO headVO) {
        this.companyStoreHeadService.validated(headVO);
        CompanyStoreHead companyStoreHead = new CompanyStoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyStoreHead));
        companyStoreHead.setBusAccount(this.getTenantId());
        this.companyStoreHeadService.saveMain(companyStoreHead, headVO);
        return Result.ok((Object)((Object)companyStoreHead));
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5e97\u94fa\u4fe1\u606f\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody CompanyStoreHeadVO headVO) {
        this.companyStoreHeadService.validated(headVO);
        CompanyStoreHead companyStoreHead = new CompanyStoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyStoreHead));
        this.companyStoreHeadService.updateMain(companyStoreHead, headVO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5e97\u94fa\u8be6\u60c5", notes="\u5e97\u94fa\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CompanyStoreHeadVO headVO = this.companyStoreHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(CompanyStoreOrderItem item, CompanyTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyStoreOrderItem> queryWrapper = CompanyTopmanRecordQueryParam.getQueryParam(item, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyTopmanItemVO> pageList = this.companyStoreTopmanRecordService.queryTopmanPageNew((Page<CompanyStoreOrderItem>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyStoreTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyStoreTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868", notes="\u5546\u54c1\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> queryPageList(CompanyGoodsHead goodsHead, CompanyGoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyGoodsHead> queryWrapper = CompanyGoodsHeadQueryParam.getQueryParam(goodsHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("30");
        }
        this.companyGoodsHeadService.categoryConvert(queryDTO);
        IPage<CompanyGoodsHead> pageList = this.companyGoodsHeadService.queryPage((Page<CompanyGoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/categoryCounts"})
    public Result<?> contentTypeCounts(CompanyGoodsHeadQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsHeadService.categoryCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa", notes="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyStoreHeadExportServiceImpl.class);
    }
}

