/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.job;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.service.JobRpcService;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.companystore.entity.CompanyGoodsItem;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.mapper.CompanyStoreOrderItemMapper;
import com.els.modules.companystore.service.CompanyGoodsItemService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CompanyGoodsStatJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(CompanyGoodsStatJob.class);
    @Resource
    private CompanyStoreOrderItemMapper companyStoreOrderItemMapper;
    @Resource
    private CompanyGoodsItemService companyGoodsItemService;
    private List<String> dayList = new ArrayList<String>(){
        {
            this.add("1");
            this.add("7");
            this.add("30");
            this.add("90");
        }
    };

    private long getPages(int size) {
        Page page = new Page(1L, (long)size);
        IPage<CompanyStoreOrderItem> itemPage = this.companyStoreOrderItemMapper.goodsItemPage((Page<CompanyStoreOrderItem>)page);
        long pages = itemPage.getTotal() / itemPage.getSize();
        if (itemPage.getTotal() % itemPage.getSize() != 0L) {
            ++pages;
        }
        return pages;
    }

    public void execute(String parameter) {
        log.info("------------start GoodsStatJob-----------");
        try {
            int size = 5000;
            long pages = this.getPages(size);
            int i = 1;
            while ((long)i < pages + 1L) {
                Page page = new Page((long)i, (long)size);
                IPage<CompanyStoreOrderItem> itemPage = this.companyStoreOrderItemMapper.goodsItemPage((Page<CompanyStoreOrderItem>)page);
                log.info("------------insertGoodsDataItem-----------pages:" + i);
                this.insertGoodsDataItem(itemPage.getRecords());
                ++i;
            }
        }
        catch (Exception e) {
            log.error("GoodsStatJob error ", (Throwable)e);
        }
    }

    private void insertGoodsDataItem(List<CompanyStoreOrderItem> itemList) {
        List<String> goodsIds = itemList.stream().map(CompanyStoreOrderItem::getGoodsId).distinct().collect(Collectors.toList());
        Map<String, List<CompanyStoreOrderItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(CompanyStoreOrderItem::getGoodsId));
        ArrayList<List<CompanyGoodsItem>> allList = new ArrayList<List<CompanyGoodsItem>>(10);
        ArrayList dataItemList = new ArrayList(1000);
        allList.add(dataItemList);
        int i = 0;
        for (String goodsId : goodsIds) {
            List<CompanyStoreOrderItem> items = itemMap.get(goodsId);
            for (String queryDay : this.dayList) {
                List nList = (List)allList.get(i);
                CompanyGoodsItem goodsDataItem = this.getGoodsDataItem(goodsId, items, queryDay);
                nList.add(goodsDataItem);
                if (dataItemList.size() != 1000) continue;
                ++i;
                allList.add(dataItemList);
                allList.add(new ArrayList(1000));
            }
        }
        log.info("------------start GoodsStatJob cursor -----------" + i);
        this.companyGoodsItemService.deleteBatch(goodsIds);
        this.companyGoodsItemService.insertBatch(allList);
    }

    private CompanyGoodsItem getGoodsDataItem(String goodsId, List<CompanyStoreOrderItem> items, String queryDay) {
        Date[] dates = TimeTranslateUtil.dayToDate((String)queryDay);
        CompanyGoodsItem dataItem = new CompanyGoodsItem();
        BigDecimal price = BigDecimal.ZERO;
        long salesNum = 0L;
        long salesNumLive = 0L;
        long salesNumVideo = 0L;
        long topmanNum = 0L;
        long livesNum = 0L;
        long videosNum = 0L;
        BigDecimal browsesNum = BigDecimal.ZERO;
        if (items != null && items.size() > 0) {
            price = items.get(0).getPrice();
            List finalItems = items.stream().filter(h -> h.getOrderTime() != null && (h.getOrderTime().after(dates[0]) || h.getOrderTime().equals(dates[0])) && h.getOrderTime().before(dates[1])).collect(Collectors.toList());
            if (finalItems.size() > 0) {
                List videos;
                List lives = finalItems.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getLiveId())).collect(Collectors.toList());
                if (lives.size() > 0) {
                    salesNumLive = lives.stream().map(CompanyStoreOrderItem::getGoodsQuantity).reduce(0L, Long::sum);
                    livesNum = lives.stream().map(CompanyStoreOrderItem::getLiveId).distinct().count();
                }
                if ((videos = finalItems.stream().filter(h -> StringUtils.isNotBlank((CharSequence)h.getVideoId())).collect(Collectors.toList())).size() > 0) {
                    salesNumVideo = videos.stream().map(CompanyStoreOrderItem::getGoodsQuantity).reduce(0L, Long::sum);
                    videosNum = lives.stream().map(CompanyStoreOrderItem::getLiveId).distinct().count();
                }
                salesNum = salesNumLive + salesNumVideo;
                topmanNum = finalItems.stream().map(CompanyStoreOrderItem::getTopmanId).distinct().count();
            }
        }
        dataItem.setElsAccount("100000");
        dataItem.setGoodsId(goodsId);
        dataItem.setSalesNum(new BigDecimal(salesNum));
        dataItem.setSalesAmountMin(price.multiply(new BigDecimal(salesNum)));
        dataItem.setSalesAmountMax(price.multiply(new BigDecimal(salesNum)));
        dataItem.setSalesNumLive(new BigDecimal(salesNumLive));
        dataItem.setSalesNumVideo(new BigDecimal(salesNumVideo));
        dataItem.setTopmanNum(new BigDecimal(topmanNum));
        dataItem.setLivesNum(new BigDecimal(livesNum));
        dataItem.setVideosNum(new BigDecimal(videosNum));
        dataItem.setBrowsesNum(browsesNum);
        dataItem.setQueryDay(queryDay);
        dataItem.setCreateTime(new Date());
        dataItem.setCreateBy("admin");
        dataItem.setUpdateTime(new Date());
        dataItem.setUpdateBy("admin");
        return dataItem;
    }
}

