/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doudian.open.utils.SignUtil;
import com.els.common.api.service.JobRpcService;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductManageJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(ProductManageJob.class);
    @Autowired
    private DouDianProperties douDianProperties;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;

    public void execute(String parameter) {
        log.info("------------start GoodsCategoryJob-----------");
        ArrayList<List<CompanyGoodsHead>> allList = new ArrayList<List<CompanyGoodsHead>>(10);
        ArrayList entityList = new ArrayList(1000);
        allList.add(entityList);
        int i = 1;
        int nIndex = 0;
        while (true) {
            try {
                List<CompanyGoodsHead> list;
                while (!CollectionUtils.isEmpty(list = this.httpGet("4463798", "product.listV2", this.getParam(i)))) {
                    List companyGoodsHeadList = (List)allList.get(nIndex);
                    companyGoodsHeadList.addAll(list);
                    if (entityList.size() == 1000) {
                        ++nIndex;
                        allList.add(new ArrayList(1000));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        log.info("allList=" + allList);
        if (CollectionUtils.isNotEmpty(allList)) {
            this.companyGoodsHeadService.insertBatch(allList);
        }
    }

    public List<CompanyGoodsHead> httpGet(String shopId, String method, Map<String, Object> param) throws IOException {
        String line;
        String appKey = this.douDianProperties.getAppKey();
        String appSecret = this.douDianProperties.getAppSecret();
        String url = this.douDianProperties.getUrl();
        String accessToken = "b532c94f-84d8-49f3-9b01-b36b532573d4";
        String paramJson = JSON.toJSONString(param);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        String sign = SignUtil.sign((String)appKey, (String)appSecret, (String)method, (String)timestamp, (String)paramJson, (String)"2");
        String authUrl = url + "/" + method.replace(".", "/") + "?app_key=" + URLEncoder.encode(appKey, "UTF-8") + "&method=" + URLEncoder.encode(method, "UTF-8") + "&access_token=" + URLEncoder.encode(accessToken, "UTF-8") + "&timestamp=" + URLEncoder.encode(timestamp, "UTF-8") + "&v=" + URLEncoder.encode(this.douDianProperties.getVersion(), "UTF-8") + "&param_json=" + URLEncoder.encode(paramJson, "UTF-8") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
        System.out.println("authUrl=" + authUrl);
        URL urlConnect = new URL(authUrl);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        StringBuilder result = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        Map map = (Map)JSONObject.parseObject((String)result.toString(), Map.class);
        Map data = (Map)map.get("data");
        List data1 = (List)data.get("data");
        ArrayList<CompanyGoodsHead> companyGoodsHeadList = new ArrayList<CompanyGoodsHead>();
        if (CollectionUtils.isNotEmpty((Collection)data1)) {
            data1.forEach(a -> {
                CompanyGoodsHead companyGoodsHead = new CompanyGoodsHead();
                companyGoodsHead.setPicture((String)a.get("img"));
                companyGoodsHead.setCategory(this.getCatgegory((Map)a.get("category_detail")));
                companyGoodsHead.setShopId(shopId);
                companyGoodsHead.setStoreName("\u6296\u5e97\u5f00\u653e\u5e73\u53f0\u6d4b\u8bd5\u4e13\u7528\u65d7\u8230\u5e97");
                companyGoodsHead.setPrice(new BigDecimal((Integer)a.get("discount_price")));
                companyGoodsHead.setCommissionRate(new BigDecimal((Integer)a.get("cos_ratio")));
                companyGoodsHead.setName((String)a.get("name"));
                companyGoodsHead.setGoodsId(String.valueOf((Long)a.get("product_id")));
                companyGoodsHead.setPlatform("1");
                companyGoodsHead.setElsAccount("307000");
                companyGoodsHead.setCreateBy("1001");
                companyGoodsHead.setCreateTime(new Date());
                companyGoodsHead.setUpdateBy("1001");
                companyGoodsHead.setUpdateTime(new Date());
                companyGoodsHeadList.add(companyGoodsHead);
            });
        }
        return companyGoodsHeadList;
    }

    public String getCatgegory(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map.containsKey("first_cname") && StringUtils.isNotEmpty((CharSequence)map.get("first_cname"))) {
            sb.append(map.get("first_cname")).append("-");
        }
        if (map.containsKey("second_cname") && StringUtils.isNotEmpty((CharSequence)map.get("second_cname"))) {
            sb.append(map.get("second_cname")).append("-");
        }
        if (map.containsKey("third_cname") && StringUtils.isNotEmpty((CharSequence)map.get("third_cname"))) {
            sb.append(map.get("third_cname")).append("-");
        }
        if (map.containsKey("fourth_cname") && StringUtils.isNotEmpty((CharSequence)map.get("fourth_cname"))) {
            sb.append(map.get("fourth_cname")).append("-");
        }
        if (map.containsKey("fifth_cname") && StringUtils.isNotEmpty((CharSequence)map.get("fifth_cname"))) {
            sb.append(map.get("fifth_cname")).append("-");
        }
        if (map.containsKey("sixth_cname") && StringUtils.isNotEmpty((CharSequence)map.get("sixth_cname"))) {
            sb.append(map.get("sixth_cname")).append("-");
        }
        if (map.containsKey("seventh_cname") && StringUtils.isNotEmpty((CharSequence)map.get("seventh_cname"))) {
            sb.append(map.get("seventh_cname")).append("-");
        }
        if (map.containsKey("eighth_cname") && StringUtils.isNotEmpty((CharSequence)map.get("eighth_cname"))) {
            sb.append(map.get("eighth_cname")).append("-");
        }
        if (map.containsKey("ninth_cname") && StringUtils.isNotEmpty((CharSequence)map.get("ninth_cname"))) {
            sb.append(map.get("ninth_cname")).append("-");
        }
        sb = sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public Map getParam(Integer page) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(5, -90);
        Date threeDate = calendar.getTime();
        long endTime = new Date().getTime() / 1000L;
        long startTime = threeDate.getTime() / 1000L;
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("status", 0);
        map.put("check_status", 3);
        map.put("product_type", 0);
        map.put("start_time", startTime);
        map.put("end_time", endTime);
        map.put("page", page);
        map.put("size", 100);
        map.put("update_start_time", startTime);
        map.put("update_end_time", endTime);
        return map;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first_cname", "aa");
        map.put("second_cname", "bb");
        map.put("third_cname", "cc");
        map.put("fourth_cname", "");
        StringBuilder sb = new StringBuilder();
        if (map.containsKey("first_cname")) {
            sb.append(map.get("first_cname")).append("-");
        }
        if (map.containsKey("second_cname")) {
            sb.append(map.get("second_cname")).append("-");
        }
        if (map.containsKey("third_cname")) {
            sb.append(map.get("third_cname")).append("-");
        }
        if (map.containsKey("fourth_cname") && StringUtils.isNotEmpty((CharSequence)((String)map.get("fourth_cname")))) {
            sb.append(map.get("fourth_cname")).append("-");
        }
        sb = sb.delete(sb.length() - 1, sb.length());
        System.out.println("hh=" + sb.toString());
    }
}

