/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyGoodsHeadQueryParam {
    private static final Logger log = LoggerFactory.getLogger(CompanyGoodsHeadQueryParam.class);

    public static QueryWrapper<CompanyGoodsHead> getQueryParam(CompanyGoodsHead head, Map<String, String[]> parameterMap, CompanyGoodsHeadQueryDTO queryDTO) {
        String goodsRate;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), parameterMap);
        String goodsPrice = queryDTO.getGoodsPrice();
        if (StringUtils.isNotBlank((CharSequence)goodsPrice)) {
            String[] prices;
            if (goodsPrice.contains("-")) {
                prices = goodsPrice.split("-");
                queryWrapper.between((Object)"price", (Object)new BigDecimal(prices[0]), (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains("<")) {
                prices = goodsPrice.split("<");
                queryWrapper.lt((Object)"price", (Object)new BigDecimal(prices[1]));
            }
            if (goodsPrice.contains(">")) {
                prices = goodsPrice.split(">");
                queryWrapper.gt((Object)"price", (Object)new BigDecimal(prices[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(goodsRate = queryDTO.getGoodsCommissionRate()))) {
            String[] strings;
            if (goodsRate.contains("-")) {
                strings = goodsRate.split("-");
                String split = strings[0].contains("%") ? strings[0].split("%")[0] : strings[0];
                String split1 = strings[1].split("%")[0];
                queryWrapper.between((Object)"commission_rate", (Object)split, (Object)split1);
            }
            if (goodsRate.contains(">")) {
                strings = goodsRate.split(">");
                String split1 = strings[1].split("%")[0];
                queryWrapper.gt((Object)"commission_rate", (Object)split1);
            }
        }
        return queryWrapper;
    }
}

