/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.companystore.dto.CompanyGoodsTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsTopmanItem;
import com.els.modules.companystore.entity.CompanyGoodsTopmanRecord;
import com.els.modules.companystore.mapper.CompanyGoodsTopmanItemMapper;
import com.els.modules.companystore.service.CompanyGoodsTopmanItemService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGoodsTopmanItemServiceImpl
extends BaseServiceImpl<CompanyGoodsTopmanItemMapper, CompanyGoodsTopmanItem>
implements CompanyGoodsTopmanItemService {
    @Autowired
    private CompanyGoodsTopmanItemMapper companyGoodsTopmanItemMapper;

    @Override
    public List<CompanyGoodsTopmanItem> selectByMainId(String mainId) {
        return this.companyGoodsTopmanItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyGoodsTopmanRecord> statisticsList(List<CompanyGoodsTopmanRecord> list, CompanyGoodsTopmanItemQueryDTO queryDTO) {
        ArrayList<CompanyGoodsTopmanRecord> itemList = new ArrayList<CompanyGoodsTopmanRecord>();
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> recordIds = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<CompanyGoodsTopmanItem> items = this.queryList(recordIds, queryDTO);
            Map<String, CompanyGoodsTopmanItem> itemMap = items.stream().collect(Collectors.toMap(CompanyGoodsTopmanItem::getRecordId, h -> h, (k1, k2) -> k1));
            for (CompanyGoodsTopmanRecord record : list) {
                CompanyGoodsTopmanItem item = itemMap.get(record.getId());
                record.setStatisticTime(DateUtil.format((Date)record.getCreateTime(), (String)"yyyy-MM-dd"));
                if (item != null) {
                    record.setVideosNum(item.getVideosNum());
                    record.setLivesNum(item.getLivesNum());
                    record.setSalesNum(item.getSalesNum());
                    record.setSalesAmountMin(item.getSalesAmountMin());
                    record.setSalesAmountMax(item.getSalesAmountMax());
                    record.setBrowsesNum(item.getBrowsesNum());
                    record.setTopmanNum(item.getTopmanNum());
                    record.setQueryDay(item.getQueryDay());
                }
                itemList.add(record);
            }
        }
        return itemList;
    }

    @Override
    public List<CompanyGoodsTopmanItem> queryList(CompanyGoodsTopmanItemQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(CompanyGoodsTopmanItem::getQueryDay, (Object)timeSelect);
        return ((CompanyGoodsTopmanItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public CompanyGoodsTopmanItem queryTopmanItem(String recordId, String queryDay) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(CompanyGoodsTopmanItem::getQueryDay, (Object)queryDay);
        queryWrapper.eq(CompanyGoodsTopmanItem::getRecordId, (Object)recordId);
        return (CompanyGoodsTopmanItem)((Object)((CompanyGoodsTopmanItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private List<CompanyGoodsTopmanItem> queryList(List<String> recordIds, CompanyGoodsTopmanItemQueryDTO queryDTO) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(CompanyGoodsTopmanItem::getQueryDay, (Object)timeSelect);
        queryWrapper.in(CompanyGoodsTopmanItem::getRecordId, recordIds);
        return ((CompanyGoodsTopmanItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }
}

