/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.enterpriseresource.entity.ElsKsTopManResultEntity;
import com.els.modules.enterpriseresource.entity.ElsTopManParamEntity;
import com.els.modules.enterpriseresource.mapper.ElsKsTopManInformationMapper;
import com.els.modules.enterpriseresource.service.ElsKsTopManInformationService;
import com.els.modules.enterpriseresource.vo.ElsKsTopManInformationVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ElsKsTopManInformationServiceImpl
extends BaseServiceImpl<ElsKsTopManInformationMapper, ElsTopManParamEntity>
implements ElsKsTopManInformationService {
    @Override
    public IPage<ElsKsTopManResultEntity> listKsAll(SimplePostRequestParam<ElsKsTopManInformationVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        return ((ElsKsTopManInformationMapper)this.baseMapper).listKsAll((Page<ElsKsTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser());
    }

    @Override
    public IPage<ElsKsTopManResultEntity> listKsPublic(SimplePostRequestParam<ElsKsTopManInformationVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        ksQueryWrapper.eq((Object)"decideStatus", (Object)"1");
        ksQueryWrapper.isNull((Object)"leader");
        return ((ElsKsTopManInformationMapper)this.baseMapper).listKsAll((Page<ElsKsTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser());
    }

    @Override
    public IPage<ElsKsTopManResultEntity> listKsMyTopMan(SimplePostRequestParam<ElsKsTopManInformationVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        LoginUser loginUser = SysUtil.getLoginUser();
        ksQueryWrapper.eq((Object)"leader", (Object)loginUser.getSubAccount());
        return ((ElsKsTopManInformationMapper)this.baseMapper).listKsAll((Page<ElsKsTopManResultEntity>)page, ksQueryWrapper, loginUser);
    }

    private QueryWrapper<?> getKsQueryWrapper(SimplePostRequestParam<ElsKsTopManInformationVO> topManDto) {
        ElsKsTopManInformationVO filterInfo = (ElsKsTopManInformationVO)topManDto.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        ElsKsTopManInformationVO.ScreenItem screenItem = filterInfo.getScreenItem();
        this.handleInTitle(screenItem.getContentType(), query, "starTagStr");
        this.handleInTitle(screenItem.getIndustry(), query, "industryTagStr");
        this.handleInTitle(screenItem.getContentForm(), query, "mmuStarTagStr");
        List<ElsKsTopManInformationVO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
        if (starRecommendation != null && starRecommendation.size() > 0) {
            query.and(wrapper -> {
                for (ElsKsTopManInformationVO.ScreenItemField screenItemField : starRecommendation) {
                    ((QueryWrapper)wrapper.like((Object)"star_tag_ids", (Object)screenItemField)).or();
                }
            });
        }
        List<ElsKsTopManInformationVO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        block10: for (int i = 0; talentInfos != null && i < talentInfos.size(); ++i) {
            ElsKsTopManInformationVO.ScreenItemField screenItemField = talentInfos.get(i);
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, query, "fansNum");
                    continue block10;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    this.handleMinMax(value, query, "gender");
                    continue block10;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ((QueryWrapper)query.eq((Object)"provinceCode", (Object)Integer.parseInt((String)strings.get(0)))).eq((Object)"cityCode", (Object)Integer.parseInt((String)strings.get(1)));
                    continue block10;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        }
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)q.like((Object)"name", (Object)keyWord)).or(a -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"userId", (Object)keyWord);
                });
            });
        }
        if ("desc".equals(topManDto.getOrder())) {
            query.orderByDesc((Object)topManDto.getColumn());
        } else {
            query.orderByAsc((Object)topManDto.getColumn());
        }
        return query;
    }

    private void handleInTitle(List<ElsKsTopManInformationVO.ScreenItemField> list, QueryWrapper<?> query, String field) {
        if (list == null || list.size() == 0) {
            return;
        }
        List collect = list.stream().map(ElsKsTopManInformationVO.ScreenItemField::getTitle).collect(Collectors.toList());
        query.in((Object)field, collect);
    }

    private void handleMinMax(String value, QueryWrapper<?> query, String field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.between((Object)field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.le((Object)field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.ge((Object)field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }
}

