/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.amateur.entity.PurchaseAmateurHead;
import com.els.modules.amateur.mapper.PurchaseAmateurHeadMapper;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.entity.TopManElsAddMarkEntity;
import com.els.modules.enterpriseresource.entity.TopManEnterpriseInfoHeadEntity;
import com.els.modules.enterpriseresource.enumerate.DecideStatusEnum;
import com.els.modules.enterpriseresource.enumerate.DecideStatusStrategy;
import com.els.modules.enterpriseresource.exception.ElsTopManException;
import com.els.modules.enterpriseresource.mapper.TopManAddElsRecordMapper;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import com.els.modules.enterpriseresource.service.TopManElsAddMarkService;
import com.els.modules.enterpriseresource.service.TopManEnterpriseInfoHeadService;
import com.els.modules.enterpriseresource.utils.ElsTopManBaseUtils;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TopManAddElsRecordServiceImpl
extends BaseServiceImpl<TopManAddElsRecordMapper, TopManAddElsRecordEntity>
implements TopManAddElsRecordService {
    @Autowired
    private TopManEnterpriseInfoHeadService topManEnterpriseInfoHeadService;
    @Autowired
    private TopManElsAddMarkService topManElsAddMarkService;
    @Autowired
    private PurchaseAmateurHeadMapper purchaseAmateurHeadMapper;
    private final Object[] decideStatusCheck = new String[]{DecideStatusEnum.CONFIRMED.getCode(), DecideStatusEnum.TO_BE_CONFIRMED.getCode()};

    @Override
    public TopManAddElsRecordEntity queryLastRecordInfo(String platform, String topManId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(TopManAddElsRecordEntity::getPlatform, (Object)platform)).eq(TopManAddElsRecordEntity::getTopmanId, (Object)topManId)).orderByDesc(BaseEntity::getCreateTime)).last("limit 1");
        TopManAddElsRecordEntity topManAddElsRecordEntity = (TopManAddElsRecordEntity)((Object)((TopManAddElsRecordMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (topManAddElsRecordEntity == null) {
            topManAddElsRecordEntity = new TopManAddElsRecordEntity();
            topManAddElsRecordEntity.setPlatform(platform);
            topManAddElsRecordEntity.setTopmanId(topManId);
        }
        topManAddElsRecordEntity.setId(null);
        return topManAddElsRecordEntity;
    }

    @Override
    @Transactional
    public void addRecord(TopManAddElsRecordEntity entity) {
        this.checkRecordValid(entity);
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        QueryWrapper markEntityQueryWrapper = new QueryWrapper();
        markEntityQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ((LambdaQueryWrapper)markEntityQueryWrapper.lambda().eq(TopManElsAddMarkEntity::getPlatform, (Object)entity.getPlatform())).eq(TopManElsAddMarkEntity::getTopmanId, (Object)entity.getTopmanId());
        TopManElsAddMarkEntity oneMark = (TopManElsAddMarkEntity)((Object)this.topManElsAddMarkService.getOne((Wrapper)markEntityQueryWrapper));
        if (oneMark != null) {
            throw new ElsTopManException("\u5f53\u524d\u8fbe\u4eba\u5728\u60a8\u7684\u4f01\u4e1a\u4e2d\u5df2\u7ecf\u6709\u76f8\u5173\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0");
        }
        oneMark = new TopManElsAddMarkEntity();
        oneMark.setElsAccount(elsAccount);
        oneMark.setPlatform(entity.getPlatform());
        oneMark.setTopmanId(entity.getTopmanId());
        ElsTopManBaseUtils.initSysPram(oneMark);
        this.topManElsAddMarkService.save((Object)oneMark);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(TopManAddElsRecordEntity::getPlatform, (Object)entity.getPlatform())).eq(TopManAddElsRecordEntity::getTopmanId, (Object)entity.getTopmanId())).in(TopManAddElsRecordEntity::getDecideStatus, this.decideStatusCheck);
        if (((TopManAddElsRecordMapper)this.baseMapper).selectCount((Wrapper)queryWrapper) > 0) {
            throw new ElsTopManException("\u5f53\u524d\u8fbe\u4eba\u5728\u60a8\u7684\u4f01\u4e1a\u4e2d\u5df2\u7ecf\u6709\u76f8\u5173\u7684\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0");
        }
        PurchaseAmateurHead purchaseAmateurHead = this.purchaseAmateurHeadMapper.selectAmateurElsAccountByTopManId(entity.getTopmanId());
        if (purchaseAmateurHead != null) {
            entity.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
            LambdaQueryWrapper topManEnterpriseInfoQueryWrapper = new LambdaQueryWrapper();
            topManEnterpriseInfoQueryWrapper.eq(TopManEnterpriseInfoHeadEntity::getTopmanId, (Object)entity.getTopmanId());
            TopManEnterpriseInfoHeadEntity topManEnterpriseInfoHeadEntity = (TopManEnterpriseInfoHeadEntity)((Object)this.topManEnterpriseInfoHeadService.getOne((Wrapper)topManEnterpriseInfoQueryWrapper));
            if (topManEnterpriseInfoHeadEntity != null) {
                topManEnterpriseInfoHeadEntity.setAmateurElsAccount(purchaseAmateurHead.getToElsAccount());
                this.topManEnterpriseInfoHeadService.updateById((Object)topManEnterpriseInfoHeadEntity);
            }
        }
        entity.setElsAccount(elsAccount);
        entity.setSubAccount(subAccount);
        entity.setDecideStatus(DecideStatusEnum.TO_BE_CONFIRMED.getCode());
        ElsTopManBaseUtils.initSysPram(entity);
        ((TopManAddElsRecordMapper)this.baseMapper).insert((Object)entity);
    }

    @Override
    @Transactional
    public void decideStatusStrategyHandle(String id, DecideStatusStrategy decideStatusStrategy) {
        TopManAddElsRecordEntity entity = (TopManAddElsRecordEntity)((Object)((TopManAddElsRecordMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (entity == null || !entity.getElsAccount().equals(TenantContext.getTenant())) {
            throw new ElsTopManException("\u64cd\u4f5c\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String fromStatus = decideStatusStrategy.getFromStatus().getCode();
        String toStatus = decideStatusStrategy.getToStatus().getCode();
        if (!fromStatus.equals(entity.getDecideStatus())) {
            throw new ElsTopManException("\u64cd\u4f5c\u8bb0\u5f55\u7684\u786e\u8ba4\u72b6\u6001\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        entity.setDecideStatus(toStatus);
        ElsTopManBaseUtils.initSysPram(entity);
        ((TopManAddElsRecordMapper)this.baseMapper).updateById((Object)entity);
        if (DecideStatusStrategy.confirmed.equals((Object)decideStatusStrategy)) {
            this.topManEnterpriseInfoHeadService.insertOrUpdateRecordToHead(entity);
        }
        if (DecideStatusStrategy.deny.equals((Object)decideStatusStrategy) || DecideStatusStrategy.cancel.equals((Object)decideStatusStrategy)) {
            QueryWrapper markEntityQueryWrapper = new QueryWrapper();
            markEntityQueryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
            ((LambdaQueryWrapper)markEntityQueryWrapper.lambda().eq(TopManElsAddMarkEntity::getPlatform, (Object)entity.getPlatform())).eq(TopManElsAddMarkEntity::getTopmanId, (Object)entity.getTopmanId());
            this.topManElsAddMarkService.remove((Wrapper)markEntityQueryWrapper);
        }
    }

    private void checkRecordValid(TopManAddElsRecordEntity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getPlatform())) {
            throw new ElsTopManException.ParamValid("\u5e73\u53f0ID\u4e0d\u5141\u8bb8\u4e3anull");
        }
        if (StringUtils.isBlank((CharSequence)entity.getTopmanId())) {
            throw new ElsTopManException.ParamValid("\u8fbe\u4ebaID\u4e0d\u5141\u8bb8\u4e3anull");
        }
    }
}

