/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.popularize.entity.PopularizePlanItem;
import com.els.modules.popularize.entity.PopularizeProjectHead;
import com.els.modules.popularize.entity.PopularizeTopManOfCooperItem;
import com.els.modules.popularize.enumerate.PopularizeStatusEnum;
import com.els.modules.popularize.exception.PopularizeProjectDataCheckException;
import com.els.modules.popularize.mapper.PopularizeProjectHeadMapper;
import com.els.modules.popularize.mapper.PopularizeProjectItemMapper;
import com.els.modules.popularize.mapper.PopularizeTopManItemMapper;
import com.els.modules.popularize.service.PopularizeProjectHeadService;
import com.els.modules.popularize.vo.PopularizeProjectManagerVo;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PopularizeProjectHeadServiceImpl
extends BaseServiceImpl<PopularizeProjectHeadMapper, PopularizeProjectHead>
implements PopularizeProjectHeadService {
    @Autowired
    private PopularizeProjectItemMapper popularizeProjectItemMapper;
    @Autowired
    private PopularizeTopManItemMapper popularizeTopManItemMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private WorkflowAuditRpcService workflowAuditRpcService;
    private final HashMap<String, String> statusCheck = new HashMap<String, String>(2){
        {
            this.put(AuditStatusEnum.AUDIT_NEW.getValue(), "");
            this.put(AuditStatusEnum.AUDIT_REJECT.getValue(), "");
        }
    };

    @Override
    @Transactional
    public void saveMain(PopularizeProjectManagerVo popularizeProjectVo) {
        PopularizeProjectHead popularizeProjectHead = popularizeProjectVo.getPopularizeProjectHead();
        String id = popularizeProjectHead.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.checkPrivilege(id);
        } else {
            popularizeProjectHead.setSubmitStatus("0");
        }
        String newValue = PopularizeStatusEnum.NEW.getValue();
        boolean needAudit = "1".equals(popularizeProjectHead.getIsNeedAudit());
        if (newValue.equals(popularizeProjectHead.getPopularizeStatus())) {
            if (needAudit) {
                popularizeProjectHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            } else {
                popularizeProjectHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
        }
        if (StringUtils.isBlank((CharSequence)popularizeProjectHead.getPopularizeNumber())) {
            popularizeProjectHead.setPopularizeNumber(this.invokeBaseRpcService.getNextCode("popularizeProjectManagerNumber", (Object)popularizeProjectVo));
        }
        this.saveChange(popularizeProjectVo);
    }

    @Override
    @Transactional
    public void submitMain(PopularizeProjectHead popularizeProjectHead) {
        List<PopularizePlanItem> popularizePlanItem;
        String id = popularizeProjectHead.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.checkPrivilege(id);
        }
        popularizeProjectHead.setSubmitStatus("1");
        String newValue = PopularizeStatusEnum.NEW.getValue();
        String doingValue = PopularizeStatusEnum.DOING.getValue();
        boolean needAudit = "1".equals(popularizeProjectHead.getIsNeedAudit());
        boolean needToSubmitAudit = false;
        if (newValue.equals(popularizeProjectHead.getPopularizeStatus())) {
            if (needAudit) {
                popularizeProjectHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
                needToSubmitAudit = true;
            } else {
                popularizeProjectHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                popularizeProjectHead.setPopularizeStatus(doingValue);
                this.popularizeProjectItemMapper.updateBase(id);
            }
        }
        if ((popularizePlanItem = popularizeProjectHead.getPopularizePlanItem()) != null) {
            popularizePlanItem.stream().filter(item -> newValue.equals(item.getItemStatus()) && doingValue.equals(popularizeProjectHead.getPopularizeStatus())).forEach(a -> {
                a.setItemStatus(popularizeProjectHead.getPopularizeStatus());
                a.setPlanEndTimeBase(a.getPlanEndTime());
                a.setPlanStartTimeBase(a.getPlanStartTime());
                a.setPlanProjectPeriodBase(a.getPlanProjectPeriod());
            });
        }
        if (StringUtils.isBlank((CharSequence)popularizeProjectHead.getPopularizeNumber())) {
            popularizeProjectHead.setPopularizeNumber(this.invokeBaseRpcService.getNextCode("popularizeProjectManagerNumber", (Object)popularizeProjectHead));
        }
        PopularizeProjectManagerVo popularizeProjectManagerVo = new PopularizeProjectManagerVo();
        popularizeProjectManagerVo.setPopularizeProjectHead(popularizeProjectHead);
        popularizeProjectManagerVo.setPopularizePlanItem(popularizeProjectHead.getPopularizePlanItem());
        this.saveChange(popularizeProjectManagerVo);
        if (needToSubmitAudit) {
            this.submitAudit(popularizeProjectHead);
        }
    }

    private void saveChange(PopularizeProjectManagerVo popularizeProjectVo) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        PopularizeProjectHead popularizeProjectHead = popularizeProjectVo.getPopularizeProjectHead();
        this.initSysPram(popularizeProjectHead);
        super.setHeadDefaultValue((BaseEntity)popularizeProjectHead);
        popularizeProjectHead.setElsAccount(elsAccount);
        String headId = popularizeProjectHead.getId();
        if (StringUtils.isNotBlank((CharSequence)popularizeProjectHead.getId())) {
            super.updateById((Object)popularizeProjectHead);
            this.popularizeProjectItemMapper.deleteByHeadId(headId, loginUser);
            this.popularizeTopManItemMapper.deleteByHeadId(headId, loginUser);
        } else {
            super.save((Object)popularizeProjectHead);
            headId = popularizeProjectHead.getId();
        }
        List<PopularizePlanItem> planItems = popularizeProjectVo.getPopularizePlanItem();
        for (int i = 0; planItems != null && planItems.size() > 0 && (i < planItems.size() || this.popularizeProjectItemMapper.insertBatchSomeColumn(planItems) < -10); ++i) {
            PopularizePlanItem item = planItems.get(i);
            item.setId(null);
            item.setElsAccount(elsAccount);
            item.setHeadId(headId);
            this.initSysPram(item);
        }
    }

    @Override
    @Transactional
    public boolean delete(String headId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        int i = ((PopularizeProjectHeadMapper)this.baseMapper).deleteByHeadId(headId, loginUser);
        if (i <= 0) {
            throw new PopularizeProjectDataCheckException.Error(I18nUtil.translate((String)"", (String)("\u5934\u90e8ID" + headId + "\u5220\u9664\u5931\u8d25\uff0c\u786e\u8ba4\u72b6\u6001\u6216id\u662f\u5426\u6b63\u786e")));
        }
        this.popularizeProjectItemMapper.deleteByHeadId(headId, loginUser);
        this.popularizeTopManItemMapper.deleteByHeadId(headId, loginUser);
        return true;
    }

    @Override
    public void cancel(String id) {
        PopularizeProjectHead popularizeProjectHead = this.checkPrivilege(id);
        popularizeProjectHead.setPopularizeStatus(PopularizeStatusEnum.CANCELLED.getValue());
        int count = ((PopularizeProjectHeadMapper)this.baseMapper).updateById((Object)popularizeProjectHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    public void finish(String id) {
        PopularizeProjectHead popularizeProjectHead = this.checkPrivilege(id);
        popularizeProjectHead.setPopularizeStatus(PopularizeStatusEnum.FINISH.getValue());
        int count = ((PopularizeProjectHeadMapper)this.baseMapper).updateById((Object)popularizeProjectHead);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    private void submitAudit(PopularizeProjectHead popularizeProjectHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(popularizeProjectHead.getId());
        if (StringUtils.isNotBlank((CharSequence)popularizeProjectHead.getFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(popularizeProjectHead.getFlowId())));
        }
        auditInputParamVO.setBusinessType("popularProjectManagerFlow");
        auditInputParamVO.setAuditSubject("\u63a8\u5e7f\u9879\u76ee\u5355\u636e:" + popularizeProjectHead.getPopularizeNumber());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)popularizeProjectHead)));
        this.workflowAuditRpcService.submit(auditInputParamVO);
    }

    private PopularizeProjectHead checkPrivilege(String id) {
        PopularizeProjectHead popularizeProjectHead = (PopularizeProjectHead)((Object)super.getById((Serializable)((Object)id)));
        if (popularizeProjectHead == null) {
            throw new PopularizeProjectDataCheckException.NotExist(I18nUtil.translate((String)"", (String)("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664")));
        }
        if (!TenantContext.getTenant().equals(popularizeProjectHead.getElsAccount())) {
            throw new PopularizeProjectDataCheckException.NoPermission(I18nUtil.translate((String)"", (String)("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4f7f\u7528\u6b63\u89c4\u6e20\u9053\u8fdb\u884c\u672c\u6b21\u64cd\u4f5c")));
        }
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(popularizeProjectHead.getAuditStatus())) {
            throw new PopularizeProjectDataCheckException.InvalidState(I18nUtil.translate((String)"", (String)("\u4e0d\u80fd\u64cd\u4f5c\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u6570\u636e\uff08" + id + "\uff09")));
        }
        return popularizeProjectHead;
    }

    public PopularizeProjectHead getById(Serializable id) {
        PopularizeProjectHead popularizeProjectVo = (PopularizeProjectHead)((Object)super.getById(id));
        if (!TenantContext.getTenant().equals(popularizeProjectVo.getElsAccount()) || !new Integer(0).equals(popularizeProjectVo.getDeleted())) {
            return null;
        }
        String headId = popularizeProjectVo.getId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(PopularizePlanItem::getHeadId, (Object)headId);
        List popularizePlanItems = this.popularizeProjectItemMapper.selectList((Wrapper)queryWrapper);
        popularizeProjectVo.setPopularizePlanItem(popularizePlanItems);
        List<PopularizeTopManOfCooperItem> popularizeTopManItems = this.popularizeTopManItemMapper.selectListFromTalentCooper(headId, SysUtil.getLoginUser());
        popularizeProjectVo.setPopularizeTopmanItem(popularizeTopManItems);
        return popularizeProjectVo;
    }

    private void initSysPram(BaseEntity entity) {
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        entity.setCreateBy(entity.getCreateBy() == null ? subAccount : entity.getCreateBy());
        entity.setCreateTime(entity.getCreateTime() == null ? new Date() : entity.getCreateTime());
        entity.setUpdateBy(subAccount);
        entity.setDeleted(Integer.valueOf(0));
        entity.setUpdateTime(new Date());
    }
}

