/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.popularize.entity.TopmanOrderVoucher;
import com.els.modules.popularize.enumerate.TopmanOrderVoucherMoveTypeEnum;
import com.els.modules.popularize.enumerate.TopmanOrderVoucherStatusEnum;
import com.els.modules.popularize.mapper.TopmanOrderVoucherMapper;
import com.els.modules.popularize.service.TopmanOrderVoucherService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopmanOrderVoucherServiceImpl
extends BaseServiceImpl<TopmanOrderVoucherMapper, TopmanOrderVoucher>
implements TopmanOrderVoucherService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TemplateHeadService templateHeadService;

    @Override
    public void saveTopmanOrderVoucher(TopmanOrderVoucher topmanOrderVoucher) {
        if (StringUtils.isBlank((CharSequence)topmanOrderVoucher.getVoucherNum())) {
            topmanOrderVoucher.setVoucherNum(this.invokeBaseRpcService.getNextCode("topmanOrderVoucherNum", (Object)topmanOrderVoucher));
        }
        if (StringUtils.isBlank((CharSequence)topmanOrderVoucher.getTemplateNumber())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)topmanOrderVoucher.getElsAccount());
            queryWrapper.eq((Object)"business_type", (Object)"topmanOrderVoucher");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            List list = this.templateHeadService.list((Wrapper)queryWrapper);
            if (list.isEmpty()) {
                queryWrapper.clear();
                queryWrapper.eq((Object)"els_account", (Object)"100000");
                queryWrapper.eq((Object)"business_type", (Object)"topmanOrderVoucher");
                queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
                list = this.templateHeadService.list((Wrapper)queryWrapper);
            }
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                TemplateHead templateHead = (TemplateHead)list.get(0);
                topmanOrderVoucher.setTemplateNumber(templateHead.getTemplateNumber());
                topmanOrderVoucher.setTemplateName(templateHead.getTemplateName());
                topmanOrderVoucher.setTemplateVersion(templateHead.getTemplateVersion());
                topmanOrderVoucher.setTemplateAccount(templateHead.getElsAccount());
            }
        }
        topmanOrderVoucher.setMoveType(TopmanOrderVoucherMoveTypeEnum.RECEIVE.getValue());
        topmanOrderVoucher.setMoveTypeName(TopmanOrderVoucherMoveTypeEnum.RECEIVE.getDesc());
        topmanOrderVoucher.setLoanDirection(TopmanOrderVoucherMoveTypeEnum.RECEIVE.getText());
        topmanOrderVoucher.setVoucherDate(new Date());
        ((TopmanOrderVoucherMapper)this.baseMapper).insert((Object)topmanOrderVoucher);
    }

    @Override
    public void updateTopmanOrderVoucher(TopmanOrderVoucher topmanOrderVoucher) {
        ((TopmanOrderVoucherMapper)this.baseMapper).updateById((Object)topmanOrderVoucher);
    }

    @Override
    public void frozenTopmanOrderVoucher(String id) {
        TopmanOrderVoucher topmanOrderVoucher = (TopmanOrderVoucher)((Object)((TopmanOrderVoucherMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        this.check(topmanOrderVoucher);
        String status = TopmanOrderVoucherStatusEnum.NORMAL.getValue();
        Assert.isTrue((boolean)status.equals(topmanOrderVoucher.getVoucherStatus()), (String)I18nUtil.translate((String)"", (String)"\u51ed\u8bc1\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
        topmanOrderVoucher.setVoucherStatus(TopmanOrderVoucherStatusEnum.FROZEN.getValue());
        int count = ((TopmanOrderVoucherMapper)this.baseMapper).updateById((Object)topmanOrderVoucher);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void thawTopmanOrderVoucher(String id) {
        TopmanOrderVoucher topmanOrderVoucher = (TopmanOrderVoucher)((Object)((TopmanOrderVoucherMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        this.check(topmanOrderVoucher);
        String status = TopmanOrderVoucherStatusEnum.FROZEN.getValue();
        Assert.isTrue((boolean)status.equals(topmanOrderVoucher.getVoucherStatus()), (String)I18nUtil.translate((String)"", (String)"\u51ed\u8bc1\u72b6\u6001\u4e3a\u51bb\u7ed3\u7684\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
        topmanOrderVoucher.setVoucherStatus(TopmanOrderVoucherStatusEnum.NORMAL.getValue());
        int count = ((TopmanOrderVoucherMapper)this.baseMapper).updateById((Object)topmanOrderVoucher);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void chargeAgainstTopmanOrderVoucher(String id, BigDecimal quantity) {
        TopmanOrderVoucher topmanOrderVoucher = (TopmanOrderVoucher)((Object)((TopmanOrderVoucherMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        this.check(topmanOrderVoucher);
        Assert.isTrue((boolean)TopmanOrderVoucherStatusEnum.NORMAL.getValue().equals(topmanOrderVoucher.getVoucherStatus()), (String)I18nUtil.translate((String)"", (String)"\u51ed\u8bc1\u72b6\u6001\u4e3a\u6b63\u5e38\u7684\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
        Assert.isTrue((boolean)"0".equals(topmanOrderVoucher.getDeductStatus()), (String)I18nUtil.translate((String)"", (String)"\u5bf9\u8d26\u6807\u8bc6\u4e3a\u672a\u5bf9\u8d26\u7684\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
        if (quantity.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_chargeQuaLessZero", (String)"\u51b2\u9500\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0"));
        }
        BigDecimal chargeAgainstQuantity = BigDecimal.ZERO;
        List<TopmanOrderVoucher> topmanOrderVoucherList = this.selectTopmanOrderVoucher(topmanOrderVoucher.getVoucherNum(), topmanOrderVoucher.getOrderItemNumber());
        for (TopmanOrderVoucher voucher : topmanOrderVoucherList) {
            if (!TopmanOrderVoucherMoveTypeEnum.CHARGE_AGAINST_RECEIVE.getValue().equals(voucher.getMoveType())) continue;
            chargeAgainstQuantity = chargeAgainstQuantity.add(voucher.getQuantity());
        }
        BigDecimal subtract = topmanOrderVoucher.getQuantity().subtract(chargeAgainstQuantity);
        if (quantity.compareTo(subtract) > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u51b2\u9500\u603b\u6570\u91cf\u8d85\u8fc7\u5bf9\u5e94\u51ed\u8bc1\u6570\u91cf\uff0c\u672c\u6b21\u6700\u5927\u53ef\u51b2\u9500\u6570\u91cf\u4e3a: ${0}", (String[])new String[]{String.valueOf(subtract)}));
        }
        topmanOrderVoucher.setId("");
        topmanOrderVoucher.setQuantity(quantity);
        topmanOrderVoucher.setMoveType(TopmanOrderVoucherMoveTypeEnum.CHARGE_AGAINST_RECEIVE.getValue());
        topmanOrderVoucher.setMoveTypeName(TopmanOrderVoucherMoveTypeEnum.CHARGE_AGAINST_RECEIVE.getDesc());
        topmanOrderVoucher.setLoanDirection(TopmanOrderVoucherMoveTypeEnum.CHARGE_AGAINST_RECEIVE.getText());
        topmanOrderVoucher.setVoucherDate(new Date());
        ((TopmanOrderVoucherMapper)this.baseMapper).insert((Object)topmanOrderVoucher);
    }

    @Override
    public void delTopmanOrderVoucher(String id) {
        ((TopmanOrderVoucherMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchTopmanOrderVoucher(List<String> idList) {
        ((TopmanOrderVoucherMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TopmanOrderVoucher> selectByVoucherNum(String voucherNum) {
        return ((TopmanOrderVoucherMapper)this.baseMapper).selectByVoucherNum(voucherNum);
    }

    private List<TopmanOrderVoucher> selectTopmanOrderVoucher(String voucherNum, String orderItemNumber) {
        return ((TopmanOrderVoucherMapper)this.baseMapper).selectTopmanOrderVoucher(voucherNum, orderItemNumber);
    }

    private void check(TopmanOrderVoucher topmanOrderVoucher) {
        if (topmanOrderVoucher == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(topmanOrderVoucher.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5cID" + topmanOrderVoucher.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }
}

