/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.samplesend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.samplesend.entity.MerchandiseInventoryHead;
import com.els.modules.samplesend.entity.MerchandiseInventoryItem;
import com.els.modules.samplesend.mapper.MerchandiseInventoryHeadMapper;
import com.els.modules.samplesend.mapper.MerchandiseInventoryItemMapper;
import com.els.modules.samplesend.service.MerchandiseInventoryHeadService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchandiseInventoryHeadServiceImpl
extends BaseServiceImpl<MerchandiseInventoryHeadMapper, MerchandiseInventoryHead>
implements MerchandiseInventoryHeadService {
    @Autowired
    private MerchandiseInventoryItemMapper merchandiseInventoryItemMapper;

    public MerchandiseInventoryHead getById(Serializable id) {
        MerchandiseInventoryHead merchandiseInventoryHead = (MerchandiseInventoryHead)((Object)super.getById(id));
        if (!TenantContext.getTenant().equals(merchandiseInventoryHead.getElsAccount()) || !CommonConstant.DEL_FLAG_0.equals(merchandiseInventoryHead.getDeleted())) {
            return null;
        }
        String headId = merchandiseInventoryHead.getId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MerchandiseInventoryItem::getHeadId, (Object)headId);
        List merchandiseInventoryItems = this.merchandiseInventoryItemMapper.selectList((Wrapper)queryWrapper);
        merchandiseInventoryHead.setItems(merchandiseInventoryItems);
        return merchandiseInventoryHead;
    }

    @Override
    public List<MerchandiseInventoryHead> listByMaterialNumbers(List<String> materialNumberList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).in(MerchandiseInventoryHead::getSupplierNo, materialNumberList);
        return super.list((Wrapper)queryWrapper);
    }

    @Override
    public int insertBatch(Collection<MerchandiseInventoryHead> entityList) {
        return ((MerchandiseInventoryHeadMapper)this.baseMapper).insertBatch(entityList);
    }

    @Override
    public int updateBatch(Collection<MerchandiseInventoryHead> entityList) {
        return ((MerchandiseInventoryHeadMapper)this.baseMapper).updateBatch(entityList);
    }
}

