/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.alliance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.alliance.entity.GoodsSquare;
import com.els.modules.alliance.entity.MyGoodsHead;
import com.els.modules.alliance.entity.MyGoodsSpreaderItem;
import com.els.modules.alliance.entity.MyGoodsTop;
import com.els.modules.alliance.entity.MyPromotionalHead;
import com.els.modules.alliance.enumerate.MyGoodsSpreaderItemStatusEnum;
import com.els.modules.alliance.enumerate.MyGoodsStatusEnum;
import com.els.modules.alliance.mapper.MyGoodsHeadMapper;
import com.els.modules.alliance.mapper.MyGoodsSpreaderItemMapper;
import com.els.modules.alliance.service.GoodsSquareService;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.alliance.service.MyGoodsTopService;
import com.els.modules.alliance.service.MyPromotionalHeadService;
import com.els.modules.alliance.vo.MyGoodsHeadVO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.enumerate.TemplateStatusEnum;
import com.els.modules.template.service.TemplateHeadService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MyGoodsHeadServiceImpl
extends BaseServiceImpl<MyGoodsHeadMapper, MyGoodsHead>
implements MyGoodsHeadService {
    @Autowired
    private MyGoodsHeadMapper myGoodsHeadMapper;
    @Autowired
    private MyGoodsSpreaderItemMapper myGoodsSpreaderItemMapper;
    @Autowired
    private GoodsSquareService goodsSquareService;
    @Autowired
    private MyGoodsTopService myGoodsTopService;
    @Autowired
    private MyPromotionalHeadService myPromotionalHeadService;
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private TemplateHeadService templateHeadService;

    @Override
    public IPage<MyGoodsHead> queryPage(MyGoodsHead myGoodsHead, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        Map parameterMap = req.getParameterMap();
        parameterMap.put("column", new String[]{"flag,update_time"});
        parameterMap.put("order", new String[]{"desc"});
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)myGoodsHead), (Map)parameterMap);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        String tab = "";
        String[] tabs = (String[])parameterMap.get("tab");
        if (tabs != null && tabs.length > 0) {
            tab = tabs[0];
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StringUtils.isBlank((CharSequence)tab)) {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        } else {
            queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        }
        return ((MyGoodsHeadMapper)this.baseMapper).queryPage((Page<MyGoodsHead>)page, (QueryWrapper<MyGoodsHead>)queryWrapper, loginUser.getElsAccount(), loginUser.getSubAccount());
    }

    @Override
    public List<CountVO> queryTabsCount(MyGoodsHead myGoodsHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        LoginUser loginUser = SysUtil.getLoginUser();
        List<MyGoodsHead> list = this.listByElsAccount(myGoodsHead, req, loginUser.getElsAccount());
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "tab", "", Integer.valueOf(list.size())));
        int total = 0;
        if (CollectionUtil.isNotEmpty(list)) {
            total = (int)list.stream().filter(h -> loginUser.getSubAccount().equals(h.getSubAccount())).count();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_my_goods", (String)"\u6211\u7684\u5546\u54c1"), "tab", "1", Integer.valueOf(total)));
        return result;
    }

    private List<MyGoodsHead> listByElsAccount(MyGoodsHead myGoodsHead, HttpServletRequest req, String elsAccount) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)myGoodsHead), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        return ((MyGoodsHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public MyGoodsHead saveMain(MyGoodsHeadVO headVO) {
        this.saveCheck(headVO);
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        LoginUser loginUser = SysUtil.getLoginUser();
        goodsHead.setSubAccount(loginUser.getSubAccount());
        goodsHead.setMerchantName(loginUser.getEnterpriseName());
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.NEW.getValue());
        this.goodsData(goodsHead, headVO.getGoodsId());
        this.myGoodsHeadMapper.insert((Object)goodsHead);
        return goodsHead;
    }

    @Override
    public MyGoodsHead copyMain(MyGoodsHeadVO headVO) {
        this.copyCheck(headVO);
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        LoginUser loginUser = SysUtil.getLoginUser();
        head.setGoodsStatus(MyGoodsStatusEnum.NEW.getValue());
        head.setSubAccount(loginUser.getSubAccount());
        head.setStartTime(null);
        head.setEndTime(null);
        head.setElsAccount(loginUser.getElsAccount()).setCreateBy(loginUser.getSubAccount()).setCreateTime(new Date()).setUpdateBy(loginUser.getSubAccount()).setUpdateTime(new Date()).setId(IdWorker.getIdStr());
        this.myGoodsHeadMapper.insert((Object)head);
        return head;
    }

    @Override
    public MyGoodsHead updateMain(MyGoodsHeadVO headVO) {
        this.updateCheck(headVO);
        MyGoodsHead goodsHead = new MyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)goodsHead));
        this.goodsData(goodsHead, headVO.getGoodsId());
        this.updateById((Object)goodsHead);
        return goodsHead;
    }

    private void goodsData(MyGoodsHead goodsHead, String goodsId) {
        CompanyGoodsHead companyGoodsHead = this.companyGoodsHeadService.selectByGoodsId(goodsId);
        if (companyGoodsHead != null) {
            goodsHead.setTopmanNum(companyGoodsHead.getTopmanNum() != null ? companyGoodsHead.getTopmanNum() : BigDecimal.ZERO);
            goodsHead.setVideosNum(companyGoodsHead.getVideosNum() != null ? companyGoodsHead.getVideosNum() : BigDecimal.ZERO);
            goodsHead.setLivesNum(companyGoodsHead.getLivesNum() != null ? companyGoodsHead.getLivesNum() : BigDecimal.ZERO);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void submit(MyGoodsHeadVO headVO) {
        this.submitCheck(headVO.getId());
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)headVO.getId())));
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.LOADING.getValue());
        ((MyGoodsHeadMapper)this.baseMapper).updateById((Object)goodsHead);
        GoodsSquare goodsSquare = new GoodsSquare();
        BeanUtils.copyProperties((Object)((Object)goodsHead), (Object)((Object)goodsSquare));
        goodsSquare.setRelationId(goodsHead.getId());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)goodsSquare.getElsAccount());
        queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
        queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
        List list = this.templateHeadService.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"els_account", (Object)"100000");
            queryWrapper.eq((Object)"business_type", (Object)"goodsSquare");
            queryWrapper.eq((Object)"template_status", (Object)TemplateStatusEnum.GENERATED.getValue());
            list = this.templateHeadService.list((Wrapper)queryWrapper);
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            TemplateHead templateHead = (TemplateHead)list.get(0);
            goodsSquare.setTemplateNumber(templateHead.getTemplateNumber());
            goodsSquare.setTemplateName(templateHead.getTemplateName());
            goodsSquare.setTemplateVersion(templateHead.getTemplateVersion());
            goodsSquare.setTemplateAccount(templateHead.getElsAccount());
        }
        goodsSquare.setId("");
        this.goodsSquareService.save((Object)goodsSquare);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void soldOut(String id) {
        this.soldOutCheck(id);
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        goodsHead.setGoodsStatus(MyGoodsStatusEnum.UNLOADING.getValue());
        ((MyGoodsHeadMapper)this.baseMapper).updateById((Object)goodsHead);
        this.goodsSquareService.delMain(id);
        this.myPromotionalHeadService.soldOutByRelationId(goodsHead.getId());
    }

    @Override
    public void topOrCancel(String id, Boolean flag) {
        MyGoodsHead goodsHead = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (goodsHead == null) {
            return;
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        if (flag.booleanValue()) {
            MyGoodsTop goodsTop = new MyGoodsTop();
            goodsTop.setElsAccount(loginUser.getElsAccount());
            goodsTop.setSubAccount(loginUser.getSubAccount());
            goodsTop.setHeadId(goodsHead.getId());
            goodsTop.setPlatform(goodsHead.getPlatform());
            this.myGoodsTopService.save((Object)goodsTop);
        } else {
            String elsAccount = loginUser.getElsAccount();
            String subAccount = loginUser.getSubAccount();
            this.myGoodsTopService.deleteTop(id, elsAccount, subAccount, goodsHead.getPlatform());
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.deleteCheck(id);
        this.myGoodsSpreaderItemMapper.deleteByMainId(id);
        this.myGoodsHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void confirmOrRefund(String id, Boolean flag) {
        this.confirmCheck(id);
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if (flag.booleanValue()) {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue());
            updateWrapper.set(MyPromotionalHead::getItemStatus, (Object)MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue());
        } else {
            spreaderItem.setItemStatus(MyGoodsSpreaderItemStatusEnum.REFUND.getValue());
            updateWrapper.set(MyPromotionalHead::getItemStatus, (Object)MyGoodsSpreaderItemStatusEnum.REFUND.getValue());
        }
        updateWrapper.eq(MyPromotionalHead::getRelationId, (Object)spreaderItem.getHeadId());
        this.myGoodsSpreaderItemMapper.updateById((Object)spreaderItem);
        this.myPromotionalHeadService.update((Wrapper)updateWrapper);
    }

    private List<MyGoodsHead> listByGoodsId(String goodsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(MyGoodsHead::getGoodsId, (Object)goodsId);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
        return ((MyGoodsHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    private void saveCheck(MyGoodsHead goodsHead) {
        List<MyGoodsHead> list = this.listByGoodsId(goodsHead.getGoodsId());
        if (CollectionUtil.isNotEmpty(list)) {
            throw new ELSBootException("\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u6570\u636e");
        }
    }

    private void copyCheck(MyGoodsHead goodsHead) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)goodsHead.getId())));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.UNLOADING.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u4e0b\u67b6\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void updateCheck(MyGoodsHead goodsHead) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)goodsHead.getId())));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + goodsHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void submitCheck(String id) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
        Assert.hasText((String)head.getGoodsType(), (String)I18nUtil.translate((String)"i18n_alert_empty_notGoodsType", (String)"\u9009\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)head.getPlatform(), (String)I18nUtil.translate((String)"i18n_alert_empty_notPlatform", (String)"\u7535\u5546\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)head.getGoodsId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notGoodsId", (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)head.getShopId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notShopId", (String)"\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((head.getCommissionServerRate() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notCommissionServerRate", (String)"\u7eaf\u4f63\u670d\u52a1\u8d39\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((head.getXingtuServerRate() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notXingtuServerRate", (String)"\u661f\u56fe\u670d\u52a1\u8d39\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((head.getOrganizationServerRate() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notOrganizationServerRate", (String)"\u673a\u6784\u670d\u52a1\u8d39\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)head.getStartTime(), (String)I18nUtil.translate((String)"i18n_alert_empty_notStartTime", (String)"\u63a8\u5e7f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)head.getEndTime(), (String)I18nUtil.translate((String)"i18n_alert_empty_notEndTime", (String)"\u63a8\u5e7f\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a"));
        if (head.getStartTime().getTime() < DateUtil.parse((CharSequence)new SimpleDateFormat("yyyy-MM-dd").format(new Date())).getTime()) {
            throw new ELSBootException("\u63a8\u5e7f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (head.getEndTime().getTime() < head.getStartTime().getTime()) {
            throw new ELSBootException("\u63a8\u5e7f\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u63a8\u5e7f\u5f00\u59cb\u65e5\u671f");
        }
        List list = this.listByGoodsId(head.getGoodsId()).stream().filter(h -> !id.equals(h.getId()) && MyGoodsStatusEnum.LOADING.getValue().equals(h.getGoodsStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(list)) {
            for (MyGoodsHead h2 : list) {
                boolean flag = false;
                if ((head.getStartTime().after(h2.getStartTime()) || head.getStartTime().equals(h2.getStartTime())) && (head.getStartTime().before(h2.getEndTime()) || head.getStartTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if ((head.getEndTime().after(h2.getStartTime()) || head.getEndTime().equals(h2.getStartTime())) && (head.getEndTime().before(h2.getEndTime()) || head.getEndTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if ((head.getStartTime().before(h2.getStartTime()) || head.getStartTime().equals(h2.getStartTime())) && (head.getEndTime().after(h2.getEndTime()) || head.getEndTime().equals(h2.getEndTime()))) {
                    flag = true;
                }
                if (!flag) continue;
                throw new ELSBootException("\u63a8\u5e7f\u65e5\u671f\u5b58\u5728\u91cd\u590d");
            }
        }
    }

    private void soldOutCheck(String id) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.LOADING.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u4e0a\u67b6\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void deleteCheck(String id) {
        MyGoodsHead head = (MyGoodsHead)((Object)((MyGoodsHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (head == null) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!head.getGoodsStatus().equals(MyGoodsStatusEnum.NEW.getValue())) {
            throw new ELSBootException("\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(head.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    private void confirmCheck(String id) {
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        if (spreaderItem == null) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.UNCONFIRMED.getValue())) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u5f85\u786e\u8ba4\u7684\u884c\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(spreaderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u884c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void addSampleCheck(String id) {
        MyGoodsSpreaderItem spreaderItem = (MyGoodsSpreaderItem)((Object)this.myGoodsSpreaderItemMapper.selectById((Serializable)((Object)id)));
        if (spreaderItem == null) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.CONFIRMED.getValue()) && !spreaderItem.getItemStatus().equals(MyGoodsSpreaderItemStatusEnum.NEEDLESS.getValue())) {
            throw new ELSBootException("\u884c\u6570\u636eID\uff1a" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u6216\u4e0d\u9700\u786e\u8ba4\u7684\u884c\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(spreaderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u884c\u6570\u636eID\uff1a" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }
}

