/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.amateur.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.amateur.entity.PurchaseAmateurItem;
import com.els.modules.amateur.enumerate.AmateurStatusItemEnum;
import com.els.modules.amateur.mapper.PurchaseAmateurItemMapper;
import com.els.modules.amateur.rpc.service.InvokeAccountInfoService;
import com.els.modules.amateur.service.PurchaseAmateurHeadService;
import com.els.modules.amateur.service.PurchaseAmateurItemService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.mapper.TopManAddElsRecordMapper;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PurchaseAmateurItemServiceImpl
extends BaseServiceImpl<PurchaseAmateurItemMapper, PurchaseAmateurItem>
implements PurchaseAmateurItemService {
    @Autowired
    private TopManAddElsRecordMapper topManAddElsRecordMapper;
    @Autowired
    private InvokeAccountInfoService invokeAccountInfoService;
    @Autowired
    private TopManAddElsRecordService topManAddElsRecordServie;
    @Lazy
    @Autowired
    private PurchaseAmateurHeadService purchaseAmateurHeadService;

    @Override
    public List<PurchaseAmateurItem> selectByMainId(String mainId) {
        return ((PurchaseAmateurItemMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseAmateurItemMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void freezenOrUnFreezenById(String id) {
        PurchaseAmateurItem purchaseAmateurItem = (PurchaseAmateurItem)((Object)this.getById((Serializable)((Object)id)));
        if (purchaseAmateurItem == null) {
            throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u8be5\u884c\u8bb0\u5f55\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5");
        }
        PurchaseAmateurItem paramsPurchaseAmateurItem = new PurchaseAmateurItem();
        paramsPurchaseAmateurItem.setId(id);
        if (AmateurStatusItemEnum.EFFECT.getValue().equals(purchaseAmateurItem.getItemStatus())) {
            paramsPurchaseAmateurItem.setItemStatus(AmateurStatusItemEnum.FREEZEN.getValue());
        } else if (AmateurStatusItemEnum.FREEZEN.getValue().equals(purchaseAmateurItem.getItemStatus())) {
            paramsPurchaseAmateurItem.setItemStatus(AmateurStatusItemEnum.EFFECT.getValue());
        }
        this.updateById((Object)paramsPurchaseAmateurItem);
    }

    @Override
    public List<ElsEnterpriseInfoDTO> selectPurchaseEnterpriseInfoList(String toElsAccount) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(TopManAddElsRecordEntity::getAmateurElsAccount, (Object)toElsAccount);
        List topManAddElsRecordEntities = this.topManAddElsRecordMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)topManAddElsRecordEntities)) {
            List<String> elsAccounts = topManAddElsRecordEntities.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            List<ElsEnterpriseInfoDTO> elsEnterpriseInfoDTOList = this.invokeAccountInfoService.selectEnterpriseInfoListByToElsAcounts(elsAccounts);
            return elsEnterpriseInfoDTOList;
        }
        return null;
    }
}

