/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.companystore.dto.CompanyStoreQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.excel.CompanyStoreOrderExportServiceImpl;
import com.els.modules.companystore.service.CompanyStoreOrderItemService;
import com.els.modules.companystore.vo.CompanyStoreOrderItemVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5e97\u94fa\u8ba2\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/companystore/companyStoreOrderItem"})
public class CompanyStoreOrderItemController
extends BaseController<CompanyStoreOrderItem, CompanyStoreOrderItemService> {
    @Autowired
    private CompanyStoreOrderItemService companyStoreOrderItemService;
    @Autowired
    private AccountRpcService accountRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<?> listAll(@RequestBody SimplePostRequestParam<CompanyStoreOrderItemVO> param) {
        try {
            IPage<CompanyStoreOrderItem> pageList = this.companyStoreOrderItemService.listAll(param);
            return Result.ok(pageList);
        }
        catch (IllegalAccessException e) {
            return Result.error((String)I18nUtil.translate((String)"", (String)"\u53c2\u6570\u8f6c\u6362\u5f02\u5e38"));
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u8d1f\u8d23\u4eba", notes="\u83b7\u53d6\u8d1f\u8d23\u4eba")
    @GetMapping(value={"/getLeaders"})
    public Result<?> getLeaders() {
        final List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        CompanyStoreOrderItemVO.ParamDic dic = new CompanyStoreOrderItemVO.ParamDic();
        dic.setFatherType("OtherOrderInformation");
        dic.setValue("Leader");
        dic.setDescription("select");
        dic.setText("\u8d1f\u8d23\u4eba");
        dic.setOption((List<DictModel>)new ArrayList<DictModel>(allByAccount.size() + 1){
            {
                super(x0);
                this.add(new DictModel("\u65e0", "\u65e0"));
                allByAccount.forEach((? super T a) -> this.add(new DictModel(a.getSubAccount(), a.getRealname())));
            }
        });
        return Result.ok((Object)((Object)dic));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e97\u94fa", notes="\u83b7\u53d6\u5e97\u94fa")
    @GetMapping(value={"/getStores"})
    public Result<?> getStores() {
        final List<CompanyStoreQueryDTO> allStore = this.companyStoreOrderItemService.getStores(TenantContext.getTenant());
        CompanyStoreOrderItemVO.ParamDic dic = new CompanyStoreOrderItemVO.ParamDic();
        dic.setFatherType("OrderConditionFilter");
        dic.setValue("Store");
        dic.setDescription("select");
        dic.setText("\u6240\u5c5e\u5e97\u94fa");
        dic.setOption((List<DictModel>)new ArrayList<DictModel>(allStore.size() + 1){
            {
                super(x0);
                this.add(new DictModel("\u65e0", "\u65e0"));
                allStore.forEach((? super T a) -> this.add(new DictModel(a.getStoreId(), a.getStoreName())));
            }
        });
        return Result.ok((Object)((Object)dic));
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, final @RequestParam(value="param") String param) {
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("ids", param.split(","));
            }
        };
        return super.exportXls(request, (Map)map, CompanyStoreOrderExportServiceImpl.class);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CompanyStoreOrderItem companyStoreOrderItem = (CompanyStoreOrderItem)((Object)this.companyStoreOrderItemService.getById((Serializable)((Object)id)));
        String topManKeyId = ((CompanyStoreOrderItemService)this.service).getKeyIdOfTopMan(companyStoreOrderItem.getPlatform(), companyStoreOrderItem.getTopmanId());
        companyStoreOrderItem.setTopManKeyId(topManKeyId);
        return Result.ok((Object)((Object)companyStoreOrderItem));
    }

    @GetMapping(value={"/init"})
    public Result<?> init(@RequestParam(name="id", required=false) String id) {
        this.companyStoreOrderItemService.init(id);
        return Result.ok();
    }
}

