/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.query;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreHead;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyStoreHeadQueryParam {
    private static final Logger log = LoggerFactory.getLogger(CompanyStoreHeadQueryParam.class);

    public static QueryWrapper<CompanyStoreHead> getQueryParam(CompanyStoreHead head, Map<String, String[]> parameterMap, CompanyStoreHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String salesAmount;
        String videosNum;
        String topman;
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), parameterMap);
        String experienceNum = queryDTO.getStoreExperienceNum();
        if (StringUtils.isNotBlank((CharSequence)experienceNum) && experienceNum.contains("-")) {
            String[] strings = experienceNum.split("-");
            queryWrapper.between((Object)"experience_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
        }
        if (StringUtils.isNotBlank((CharSequence)(topman = queryDTO.getStoreTopmanNum()))) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.between((Object)"topman_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.gt((Object)"topman_num", (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.eq((Object)"topman_num", (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
            String[] strings;
            if (videosNum.contains("-")) {
                strings = videosNum.split("-");
                queryWrapper.between((Object)"videos_num", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (videosNum.contains(">")) {
                strings = videosNum.split(">");
                queryWrapper.gt((Object)"videos_num", (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
            String[] strings;
            if (salesAmount.contains("-")) {
                strings = salesAmount.split("-");
                queryWrapper.between((Object)"sales_amount_max", (Object)new BigDecimal(strings[0]), (Object)new BigDecimal(strings[1]));
            }
            if (salesAmount.contains(">")) {
                strings = salesAmount.split(">");
                queryWrapper.gt((Object)"sales_amount_max", (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.gt((Object)"lives_num", (Object)BigDecimal.ZERO);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.gt((Object)"videos_num", (Object)BigDecimal.ZERO);
        }
        return queryWrapper;
    }
}

