/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreItem;
import com.els.modules.companystore.mapper.CompanyStoreItemMapper;
import com.els.modules.companystore.service.CompanyStoreItemService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyStoreItemServiceImpl
extends BaseServiceImpl<CompanyStoreItemMapper, CompanyStoreItem>
implements CompanyStoreItemService {
    @Autowired
    private CompanyStoreItemMapper companyStoreItemMapper;

    @Override
    public List<CompanyStoreItem> selectByMainId(String mainId) {
        return this.companyStoreItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyStoreItem> queryList(CompanyStoreHeadQueryDTO queryDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        this.criteriaQuery((QueryWrapper<CompanyStoreItem>)queryWrapper, queryDTO);
        return ((CompanyStoreItemMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public CompanyStoreItem queryStoreItem(String headId, String timeSelect) {
        LambdaQueryWrapper queryWrapper = new QueryWrapper().lambda();
        queryWrapper.eq(CompanyStoreItem::getHeadId, (Object)headId);
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.eq(CompanyStoreItem::getQueryDay, (Object)timeSelect);
        return (CompanyStoreItem)((Object)((CompanyStoreItemMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private QueryWrapper<CompanyStoreItem> criteriaQuery(QueryWrapper<CompanyStoreItem> queryWrapper, CompanyStoreHeadQueryDTO queryDTO) {
        Boolean goodsVideo;
        Boolean goodsLive;
        String salesAmount;
        String videosNum;
        String timeSelect = queryDTO.getTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "1";
        }
        queryWrapper.lambda().eq(CompanyStoreItem::getQueryDay, (Object)timeSelect);
        String topman = queryDTO.getStoreTopmanNum();
        if (StringUtils.isNotBlank((CharSequence)topman)) {
            String[] strings;
            if (topman.contains("-")) {
                strings = topman.split("-");
                queryWrapper.lambda().gt(CompanyStoreItem::getTopmanNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(CompanyStoreItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else if (topman.contains(">")) {
                strings = topman.split(">");
                queryWrapper.lambda().gt(CompanyStoreItem::getTopmanNum, (Object)new BigDecimal(strings[1]));
            } else {
                queryWrapper.lambda().eq(CompanyStoreItem::getTopmanNum, (Object)topman);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(videosNum = queryDTO.getStoreVideosNum()))) {
            String[] strings;
            if (videosNum.contains("-")) {
                strings = videosNum.split("-");
                queryWrapper.lambda().gt(CompanyStoreItem::getVideosNum, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(CompanyStoreItem::getVideosNum, (Object)new BigDecimal(strings[1]));
            }
            if (videosNum.contains(">")) {
                strings = videosNum.split(">");
                queryWrapper.lambda().gt(CompanyStoreItem::getVideosNum, (Object)new BigDecimal(strings[1]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(salesAmount = queryDTO.getStoreSalesAmount()))) {
            String[] strings;
            if (salesAmount.contains("-")) {
                strings = salesAmount.split("-");
                queryWrapper.lambda().gt(CompanyStoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[0]));
                queryWrapper.lambda().le(CompanyStoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[1]));
            }
            if (salesAmount.contains(">")) {
                strings = salesAmount.split(">");
                queryWrapper.lambda().gt(CompanyStoreItem::getSalesAmountMax, (Object)new BigDecimal(strings[1]));
            }
        }
        if ((goodsLive = queryDTO.getGoodsLive()) != null && goodsLive.booleanValue()) {
            queryWrapper.lambda().isNotNull(CompanyStoreItem::getLivesNum);
        }
        if ((goodsVideo = queryDTO.getGoodsVideo()) != null && goodsVideo.booleanValue()) {
            queryWrapper.lambda().isNotNull(CompanyStoreItem::getVideosNum);
        }
        return queryWrapper;
    }
}

