/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.adapter;

import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.adapter.Adapter;
import com.els.modules.companystore.entity.CompanyStoreOrderHead;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.enumerate.OrderStatusEnum;
import com.els.modules.companystore.service.CompanyStoreOrderHeadService;
import com.els.modules.companystore.service.CompanyStoreOrderItemService;
import com.els.modules.message.adapter.DouDianAdapter;
import com.els.modules.message.adapter.DouDianMessageContext;
import com.els.modules.message.enumerate.MessageTagTypeEnum;
import com.els.modules.message.vo.DouDianMessageVO;
import com.els.modules.message.vo.DouDianOrderMessageConvertVo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"order"})
public class DouDianOrderMessageAdapter
extends DouDianAdapter {
    private static final Logger log = LoggerFactory.getLogger(DouDianOrderMessageAdapter.class);
    @Autowired
    private CompanyStoreOrderHeadService companyStoreOrderHeadService;
    @Autowired
    private CompanyStoreOrderItemService companyStoreOrderItemService;

    @Override
    public void handleBefore(DouDianMessageContext douDianMessageContext) {
        String shopId;
        JSONObject json = JSONObject.parseObject((String)douDianMessageContext.getDouDianMessageVO().getData().toString());
        String orderId = json.getString("p_id");
        CompanyStoreOrderHead head = this.companyStoreOrderHeadService.getByOrderIdAndShopId(orderId, shopId = json.getString("shop_id"));
        if (ObjectUtil.isEmpty((Object)((Object)head))) {
            Pair<CompanyStoreOrderHead, List<CompanyStoreOrderItem>> pair = this.companyStoreOrderItemService.pullOrder(orderId);
            douDianMessageContext.getDb().setHead((CompanyStoreOrderHead)((Object)pair.getKey()));
            douDianMessageContext.getDb().setItems((List)pair.getValue());
            douDianMessageContext.setHandleMessage(false);
        } else {
            douDianMessageContext.getDb().setHead(head);
            List<CompanyStoreOrderItem> items = this.companyStoreOrderItemService.listByHeadId(head.getId());
            douDianMessageContext.getDb().setItems(items);
        }
    }

    @Override
    public void handleMessage(DouDianMessageContext douDianMessageContext) {
        DouDianMessageVO message = douDianMessageContext.getDouDianMessageVO();
        log.info("handle order message start");
        log.info("message is {}", JSON.toJSON((Object)message));
        MessageTagTypeEnum messageTagTypeEnum = MessageTagTypeEnum.getMessageTagTypeByCode(message.getTag());
        switch (messageTagTypeEnum) {
            case ORDER_TRADE_CREATE: {
                this.crate(douDianMessageContext, message);
                break;
            }
            case ORDER_TRADE_PAID: {
                this.payConfirm(douDianMessageContext, message);
                break;
            }
            case ORDER_TRADE_SELLER_SHIP: {
                this.ship(douDianMessageContext, message);
                break;
            }
            case ORDER_TRADE_SUCCESS: {
                this.complete(douDianMessageContext, message);
                break;
            }
            case ORDER_TRADE_CANCELED: {
                this.cancel(douDianMessageContext, message);
                break;
            }
        }
        log.info("handle order message end");
    }

    private void handleDbOrder(DouDianMessageContext context, OrderStatusEnum orderStatus) {
        CompanyStoreOrderHead head = context.getDb().getHead();
        List<CompanyStoreOrderItem> items = context.getDb().getItems();
        head.setOrderStatus(orderStatus.getValue());
        head.setOrderStatusDesc(orderStatus.getDesc());
        items.forEach(item -> {
            item.setOrderStatus(orderStatus.getValue());
            item.setOrderStatusDesc(orderStatus.getDesc());
        });
        this.companyStoreOrderHeadService.updateById((Object)head);
        this.companyStoreOrderItemService.updateBatchById(items);
    }

    private void crate(DouDianMessageContext context, DouDianMessageVO message) {
        DouDianOrderMessageConvertVo.CreateOrder orderMessage = (DouDianOrderMessageConvertVo.CreateOrder)JSONObject.parseObject((String)message.getData().toString(), DouDianOrderMessageConvertVo.CreateOrder.class);
        this.handleDbOrder(context, OrderStatusEnum.TO_BE_PAID);
    }

    private void payConfirm(DouDianMessageContext context, DouDianMessageVO message) {
        DouDianOrderMessageConvertVo.PayConfirmOrder orderMessage = (DouDianOrderMessageConvertVo.PayConfirmOrder)JSONObject.parseObject((String)message.getData().toString(), DouDianOrderMessageConvertVo.PayConfirmOrder.class);
        this.handleDbOrder(context, OrderStatusEnum.IN_STOCK);
        CompanyStoreOrderHead head = context.getDb().getHead();
        List<CompanyStoreOrderItem> items = context.getDb().getItems();
        Date payTime = new Date(orderMessage.getPay_time() * 1000L);
        BigDecimal payAmount = BigDecimal.valueOf(orderMessage.getPay_amount());
        head.setPayTime(payTime);
        head.setPayAmount(payAmount);
        items.forEach(x -> {
            x.setPayTime(payTime);
            x.setPayAmount(payAmount);
        });
        this.companyStoreOrderHeadService.updateById((Object)head);
        this.companyStoreOrderItemService.updateBatchById(items);
    }

    private void ship(DouDianMessageContext context, DouDianMessageVO message) {
        DouDianOrderMessageConvertVo.SellerShipOrder orderMessage = (DouDianOrderMessageConvertVo.SellerShipOrder)JSONObject.parseObject((String)message.getData().toString(), DouDianOrderMessageConvertVo.SellerShipOrder.class);
        this.handleDbOrder(context, OrderStatusEnum.SHIPPED);
    }

    private void complete(DouDianMessageContext context, DouDianMessageVO message) {
        DouDianOrderMessageConvertVo.CompleteOrder orderMessage = (DouDianOrderMessageConvertVo.CompleteOrder)JSONObject.parseObject((String)message.getData().toString(), DouDianOrderMessageConvertVo.CompleteOrder.class);
        Date completeTime = new Date(orderMessage.getComplete_time() * 1000L);
        this.handleDbOrder(context, OrderStatusEnum.COMPLETED);
        CompanyStoreOrderHead head = context.getDb().getHead();
        List<CompanyStoreOrderItem> items = context.getDb().getItems();
        this.handleDbOrder(context, OrderStatusEnum.CLOSED);
        head.setReceiptConfirmationTime(completeTime);
        items.forEach(x -> x.setReceiptConfirmationTime(completeTime));
        this.companyStoreOrderHeadService.updateById((Object)head);
        this.companyStoreOrderItemService.updateBatchById(items);
    }

    private void cancel(DouDianMessageContext context, DouDianMessageVO message) {
        DouDianOrderMessageConvertVo.CanceledOrder orderMessage = (DouDianOrderMessageConvertVo.CanceledOrder)JSONObject.parseObject((String)message.getData().toString(), DouDianOrderMessageConvertVo.CanceledOrder.class);
        CompanyStoreOrderHead head = context.getDb().getHead();
        List<CompanyStoreOrderItem> items = context.getDb().getItems();
        String cancelReason = orderMessage.getCancel_reason();
        this.handleDbOrder(context, OrderStatusEnum.CLOSED);
        head.setCancelReasons(cancelReason);
        items.forEach(x -> x.setCancelReasons(cancelReason));
        this.companyStoreOrderHeadService.updateById((Object)head);
        this.companyStoreOrderItemService.updateBatchById(items);
    }
}

