/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHead;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHeadVo;
import com.els.modules.purchasercooperation.service.PurchaserTalentManageHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchaser/talentCooperateManage"})
@Api(tags={"\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406"})
public class PurchaserTalentManageHeadController
extends BaseController<PurchaserTalentManageHead, PurchaserTalentManageHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaserTalentManageHeadController.class);
    @Autowired
    private PurchaserTalentManageHeadService manageHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaserTalentManageHead purchaserTalentManageHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserTalentManageHead), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page pageList = (Page)this.manageHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PurchaserTalentManageHeadVo purchaserTalentManageHeadVo) {
        PurchaserTalentManageHead purchaserTalentManageHead = this.manageHeadService.changeVO(purchaserTalentManageHeadVo);
        String id = purchaserTalentManageHead.getId();
        if (id == null) {
            this.manageHeadService.saveMain(purchaserTalentManageHead);
        } else if ("0".equals(purchaserTalentManageHead.getCooperateBillStatus())) {
            this.manageHeadService.editMain("0", purchaserTalentManageHead);
        } else {
            this.manageHeadService.updateMain("0", purchaserTalentManageHead);
        }
        return Result.ok((Object)((Object)purchaserTalentManageHead));
    }

    @ApiOperation(value="\u63d0\u4ea4", notes="\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody PurchaserTalentManageHead purchaserTalentManageHead) {
        if ("0".equals(purchaserTalentManageHead.getCooperateBillStatus())) {
            this.manageHeadService.submit(purchaserTalentManageHead);
        } else {
            this.manageHeadService.updateMain("1", purchaserTalentManageHead);
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PurchaserTalentManageHead purchaserTalentManageHead) {
        this.manageHeadService.editMain("0", purchaserTalentManageHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5408\u4f5c\u5b8c\u6210", notes="\u5408\u4f5c\u5b8c\u6210")
    @PostMapping(value={"/finishCooperation"})
    public Result<?> finishCooperation(@RequestParam(value="id") String id) {
        this.manageHeadService.finishCooperation(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="id") String id) {
        this.manageHeadService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u901a\u8fc7id\u67e5\u8be2", notes="\u8fbe\u4eba\u5408\u4f5c\u7ba1\u7406\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaserTalentManageHead byId = this.manageHeadService.queryById(id);
        return Result.ok((Object)((Object)byId));
    }

    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    public Result<?> cancelById(@RequestParam(value="id") String id) {
        this.manageHeadService.cancelById(id);
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u901a\u8fc7\u8fbe\u4ebaid\u83b7\u53d6\u5355\u636e\u7f16\u53f7", notes="\u901a\u8fc7\u8fbe\u4ebaid\u83b7\u53d6\u5355\u636e\u7f16\u53f7")
    @GetMapping(value={"/findBillNumber"})
    public Result<?> findBillNumberByTopManId(@RequestParam(value="topManId") String topManId, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaserTalentManageHead> billNumberByTopManId = this.manageHeadService.findBillNumberByTopManId(topManId, (Page<PurchaserTalentManageHead>)page);
        return Result.ok(billNumberByTopManId);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaserTalentManageHead purchaserTalentManageHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaserTalentManageHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"cooperate_bill_status", "count(0) as quantity"});
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.groupBy((Object)"cooperate_bill_status");
        List list = ((PurchaserTalentManageHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaserTalentManageHead::getCooperateBillStatus, PurchaserTalentManageHead::getQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "cooperateBillStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("cooperateBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "cooperateBillStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

