/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.utils.TimeTranslateUtil;
import com.els.modules.companystore.dto.CompanyGoodsItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsVideoRecord;
import com.els.modules.companystore.mapper.CompanyGoodsVideoRecordMapper;
import com.els.modules.companystore.mapper.CompanyStoreOrderItemMapper;
import com.els.modules.companystore.service.CompanyGoodsVideoRecordService;
import com.els.modules.companystore.vo.CompanyGoodsVideoRecordVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyGoodsVideoRecordServiceImpl
extends BaseServiceImpl<CompanyGoodsVideoRecordMapper, CompanyGoodsVideoRecord>
implements CompanyGoodsVideoRecordService {
    @Autowired
    private CompanyGoodsVideoRecordMapper companyGoodsVideoRecordMapper;
    @Autowired
    private CompanyStoreOrderItemMapper companyStoreOrderItemMapper;

    @Override
    public List<CompanyGoodsVideoRecord> selectByMainId(String mainId) {
        return this.companyGoodsVideoRecordMapper.selectByMainId(mainId);
    }

    @Override
    public List<CompanyGoodsVideoRecordVO> queryVideoPage(Page<CompanyGoodsVideoRecord> page, QueryWrapper<CompanyGoodsVideoRecord> queryWrapper, CompanyGoodsItemQueryDTO queryDTO) {
        String timeSelect = queryDTO.getTopmanTimeSelect();
        if (StringUtils.isBlank((CharSequence)timeSelect)) {
            timeSelect = "30";
        }
        Date[] dates = TimeTranslateUtil.dayToDate((String)timeSelect);
        queryDTO.setStartTime(TimeTranslateUtil.dateToLineTime((Date)dates[0]));
        queryDTO.setEndTime(TimeTranslateUtil.dateToLineTime((Date)dates[1]));
        queryDTO.setTopmanTimeSelect(queryDTO.getTopmanTimeSelect() + "d");
        List<CompanyGoodsVideoRecordVO> videoPage = this.companyStoreOrderItemMapper.companyGoodsVideoRecordList(queryWrapper, queryDTO);
        return this.replenish(videoPage);
    }

    private List<CompanyGoodsVideoRecordVO> replenish(List<CompanyGoodsVideoRecordVO> records) {
        ArrayList<CompanyGoodsVideoRecordVO> list = new ArrayList<CompanyGoodsVideoRecordVO>();
        if (CollectionUtils.isNotEmpty(records)) {
            List videoIds = records.stream().map(CompanyGoodsVideoRecordVO::getVideoId).distinct().collect(Collectors.toList());
            Map<String, List<CompanyGoodsVideoRecordVO>> listMap = records.stream().collect(Collectors.groupingBy(CompanyGoodsVideoRecordVO::getVideoId));
            for (String videoId : videoIds) {
                CompanyGoodsVideoRecordVO vo = new CompanyGoodsVideoRecordVO();
                List<CompanyGoodsVideoRecordVO> itemList = listMap.get(videoId);
                if (CollectionUtil.isEmpty(itemList)) break;
                CompanyGoodsVideoRecordVO itemVO = itemList.get(0);
                BeanUtil.copyProperties((Object)itemVO, (Object)vo, (String[])new String[0]);
                BigDecimal salesNum = itemList.stream().map(CompanyGoodsVideoRecordVO::getSalesNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                vo.setSalesNum(salesNum);
                if (vo.getPrice() != null) {
                    vo.setSalesAmountMin(vo.getPrice().multiply(salesNum));
                    vo.setSalesAmountMax(vo.getPrice().multiply(salesNum));
                }
                list.add(vo);
            }
        }
        return list;
    }
}

