/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.gson.Gson;
import com.doudian.open.utils.SignUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.companystore.config.DouDianProperties;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.entity.CompanyStoreAuthorize;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.entity.CompanyStoreItem;
import com.els.modules.companystore.entity.CompanyStoreTopmanItem;
import com.els.modules.companystore.entity.CompanyStoreTopmanRecord;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.mapper.CompanyStoreAuthorizeMapper;
import com.els.modules.companystore.mapper.CompanyStoreHeadMapper;
import com.els.modules.companystore.mapper.CompanyStoreTopmanItemMapper;
import com.els.modules.companystore.mapper.CompanyStoreTopmanRecordMapper;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.CompanyStoreItemService;
import com.els.modules.companystore.vo.CompanyStoreHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CompanyStoreHeadServiceImpl
extends BaseServiceImpl<CompanyStoreHeadMapper, CompanyStoreHead>
implements CompanyStoreHeadService {
    @Autowired
    private CompanyStoreHeadMapper companyStoreHeadMapper;
    @Autowired
    private CompanyStoreItemService companyStoreItemService;
    @Autowired
    private CompanyStoreTopmanItemMapper companyStoreTopmanItemMapper;
    @Autowired
    private CompanyStoreTopmanRecordMapper companyStoreTopmanRecordMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private CompanyStoreAuthorizeMapper companyStoreAuthorizeMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DouDianProperties douDianProperties;

    @Override
    public IPage<CompanyStoreHead> queryPage(Page<CompanyStoreHead> page, QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String admin = "companyAdmin";
        Set userRolesSet = this.accountRpcService.getUserRolesSet(loginUser.getElsAccount(), loginUser.getSubAccount());
        if (userRolesSet == null || !userRolesSet.contains("companyAdmin")) {
            queryWrapper.eq((Object)"admin_id", (Object)loginUser.getSubAccount());
        }
        return ((CompanyStoreHeadMapper)this.baseMapper).companyStoreHeadPage(page, queryWrapper, queryDTO);
    }

    @Override
    public List<CompanyStoreHead> queryList(QueryWrapper<CompanyStoreHead> queryWrapper, CompanyStoreHeadQueryDTO queryDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String admin = "companyAdmin";
        Set userRolesSet = this.accountRpcService.getUserRolesSet(loginUser.getElsAccount(), loginUser.getSubAccount());
        if (userRolesSet == null || !userRolesSet.contains("companyAdmin")) {
            queryWrapper.eq((Object)"admin_id", (Object)loginUser.getSubAccount());
        }
        return ((CompanyStoreHeadMapper)this.baseMapper).companyStoreHeadList(queryWrapper, queryDTO);
    }

    @Override
    public CompanyStoreHeadVO queryById(String id) {
        CompanyStoreHeadVO storeHeadVO = new CompanyStoreHeadVO();
        CompanyStoreHead storeHead = (CompanyStoreHead)((Object)this.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            return storeHeadVO;
        }
        BeanUtils.copyProperties((Object)((Object)storeHead), (Object)((Object)storeHeadVO));
        String timeSelect = "30";
        CompanyStoreItem storeItem = this.companyStoreItemService.queryStoreItem(id, timeSelect);
        if (storeItem != null) {
            storeHeadVO.setSalesNum(storeItem.getSalesNum());
            storeHeadVO.setSalesAmountMin(storeItem.getSalesAmountMin());
            storeHeadVO.setSalesAmountMax(storeItem.getSalesAmountMax());
            storeHeadVO.setGoodsNum(storeItem.getGoodsNum());
            storeHeadVO.setTopmanNum(storeItem.getTopmanNum());
            storeHeadVO.setVideosNum(storeItem.getVideosNum());
            storeHeadVO.setLivesNum(storeItem.getLivesNum());
            storeHeadVO.setQueryDay(storeItem.getQueryDay());
        }
        return storeHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        String platform = companyStoreHead.getPlatform();
        String account = companyStoreHead.getBusAccount();
        companyStoreHead.setStoreCode(platform + account + this.invokeBaseRpcService.getNextCode("mcnSrmStoreCode", (Object)companyStoreHead));
        super.setHeadDefaultValue((BaseEntity)companyStoreHead);
        this.companyStoreHeadMapper.insert((Object)companyStoreHead);
        this.insertData(companyStoreHead, headVO);
        this.redisUtil.del(new String[]{headVO.getAuthPhone()});
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        this.check(companyStoreHead.getId());
        this.companyStoreHeadMapper.updateById((Object)companyStoreHead);
        this.companyStoreTopmanItemMapper.deleteByMainId(companyStoreHead.getId());
        this.insertData(companyStoreHead, headVO);
    }

    private void check(String id) {
        CompanyStoreHead storeHead = (CompanyStoreHead)((Object)super.getById((Serializable)((Object)id)));
        if (storeHead == null) {
            throw new ELSBootException("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u5e97\u94fa\u6570\u636e\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!CompanyStoreAuthStatusEnum.PENDING.getValue().equals(storeHead.getAuthState())) {
            throw new ELSBootException("\u5934\u90e8ID" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u6388\u6743\u72b6\u6001\u4e3a\u5f85\u6388\u6743\u7684\u5e97\u94fa\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(storeHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u5e97\u94fa\u6570\u636e");
        }
    }

    private void insertData(CompanyStoreHead companyStoreHead, CompanyStoreHeadVO headVO) {
        List<CompanyStoreTopmanRecord> records;
        List<CompanyStoreItem> companyStoreItemList = headVO.getCompanyStoreItemList();
        List<CompanyStoreTopmanItem> companyStoreTopmanItemList = headVO.getCompanyStoreTopmanItemList();
        List<CompanyStoreTopmanRecord> companyStoreTopmanRecordList = headVO.getCompanyStoreTopmanRecordList();
        if (!CollectionUtils.isEmpty(companyStoreItemList)) {
            for (CompanyStoreItem companyStoreItem : companyStoreItemList) {
                companyStoreItem.setHeadId(companyStoreHead.getId());
                SysUtil.setSysParam((BaseEntity)companyStoreItem, (BaseEntity)companyStoreHead);
            }
            if (!companyStoreItemList.isEmpty()) {
                this.companyStoreItemService.saveBatch(companyStoreItemList);
            }
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1");
            list.add("7");
            list.add("30");
            list.add("90");
            ArrayList<CompanyStoreItem> arrayList = new ArrayList<CompanyStoreItem>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String queryDay = (String)iterator.next();
                CompanyStoreItem entity = new CompanyStoreItem();
                entity.setHeadId(companyStoreHead.getId());
                entity.setQueryDay(queryDay);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)companyStoreHead);
                arrayList.add(entity);
            }
            if (!arrayList.isEmpty()) {
                this.companyStoreItemService.saveBatch(arrayList);
            }
        }
        if (!CollectionUtils.isEmpty(companyStoreTopmanRecordList)) {
            for (CompanyStoreTopmanRecord companyStoreTopmanRecord : companyStoreTopmanRecordList) {
                companyStoreTopmanRecord.setHeadId(companyStoreHead.getId());
                SysUtil.setSysParam((BaseEntity)companyStoreTopmanRecord, (BaseEntity)companyStoreHead);
            }
            if (!companyStoreTopmanRecordList.isEmpty()) {
                this.companyStoreTopmanRecordMapper.insertBatchSomeColumn(companyStoreTopmanRecordList);
            }
        }
        if (!CollectionUtils.isEmpty(records = this.companyStoreTopmanRecordMapper.selectByMainId(companyStoreHead.getId()))) {
            for (CompanyStoreTopmanRecord entity : records) {
                if (CollectionUtils.isEmpty(companyStoreTopmanItemList)) continue;
                for (CompanyStoreTopmanItem entity2 : companyStoreTopmanItemList) {
                    entity2.setRecordId(entity.getId());
                    SysUtil.setSysParam((BaseEntity)entity2, (BaseEntity)companyStoreHead);
                }
                if (companyStoreTopmanItemList.isEmpty()) continue;
                this.companyStoreTopmanItemMapper.insertBatchSomeColumn(companyStoreTopmanItemList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.companyStoreTopmanRecordMapper.deleteByMainId(id);
        this.companyStoreHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.companyStoreTopmanRecordMapper.deleteByMainId(serializable.toString());
            this.companyStoreHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public void validated(CompanyStoreHeadVO headVO) {
        String authPhone = headVO.getAuthPhone();
        Assert.hasText((String)headVO.getPlatform(), (String)I18nUtil.translate((String)"", (String)"\u5e73\u53f0\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getName(), (String)I18nUtil.translate((String)"", (String)"\u5e97\u94fa\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getShopId(), (String)I18nUtil.translate((String)"", (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)authPhone, (String)I18nUtil.translate((String)"", (String)"\u5e97\u94fa\u6388\u6743\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getCaptcha(), (String)I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        authPhone = "13799766536";
        Object captcha = this.redisUtil.get(authPhone);
        if (!headVO.getCaptcha().equals(captcha)) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u65e0\u6548\u9a8c\u8bc1\u7801"));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(CompanyStoreHead::getShopId, (Object)headVO.getShopId())).eq(CompanyStoreHead::getPlatform, (Object)headVO.getPlatform())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List companyStoreHeads = ((CompanyStoreHeadMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (companyStoreHeads != null && companyStoreHeads.size() > 0) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u91cd\u590d\u6dfb\u52a0\u8be5\u5e97\u94fa\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
    }

    @Override
    public AccessTokenResponse callBack(final String code) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("code", code);
                this.put("grant_type", "authorization_code");
            }
        };
        return this.executeAuthorizeToken("token.create", param, true);
    }

    private void updateAuthorizeStatus(String shopId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreHead::getShopId, (Object)shopId);
        CompanyStoreHead companyStoreHead = (CompanyStoreHead)((Object)((CompanyStoreHeadMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (companyStoreHead != null) {
            companyStoreHead.setAuthTime(new Date());
            companyStoreHead.setAuthState("1");
            ((CompanyStoreHeadMapper)this.baseMapper).updateById((Object)companyStoreHead);
        }
    }

    private void updateAuthorizeData(AccessTokenData data, LoginUser loginUser) {
        Calendar instance = Calendar.getInstance();
        instance.add(13, (int)(data.getExpiresIn() + 604800L));
        Date time = instance.getTime();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreAuthorize::getShopId, (Object)data.getShopId());
        CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)Optional.ofNullable(this.companyStoreAuthorizeMapper.selectOne((Wrapper)queryWrapper)).orElse((Object)new CompanyStoreAuthorize()));
        companyStoreAuthorize.setRefreshToken(data.getRefreshToken());
        companyStoreAuthorize.setShopId(data.getShopId());
        if (loginUser != null) {
            companyStoreAuthorize.setSubAccount(loginUser.getSubAccount());
            companyStoreAuthorize.setElsAccount(loginUser.getElsAccount());
        }
        companyStoreAuthorize.setAuthPeriod(this.douDianProperties.getAuthPeriod());
        companyStoreAuthorize.setValidityPeriod(time);
        if (companyStoreAuthorize.getId() != null) {
            companyStoreAuthorize.setUpdateBy(loginUser != null ? loginUser.getSubAccount() : companyStoreAuthorize.getSubAccount());
            companyStoreAuthorize.setUpdateTime(new Date());
            this.companyStoreAuthorizeMapper.updateById((Object)companyStoreAuthorize);
        } else {
            companyStoreAuthorize.setCreateBy(loginUser != null ? loginUser.getSubAccount() : companyStoreAuthorize.getSubAccount());
            companyStoreAuthorize.setCreateTime(new Date());
            this.companyStoreAuthorizeMapper.insert((Object)companyStoreAuthorize);
        }
    }

    @Override
    public boolean startAuthorize(String shopId) {
        String shopAccessToken = "shopAccessToken" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(shopAccessToken);
        if (data != null) {
            data.setExpiresIn(Long.valueOf(this.redisUtil.getExpire(shopAccessToken)));
            this.updateAuthorizeData(data, SysUtil.getLoginUser());
            this.updateAuthorizeStatus(shopId);
            return false;
        }
        this.redisUtil.set("shopAuthorize" + shopId, (Object)SysUtil.getLoginUser(), 600L);
        return true;
    }

    @Override
    public AccessTokenData getAuthorizeToken(String shopId) throws IOException {
        String shopAccessToken = "shopAccessToken" + shopId;
        AccessTokenData data = (AccessTokenData)this.redisUtil.get(shopAccessToken);
        if (data == null) {
            data = (AccessTokenData)this.refreshToken(shopId).getData();
        }
        return data;
    }

    @Override
    public AccessTokenResponse refreshToken(String shopId) throws IOException {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CompanyStoreAuthorize::getShopId, (Object)shopId);
        final CompanyStoreAuthorize companyStoreAuthorize = (CompanyStoreAuthorize)((Object)this.companyStoreAuthorizeMapper.selectOne((Wrapper)queryWrapper));
        if (companyStoreAuthorize == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8d85\u51fa\u6388\u6743\u9650\u671f\uff0c\u8bf7\u91cd\u65b0\u6388\u6743"));
        }
        HashMap<String, String> param = new HashMap<String, String>(2){
            {
                super(x0);
                this.put("refresh_token", companyStoreAuthorize.getRefreshToken());
                this.put("grant_type", "refresh_token");
            }
        };
        LoginUser loginUser = new LoginUser();
        loginUser.setElsAccount(companyStoreAuthorize.getElsAccount());
        loginUser.setSubAccount(companyStoreAuthorize.getSubAccount());
        return this.executeAuthorizeToken("token.refresh", param, false);
    }

    private AccessTokenResponse executeAuthorizeToken(String method, HashMap<String, String> param, boolean isFirst) throws IOException {
        String line;
        String appKey = this.douDianProperties.getAppKey();
        String appSecret = this.douDianProperties.getAppSecret();
        String url = this.douDianProperties.getUrl();
        String paramJson = JSON.toJSONString(param);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        String sign = SignUtil.sign((String)appKey, (String)appSecret, (String)method, (String)timestamp, (String)paramJson, (String)"2");
        String authUrl = url + "/" + method.replace(".", "/") + "?method=" + URLEncoder.encode(method, "UTF-8") + "&app_key=" + URLEncoder.encode(appKey, "UTF-8") + "&timestamp=" + URLEncoder.encode(timestamp, "UTF-8") + "&v=" + URLEncoder.encode(this.douDianProperties.getVersion(), "UTF-8") + "&param_json=" + URLEncoder.encode(paramJson, "UTF-8") + "&sign=" + URLEncoder.encode(sign, "UTF-8");
        URL urlConnect = new URL(authUrl);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        StringBuilder result = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        System.out.println(result);
        Gson gson = new Gson();
        AccessTokenResponse accessTokenData = (AccessTokenResponse)gson.fromJson(result.toString(), AccessTokenResponse.class);
        String shopId = ((AccessTokenData)accessTokenData.getData()).getShopId();
        if (!accessTokenData.isSuccess()) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)("\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6388\u6743:" + accessTokenData.getMessage())));
        }
        LoginUser loginUser = null;
        String loginUserKey = "shopAuthorize" + shopId;
        if (isFirst) {
            Object o = this.redisUtil.get(loginUserKey);
            if (o == null) {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u975e\u4eba\u4e3a\u64cd\u4f5c"));
            }
            loginUser = (LoginUser)o;
        }
        AccessTokenData data = (AccessTokenData)accessTokenData.getData();
        this.updateAuthorizeData(data, loginUser);
        this.redisUtil.set("shopAccessToken" + shopId, (Object)data, data.getExpiresIn().longValue());
        this.updateAuthorizeStatus(shopId);
        if (isFirst) {
            this.redisUtil.del(new String[]{loginUserKey});
        }
        return accessTokenData;
    }
}

