/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.DictModel;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.enterpriseresource.entity.EnterpriseTopManInfoEntity;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.entity.TopManEnterpriseInfoHeadEntity;
import com.els.modules.enterpriseresource.enumerate.DecideStatusStrategy;
import com.els.modules.enterpriseresource.service.EnterpriseTopManService;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import com.els.modules.enterpriseresource.service.TopManEnterpriseInfoHeadService;
import com.els.modules.enterpriseresource.vo.EnterpriseTopManVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enterprise/topMan"})
@Api(tags={"\u4f01\u4e1a\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class EnterpriseTopManController
extends BaseController<TopManEnterpriseInfoHeadEntity, TopManEnterpriseInfoHeadService> {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseTopManController.class);
    @Resource
    private TopManAddElsRecordService topManAddElsRecordService;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private EnterpriseTopManService enterpriseTopManService;

    @ApiOperation(value="\u6839\u636e\u8fbe\u4eba\u67e5\u8be2\u5f53\u524d\u4f01\u4e1a\u6700\u65b0\u7684\u8054\u7cfb\u4eba\u4fe1\u606f", notes="\u6839\u636e\u8fbe\u4eba\u67e5\u8be2\u5f53\u524d\u4f01\u4e1a\u6700\u65b0\u7684\u8054\u7cfb\u4eba\u4fe1\u606f")
    @GetMapping(value={"/queryLastRecordInfo"})
    public Result<?> queryLastRecordInfo(@RequestParam(value="platform") String platform, @RequestParam(value="topManId") String topManId) {
        TopManAddElsRecordEntity topManAddElsRecordEntity = this.topManAddElsRecordService.queryLastRecordInfo(platform, topManId);
        return Result.ok((Object)((Object)topManAddElsRecordEntity));
    }

    @AutoLog(busModule="\u6dfb\u52a0\u8fbe\u4eba\u5230\u4f01\u4e1a", value="\u4fdd\u5b58")
    @ApiOperation(value="\u6dfb\u52a0\u8fbe\u4eba\u5230\u4f01\u4e1a", notes="\u6dfb\u52a0\u8fbe\u4eba\u5230\u4f01\u4e1a")
    @PostMapping(value={"/addRecord"})
    public Result<?> addRecord(@RequestBody TopManAddElsRecordEntity topManAddElsRecordEntity) {
        this.topManAddElsRecordService.addRecord(topManAddElsRecordEntity);
        return Result.ok((Object)((Object)topManAddElsRecordEntity));
    }

    @AutoLog(busModule="\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba", value="\u4fee\u6539")
    @ApiOperation(value="\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba", notes="\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba")
    @PostMapping(value={"/saveEditRecord"})
    public Result<?> editRecord(@RequestBody TopManEnterpriseInfoHeadEntity headEntity) {
        ((TopManEnterpriseInfoHeadService)this.service).editRecord(headEntity);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u83b7\u53d6\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba\u7684\u6570\u636e", value="\u4fee\u6539")
    @ApiOperation(value="\u83b7\u53d6\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba\u7684\u6570\u636e", notes="\u83b7\u53d6\u4fee\u6539\u4f01\u4e1a\u8fbe\u4eba\u7684\u6570\u636e")
    @GetMapping(value={"/getEditRecord"})
    public Result<?> getEditRecord(@RequestParam(value="id") String recordId) {
        TopManEnterpriseInfoHeadEntity headEntity = ((TopManEnterpriseInfoHeadService)this.service).getEditRecord(recordId);
        return Result.ok((Object)((Object)headEntity));
    }

    @AutoLog(busModule="\u786e\u8ba4\u8fbe\u4eba\u8bb0\u5f55", value="\u8bb0\u5f55\u72b6\u6001\u5904\u7406")
    @ApiOperation(value="\u786e\u8ba4\u8fbe\u4eba\u8bb0\u5f55", notes="\u786e\u8ba4\u8fbe\u4eba\u8bb0\u5f55")
    @GetMapping(value={"/decideStatus/{decideStatusStrategy}"})
    public Result<?> decideStatus(@RequestParam String id, @PathVariable(value="decideStatusStrategy") DecideStatusStrategy decideStrategy) {
        this.topManAddElsRecordService.decideStatusStrategyHandle(id, decideStrategy);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d1f\u8d23\u4eba", notes="\u83b7\u53d6\u8d1f\u8d23\u4eba")
    @GetMapping(value={"/getLeaders"})
    public Result<?> getLeaders() {
        final List allByAccount = this.accountRpcService.getAllByAccount(TenantContext.getTenant());
        EnterpriseTopManVO.TopManParamDic dic = new EnterpriseTopManVO.TopManParamDic();
        dic.setText("\u8d1f\u8d23\u4eba");
        dic.setValue("Leader");
        dic.setDescription("select");
        dic.setFatherType("EnterpriseTiktokOthers");
        dic.setOption((List<DictModel>)new ArrayList<DictModel>(allByAccount.size() + 1){
            {
                super(x0);
                this.add(new DictModel("\u65e0", "\u65e0"));
                allByAccount.forEach((? super T a) -> this.add(new DictModel(a.getSubAccount(), a.getRealname())));
            }
        });
        return Result.ok((Object)((Object)dic));
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/listTopManInfo"})
    public Result<?> listTopManInfo(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @RequestParam(name="keyWord", required=false) String keyWord) {
        IPage<EnterpriseTopManInfoEntity> pageList = this.enterpriseTopManService.listTopManInfo(pageNo, pageSize, keyWord);
        return Result.ok(pageList);
    }
}

