/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.enterpriseresource.dto.RedBookTopManDTO;
import com.els.modules.enterpriseresource.entity.RedBookTopManInformation;
import com.els.modules.enterpriseresource.mapper.EnterpriseRedbookTopManMapper;
import com.els.modules.enterpriseresource.service.EnterpriseRedBookTopManService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseRedBookTopManServiceImpl
extends BaseServiceImpl<EnterpriseRedbookTopManMapper, RedBookTopManInformation>
implements EnterpriseRedBookTopManService {
    @Override
    public IPage<RedBookTopManInformation> listRbAll(SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<RedBookTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
        return this.selectListRbAll((Page<RedBookTopManInformation>)page, queryWrapper, SysUtil.getLoginUser(), topManDto);
    }

    @Override
    public IPage<RedBookTopManInformation> listRbPublic(SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<RedBookTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
        queryWrapper.eq((Object)"decideStatus", (Object)"1");
        queryWrapper.isNull((Object)"leader");
        return this.selectListRbAll((Page<RedBookTopManInformation>)page, queryWrapper, SysUtil.getLoginUser(), topManDto);
    }

    @Override
    public IPage<RedBookTopManInformation> listRbMyTopMan(SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<RedBookTopManInformation> queryWrapper = this.getQueryWrapper(topManDto);
        LoginUser loginUser = SysUtil.getLoginUser();
        queryWrapper.eq((Object)"leader", (Object)loginUser.getSubAccount());
        return this.selectListRbAll((Page<RedBookTopManInformation>)page, queryWrapper, loginUser, topManDto);
    }

    private QueryWrapper<RedBookTopManInformation> getQueryWrapper(SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        String[] columns;
        String column;
        String string;
        List<RedBookTopManDTO.ScreenItemField> list;
        List<RedBookTopManDTO.ScreenItemField> putInfos;
        RedBookTopManDTO filterInfo = (RedBookTopManDTO)topManDto.getFilterInfo();
        RedBookTopManDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        QueryWrapper query = new QueryWrapper();
        List<RedBookTopManDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        if (CollectionUtil.isNotEmpty(talentInfos)) {
            for (RedBookTopManDTO.ScreenItemField screenItemField : talentInfos) {
                String string2 = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u7c89\u4e1d\u603b\u6570": {
                        this.handleInteger(string2, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getFansNum);
                        break;
                    }
                    case "\u8fbe\u4eba\u5730\u57df": {
                        List strings = JSON.parseArray((String)string2, String.class);
                        query.lambda().like(RedBookTopManInformation::getLocation, strings.get(strings.size() - 1));
                        break;
                    }
                    case "\u8fbe\u4eba\u6027\u522b": {
                        this.handleString(string2, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getGender);
                        break;
                    }
                }
            }
        }
        if (CollectionUtil.isNotEmpty(putInfos = screenItem.getPutInfo())) {
            block31: for (RedBookTopManDTO.ScreenItemField screenItemField : putInfos) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u89c6\u9891\u63a8\u5e7f\u62a5\u4ef7": {
                        this.handleBigDecimal(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getVideoPrice);
                        continue block31;
                    }
                    case "\u56fe\u6587\u63a8\u5e7f\u62a5\u4ef7": {
                        this.handleBigDecimal(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getPicturePrice);
                        continue block31;
                    }
                    case "\u8fd1\u671f\u5408\u4f5c\u884c\u4e1a": {
                        this.handleLikeString(value, (QueryWrapper<RedBookTopManInformation>)query, RedBookTopManInformation::getTradeType);
                        continue block31;
                    }
                }
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
            }
        }
        if (CollectionUtil.isNotEmpty(list = screenItem.getOther())) {
            for (RedBookTopManDTO.ScreenItemField screenItemField : list) {
                String value = screenItemField.getValue();
                switch (screenItemField.getTitle()) {
                    case "\u786e\u8ba4\u72b6\u6001": {
                        query.eq((Object)"decideStatus", (Object)value);
                        break;
                    }
                    case "\u8d1f\u8d23\u4eba": {
                        query.eq((Object)"leader", (Object)value);
                        break;
                    }
                    case "\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347": {
                        query.lambda().gt(RedBookTopManInformation::getFans30GrowthRate, (Object)BigDecimal.ZERO);
                        break;
                    }
                }
            }
        }
        if ((string = topManDto.getKeyWord()) != null && string.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(RedBookTopManInformation::getName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(RedBookTopManInformation::getTopmanId, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new RedBookTopManInformation()));
        }
        return query;
    }

    private IPage<RedBookTopManInformation> selectListRbAll(Page<RedBookTopManInformation> page, QueryWrapper<?> queryWrapper, LoginUser loginUser, SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        RedBookTopManDTO.ScreenItem screenItem = ((RedBookTopManDTO)topManDto.getFilterInfo()).getScreenItem();
        String contentType = "";
        String personalTag = "";
        String featureTag = "";
        if (screenItem != null) {
            contentType = this.handleContentTypes(topManDto);
            List<RedBookTopManDTO.ScreenItemField> talentInfo = screenItem.getTalentInfo();
            List<String> personalTags = this.handleTagList(talentInfo, "\u535a\u4e3b\u4eba\u8bbe");
            personalTag = StringUtils.join(personalTags, (String)"|");
            List<RedBookTopManDTO.ScreenItemField> contentForm = screenItem.getContentFeature();
            List<String> featureTags = this.handleTagList(contentForm, "\u5185\u5bb9\u7279\u5f81");
            featureTag = StringUtils.join(featureTags, (String)"|");
        }
        return ((EnterpriseRedbookTopManMapper)this.baseMapper).listRbAll(page, queryWrapper, loginUser, contentType, personalTag, featureTag);
    }

    private List<String> handleTagList(List<RedBookTopManDTO.ScreenItemField> screenItemFields, String name) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return null;
        }
        if ("\u535a\u4e3b\u4eba\u8bbe".equals(name)) {
            String[] titles = new String[]{"\u8eab\u4efd\u4fe1\u606f", "\u5bb6\u5ead\u89d2\u8272", "\u7279\u8272\u80cc\u666f"};
            screenItemFields = screenItemFields.stream().filter(h -> Arrays.asList(titles).contains(h.getTitle())).collect(Collectors.toList());
        }
        ArrayList<String> list = new ArrayList<String>();
        screenItemFields.forEach(h -> {
            List values = JSON.parseArray((String)h.getValue(), String.class);
            list.addAll(values);
        });
        return list;
    }

    private String handleContentTypes(SimplePostRequestParam<RedBookTopManDTO> topManDto) {
        List<RedBookTopManDTO.ScreenItemField> list = ((RedBookTopManDTO)topManDto.getFilterInfo()).getScreenItem().getContentType();
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1 && "\u5168\u90e8".equals(list.get(0).getTitle())) {
            return null;
        }
        List collect = list.stream().filter(h -> !"\u5168\u90e8".equals(h.getTitle())).map(RedBookTopManDTO.ScreenItemField::getTitle).collect(Collectors.toList());
        return StringUtils.join(collect, (String)"|");
    }

    private void handleString(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().eq(field, (Object)value);
    }

    private void handleLikeString(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value) || "\u5168\u90e8".equals(value) || "\u4e0d\u9650".equals(value)) {
            return;
        }
        query.lambda().like(field, (Object)value);
    }

    private void handleInteger(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)Integer.parseInt(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)Integer.parseInt(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }

    private void handleBigDecimal(String value, QueryWrapper<RedBookTopManInformation> query, SFunction<RedBookTopManInformation, ?> field) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u6709\u8bef"));
            }
        }
    }
}

