/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.popularize.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.popularize.entity.SupplierTopmanOrderCost;
import com.els.modules.popularize.entity.SupplierTopmanOrderHead;
import com.els.modules.popularize.entity.SupplierTopmanOrderItem;
import com.els.modules.popularize.entity.TopmanOrderCost;
import com.els.modules.popularize.entity.TopmanOrderHead;
import com.els.modules.popularize.entity.TopmanOrderItem;
import com.els.modules.popularize.entity.TopmanOrderVoucher;
import com.els.modules.popularize.enumerate.TopmanOrderStatusEnum;
import com.els.modules.popularize.mapper.SupplierTopmanOrderCostMapper;
import com.els.modules.popularize.mapper.SupplierTopmanOrderHeadMapper;
import com.els.modules.popularize.mapper.SupplierTopmanOrderItemMapper;
import com.els.modules.popularize.mapper.TopmanOrderCostMapper;
import com.els.modules.popularize.mapper.TopmanOrderHeadMapper;
import com.els.modules.popularize.mapper.TopmanOrderItemMapper;
import com.els.modules.popularize.service.SupplierTopmanOrderItemService;
import com.els.modules.popularize.service.TopmanOrderHeadService;
import com.els.modules.popularize.service.TopmanOrderItemService;
import com.els.modules.popularize.service.TopmanOrderVoucherService;
import com.els.modules.popularize.vo.TopmanOrderHeadVO;
import com.els.modules.workflow.api.service.WorkflowAuditRpcService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TopmanOrderHeadServiceImpl
extends BaseServiceImpl<TopmanOrderHeadMapper, TopmanOrderHead>
implements TopmanOrderHeadService {
    @Resource
    private TopmanOrderHeadMapper topmanOrderHeadMapper;
    @Resource
    private TopmanOrderItemMapper topmanOrderItemMapper;
    @Resource
    private TopmanOrderCostMapper topmanOrderCostMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TopmanOrderItemService topmanOrderItemService;
    @Resource
    private SupplierTopmanOrderHeadMapper supplierTopmanOrderHeadMapper;
    @Resource
    private SupplierTopmanOrderItemMapper supplierTopmanOrderItemMapper;
    @Resource
    private SupplierTopmanOrderCostMapper supplierTopmanOrderCostMapper;
    @Autowired
    private TopmanOrderVoucherService topmanOrderVoucherService;
    @Resource
    private WorkflowAuditRpcService auditRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_topman_order_";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public TopmanOrderHeadVO saveMain(TopmanOrderHead topmanOrderHead, List<TopmanOrderItem> topmanOrderItemList, List<TopmanOrderCost> topmanOrderCostList) {
        this.computeAmountNew(topmanOrderHead, topmanOrderItemList, topmanOrderCostList);
        topmanOrderHead.setReceiptsNum(this.invokeBaseRpcService.getNextCode("topmanOrderReceiptsNum", (Object)topmanOrderHead));
        topmanOrderHead.setStatus(TopmanOrderStatusEnum.CONTRACT_NEW.getValue());
        if ("0".equals(topmanOrderHead.getPublishAudit())) {
            topmanOrderHead.setPublishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            topmanOrderHead.setPublishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.topmanOrderHeadMapper.insert((Object)topmanOrderHead);
        super.setHeadDefaultValue((BaseEntity)topmanOrderHead);
        this.insertData(topmanOrderHead, topmanOrderItemList, topmanOrderCostList);
        TopmanOrderHeadVO headVO = new TopmanOrderHeadVO();
        BeanUtils.copyProperties((Object)((Object)topmanOrderHead), (Object)((Object)headVO));
        headVO.setTopmanOrderItemList(topmanOrderItemList);
        headVO.setTopmanOrderCostList(topmanOrderCostList);
        return headVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(TopmanOrderHeadVO topmanOrderHeadPage) {
        this.check(topmanOrderHeadPage.getId());
        TopmanOrderHead topmanOrderHead = new TopmanOrderHead();
        BeanUtils.copyProperties((Object)((Object)topmanOrderHeadPage), (Object)((Object)topmanOrderHead));
        this.computeAmountNew(topmanOrderHead, topmanOrderHeadPage.getTopmanOrderItemList(), topmanOrderHeadPage.getTopmanOrderCostList());
        if ("0".equals(topmanOrderHead.getPublishAudit())) {
            topmanOrderHead.setPublishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            topmanOrderHead.setPublishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        this.topmanOrderHeadMapper.updateById((Object)topmanOrderHead);
        this.topmanOrderItemMapper.deleteByMainId(topmanOrderHead.getId());
        this.topmanOrderCostMapper.deleteByMainId(topmanOrderHead.getId());
        this.insertData(topmanOrderHead, topmanOrderHeadPage.getTopmanOrderItemList(), topmanOrderHeadPage.getTopmanOrderCostList());
    }

    private void computeAmountNew(TopmanOrderHead topmanOrderHead, List<TopmanOrderItem> topmanOrderItemList, List<TopmanOrderCost> topmanOrderCostList) {
        BigDecimal taxAmount;
        BigDecimal netAmount;
        BigDecimal netTotalAmount = BigDecimal.ZERO;
        BigDecimal taxTotalAmount = BigDecimal.ZERO;
        if (CollectionUtil.isNotEmpty(topmanOrderItemList)) {
            netAmount = topmanOrderItemList.stream().filter(h -> h.getNetAmount() != null).map(TopmanOrderItem::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            taxAmount = topmanOrderItemList.stream().filter(h -> h.getTaxAmount() != null).map(TopmanOrderItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            netTotalAmount = netTotalAmount.add(netAmount);
            taxTotalAmount = taxTotalAmount.add(taxAmount);
        }
        if (CollectionUtil.isNotEmpty(topmanOrderCostList)) {
            netAmount = topmanOrderCostList.stream().filter(h -> h.getNetAmount() != null).map(TopmanOrderCost::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            taxAmount = topmanOrderCostList.stream().filter(h -> h.getTaxAmount() != null).map(TopmanOrderCost::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            netTotalAmount = netTotalAmount.add(netAmount);
            taxTotalAmount = taxTotalAmount.add(taxAmount);
        }
        topmanOrderHead.setTotalNetAmount(netTotalAmount);
        topmanOrderHead.setTotalTaxAmount(taxTotalAmount);
    }

    private void computeAmount(TopmanOrderHead topmanOrderHead, List<TopmanOrderItem> topmanOrderItemList, List<TopmanOrderCost> topmanOrderCostList) {
        BigDecimal taxAmount;
        BigDecimal netTotalAmount = BigDecimal.ZERO;
        BigDecimal taxTotalAmount = BigDecimal.ZERO;
        for (TopmanOrderItem orderItem : topmanOrderItemList) {
            BigDecimal priceBase;
            BigDecimal netAmount = BigDecimal.ZERO;
            taxAmount = BigDecimal.ZERO;
            BigDecimal taxRate = orderItem.getTaxRate() != null ? new BigDecimal(orderItem.getTaxRate()).divide(new BigDecimal(100)) : BigDecimal.ZERO;
            BigDecimal bigDecimal = priceBase = orderItem.getPriceBase() != null ? new BigDecimal(orderItem.getPriceBase()) : BigDecimal.ZERO;
            if (orderItem.getPrice() == null && orderItem.getNetPrice() != null) {
                BigDecimal netPrice = orderItem.getNetPrice();
                orderItem.setPrice(netPrice.multiply(taxRate.add(new BigDecimal(1))));
            }
            if (orderItem.getNetPrice() == null && orderItem.getPrice() != null) {
                BigDecimal price = orderItem.getPrice();
                orderItem.setNetPrice(price.divide(taxRate.add(new BigDecimal(1)), 4, 4));
            }
            if (orderItem.getNetPrice() != null) {
                netAmount = orderItem.getNetPrice().divide(priceBase, 4, 4).multiply(orderItem.getQuantity());
                taxAmount = orderItem.getNetAmount().multiply(taxRate.add(new BigDecimal(1)));
            }
            orderItem.setNetAmount(netAmount);
            orderItem.setTaxAmount(taxAmount);
            netTotalAmount = netTotalAmount.add(orderItem.getNetAmount() != null ? orderItem.getNetAmount() : BigDecimal.ZERO);
            taxTotalAmount = taxTotalAmount.add(orderItem.getTaxAmount() != null ? orderItem.getTaxAmount() : BigDecimal.ZERO);
        }
        for (TopmanOrderCost orderCost : topmanOrderCostList) {
            BigDecimal taxRate;
            BigDecimal bigDecimal = taxRate = orderCost.getTaxRate() != null ? new BigDecimal(orderCost.getTaxRate()).divide(new BigDecimal(100)) : BigDecimal.ZERO;
            if (orderCost.getTaxAmount() == null && orderCost.getNetAmount() != null) {
                BigDecimal netAmount = orderCost.getNetAmount();
                orderCost.setTaxAmount(netAmount.multiply(taxRate.add(new BigDecimal(1))));
            }
            if (orderCost.getNetAmount() == null && orderCost.getTaxAmount() != null) {
                taxAmount = orderCost.getTaxAmount();
                orderCost.setNetAmount(taxAmount.divide(taxRate.add(new BigDecimal(1)), 4, 4));
            }
            netTotalAmount = netTotalAmount.add(orderCost.getNetAmount() != null ? orderCost.getNetAmount() : BigDecimal.ZERO);
            taxTotalAmount = taxTotalAmount.add(orderCost.getTaxAmount() != null ? orderCost.getTaxAmount() : BigDecimal.ZERO);
        }
        topmanOrderHead.setTotalNetAmount(netTotalAmount);
        topmanOrderHead.setTotalTaxAmount(taxTotalAmount);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(TopmanOrderHeadVO headVO) {
        if (headVO.getId() != null && !this.redisUtil.tryGetDistributedLock(LOCK_KEY, headVO.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException("\u5f53\u524d\u8ba2\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        try {
            boolean needToSubmitAudit = false;
            boolean isInsertSupplier = false;
            TopmanOrderHead head = new TopmanOrderHead();
            BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
            this.computeAmountNew(head, headVO.getTopmanOrderItemList(), headVO.getTopmanOrderCostList());
            if (StrUtil.isBlank((CharSequence)headVO.getReceiptsNum())) {
                head.setReceiptsNum(this.invokeBaseRpcService.getNextCode("topmanOrderReceiptsNum", (Object)head));
            }
            if ("0".equals(head.getPublishAudit())) {
                head.setPublishAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                if ("1".equals(head.getNeedCoordination())) {
                    head.setStatus(TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue());
                } else {
                    head.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
                }
                isInsertSupplier = true;
            } else {
                head.setPublishAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                head.setStatus(TopmanOrderStatusEnum.CONTRACT_NEW.getValue());
                needToSubmitAudit = true;
            }
            if (StrUtil.isBlank((CharSequence)head.getId())) {
                this.topmanOrderHeadMapper.insert((Object)head);
                super.setHeadDefaultValue((BaseEntity)head);
            } else {
                TopmanOrderHead dbTopmanOrderHead = (TopmanOrderHead)((Object)this.topmanOrderHeadMapper.selectById((Serializable)((Object)head.getId())));
                Assert.isTrue((boolean)dbTopmanOrderHead.getStatus().equals(TopmanOrderStatusEnum.CONTRACT_NEW.getValue()), (String)I18nUtil.translate((String)"", (String)"\u8ba2\u5355\u72b6\u6001\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u5237\u65b0\u8ba2\u5355!"));
                int count = this.topmanOrderHeadMapper.updateById((Object)head);
                if (count == 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
                }
                this.topmanOrderItemMapper.deleteByMainId(head.getId());
                this.topmanOrderCostMapper.deleteByMainId(head.getId());
            }
            this.insertData(head, headVO.getTopmanOrderItemList(), headVO.getTopmanOrderCostList());
            if (needToSubmitAudit) {
                this.submitAudit(head);
            }
            if (isInsertSupplier && StringUtils.isNotBlank((CharSequence)head.getTopManAccount())) {
                this.insertSupplier(head, headVO.getTopmanOrderItemList(), headVO.getTopmanOrderCostList());
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            if (headVO.getId() != null) {
                this.redisUtil.releaseDistributedLock(LOCK_KEY, headVO.getId());
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void auditPass(String id) {
        TopmanOrderHead head = (TopmanOrderHead)((Object)((TopmanOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if ("1".equals(head.getNeedCoordination())) {
            head.setStatus(TopmanOrderStatusEnum.CONTRACT_CONFIRMING.getValue());
        } else {
            head.setStatus(TopmanOrderStatusEnum.CONFIRMED.getValue());
        }
        ((TopmanOrderHeadMapper)this.baseMapper).updateById((Object)head);
        List<TopmanOrderItem> items = this.topmanOrderItemMapper.selectByMainId(id);
        if (CollectionUtil.isNotEmpty(items)) {
            for (TopmanOrderItem item : items) {
                item.setItemStatus(head.getStatus());
            }
        }
        this.topmanOrderItemService.updateBatchById(items);
        List<TopmanOrderCost> costs = this.topmanOrderCostMapper.selectByMainId(id);
        this.insertSupplier(head, items, costs);
    }

    private void insertSupplier(TopmanOrderHead head, List<TopmanOrderItem> items, List<TopmanOrderCost> costs) {
        SupplierTopmanOrderHead supplierHead = new SupplierTopmanOrderHead();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)supplierHead));
        supplierHead.setElsAccount(head.getTopManAccount());
        this.supplierTopmanOrderHeadMapper.insert((Object)supplierHead);
        if (CollectionUtil.isNotEmpty(items)) {
            ArrayList<SupplierTopmanOrderItem> supplierTopmanOrderItems = new ArrayList<SupplierTopmanOrderItem>();
            for (TopmanOrderItem topmanOrderItem : items) {
                SupplierTopmanOrderItem supplierItem = new SupplierTopmanOrderItem();
                BeanUtils.copyProperties((Object)((Object)topmanOrderItem), (Object)((Object)supplierItem));
                supplierItem.setHeadId(supplierHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierItem, (BaseEntity)supplierHead);
                supplierItem.setItemStatus(supplierHead.getStatus());
                supplierItem.setElsAccount(topmanOrderItem.getToElsAccount());
                supplierItem.setToElsAccount(topmanOrderItem.getElsAccount());
                supplierTopmanOrderItems.add(supplierItem);
            }
            if (CollectionUtil.isNotEmpty(supplierTopmanOrderItems)) {
                this.supplierTopmanOrderItemMapper.insertBatchSomeColumn(supplierTopmanOrderItems);
            }
        }
        if (CollectionUtil.isNotEmpty(costs)) {
            ArrayList<SupplierTopmanOrderCost> supplierItems = new ArrayList<SupplierTopmanOrderCost>();
            for (TopmanOrderCost topmanOrderCost : costs) {
                SupplierTopmanOrderCost supplierCost = new SupplierTopmanOrderCost();
                BeanUtils.copyProperties((Object)((Object)topmanOrderCost), (Object)((Object)supplierCost));
                supplierCost.setHeadId(supplierHead.getId());
                SysUtil.setSysParam((BaseEntity)supplierCost, (BaseEntity)supplierHead);
                supplierCost.setElsAccount(topmanOrderCost.getToElsAccount());
                supplierCost.setToElsAccount(topmanOrderCost.getElsAccount());
                supplierItems.add(supplierCost);
            }
            if (CollectionUtil.isNotEmpty(supplierItems)) {
                this.supplierTopmanOrderCostMapper.insertBatchSomeColumn(supplierItems);
            }
        }
    }

    private void submitAudit(TopmanOrderHead topmanOrderHead) {
        AuditInputParamDTO auditInputParamVO = new AuditInputParamDTO();
        auditInputParamVO.setBusinessId(topmanOrderHead.getId());
        if (StringUtils.isNotBlank((CharSequence)topmanOrderHead.getPublishFlowId())) {
            auditInputParamVO.setRootProcessInstanceId(Long.valueOf(Long.parseLong(topmanOrderHead.getPublishFlowId())));
        }
        auditInputParamVO.setBusinessType("topmanOrder");
        auditInputParamVO.setAuditSubject("\u8fbe\u4eba\u8ba2\u5355\u7f16\u53f7:" + topmanOrderHead.getReceiptsNum());
        auditInputParamVO.setParams(JSONObject.toJSONString((Object)((Object)topmanOrderHead)));
        this.auditRpcService.submit(auditInputParamVO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void finish(TopmanOrderItem orderItem) {
        orderItem.setItemStatus(TopmanOrderStatusEnum.FINISH.getValue());
        SupplierTopmanOrderItem supplierTopmanOrderItem = new SupplierTopmanOrderItem();
        supplierTopmanOrderItem.setId(orderItem.getId());
        supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.FINISH.getValue());
        this.topmanOrderItemService.updateById((Object)orderItem);
        this.supplierTopmanOrderItemMapper.updateById((Object)supplierTopmanOrderItem);
        List topmanOrderItems = this.topmanOrderItemService.selectByMainId(orderItem.getHeadId()).stream().filter(h -> !orderItem.getId().equals(h.getId())).collect(Collectors.toList());
        TopmanOrderHead orderHead = new TopmanOrderHead();
        SupplierTopmanOrderHead supplierTopmanOrderHead = new SupplierTopmanOrderHead();
        if (CollectionUtils.isEmpty(topmanOrderItems)) {
            orderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
            supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
        } else {
            long statuCount = topmanOrderItems.stream().filter(h -> TopmanOrderStatusEnum.CONFIRMED.getValue().contains(h.getItemStatus())).count();
            if (statuCount == 0L) {
                orderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
                supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
            } else {
                orderHead.setStatus(TopmanOrderStatusEnum.PARTIAL_DELIVERY.getValue());
                supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.PARTIAL_DELIVERY.getValue());
            }
        }
        orderHead.setId(orderItem.getHeadId());
        supplierTopmanOrderHead.setId(orderHead.getId());
        int count = ((TopmanOrderHeadMapper)this.baseMapper).updateById((Object)orderHead);
        int supplierCount = this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        if (count == 0 || supplierCount == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        TopmanOrderHead topmanOrderHead = (TopmanOrderHead)((Object)((TopmanOrderHeadMapper)this.baseMapper).selectById((Serializable)((Object)orderItem.getHeadId())));
        TopmanOrderVoucher voucher = new TopmanOrderVoucher();
        BeanUtils.copyProperties((Object)((Object)orderItem), (Object)((Object)voucher));
        voucher.setToElsAccount(orderItem.getToElsAccount());
        voucher.setOrderNumber(topmanOrderHead.getReceiptsNum());
        voucher.setOrderItemNumber(orderItem.getItemNumber());
        voucher.setCurrency(topmanOrderHead.getCurrency());
        this.topmanOrderVoucherService.saveTopmanOrderVoucher(voucher);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void close(TopmanOrderItem orderItem) {
        orderItem.setItemStatus(TopmanOrderStatusEnum.CLOSE.getValue());
        SupplierTopmanOrderItem supplierTopmanOrderItem = new SupplierTopmanOrderItem();
        supplierTopmanOrderItem.setId(orderItem.getId());
        supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CLOSE.getValue());
        this.topmanOrderItemService.updateById((Object)orderItem);
        this.supplierTopmanOrderItemMapper.updateById((Object)supplierTopmanOrderItem);
        List topmanOrderItems = this.topmanOrderItemService.selectByMainId(orderItem.getHeadId()).stream().filter(h -> !orderItem.getId().equals(h.getId())).collect(Collectors.toList());
        TopmanOrderHead orderHead = new TopmanOrderHead();
        SupplierTopmanOrderHead supplierTopmanOrderHead = new SupplierTopmanOrderHead();
        if (CollectionUtils.isEmpty(topmanOrderItems)) {
            orderHead.setStatus(TopmanOrderStatusEnum.CLOSE.getValue());
            supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.CLOSE.getValue());
        } else {
            long statuCount = topmanOrderItems.stream().filter(h -> TopmanOrderStatusEnum.CONFIRMED.getValue().contains(h.getItemStatus())).count();
            if (statuCount == 0L) {
                orderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
                supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.FINISH.getValue());
            }
        }
        orderHead.setId(orderItem.getHeadId());
        supplierTopmanOrderHead.setId(orderHead.getId());
        int count = ((TopmanOrderHeadMapper)this.baseMapper).updateById((Object)orderHead);
        int supplierCount = this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        if (count == 0 || supplierCount == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void closeAll(TopmanOrderHead orderHead) {
        orderHead.setStatus(TopmanOrderStatusEnum.CLOSE.getValue());
        SupplierTopmanOrderHead supplierTopmanOrderHead = new SupplierTopmanOrderHead();
        supplierTopmanOrderHead.setId(orderHead.getId());
        supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.CLOSE.getValue());
        ArrayList<SupplierTopmanOrderItem> supplierTopmanOrderItems = new ArrayList<SupplierTopmanOrderItem>();
        ArrayList<TopmanOrderItem> topmanOrderItems = new ArrayList<TopmanOrderItem>();
        List<TopmanOrderItem> items = this.topmanOrderItemService.selectByMainId(orderHead.getId());
        if (!CollectionUtils.isEmpty(topmanOrderItems)) {
            for (TopmanOrderItem item : items) {
                List<String> status = Arrays.asList(TopmanOrderStatusEnum.CONFIRMED.getValue(), TopmanOrderStatusEnum.PARTIAL_DELIVERY.getValue());
                Assert.isTrue((boolean)status.contains(item.getItemStatus()), (String)I18nUtil.translate((String)"", (String)("\u8ba2\u5355\u884c\u53f7[" + item.getId() + "]\u5f53\u524d\u72b6\u6001\u975e\u5f85\u4f9b\u5e94\u5546\u786e\u8ba4\u72b6\u6001\uff0c\u6682\u65f6\u4e0d\u80fd\u8fdb\u884c\u6574\u5355\u786e\u8ba4!")));
                TopmanOrderItem topmanOrderItem = new TopmanOrderItem();
                SupplierTopmanOrderItem supplierTopmanOrderItem = new SupplierTopmanOrderItem();
                topmanOrderItem.setId(item.getId());
                topmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CLOSE.getValue());
                supplierTopmanOrderItem.setId(item.getId());
                supplierTopmanOrderItem.setItemStatus(TopmanOrderStatusEnum.CLOSE.getValue());
                supplierTopmanOrderItems.add(supplierTopmanOrderItem);
                topmanOrderItems.add(topmanOrderItem);
            }
        }
        if (CollectionUtil.isNotEmpty(topmanOrderItems)) {
            ((TopmanOrderItemService)SpringContextUtils.getBean(TopmanOrderItemService.class)).updateBatchById(topmanOrderItems);
        }
        if (CollectionUtil.isNotEmpty(supplierTopmanOrderItems)) {
            ((SupplierTopmanOrderItemService)SpringContextUtils.getBean(SupplierTopmanOrderItemService.class)).updateBatchById(supplierTopmanOrderItems);
        }
        int count = ((TopmanOrderHeadMapper)this.baseMapper).updateById((Object)orderHead);
        int supplierCount = this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        if (count == 0 || supplierCount == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(TopmanOrderHead orderHead) {
        orderHead.setStatus(TopmanOrderStatusEnum.CANCEL.getValue());
        SupplierTopmanOrderHead supplierTopmanOrderHead = new SupplierTopmanOrderHead();
        supplierTopmanOrderHead.setId(orderHead.getId());
        supplierTopmanOrderHead.setStatus(TopmanOrderStatusEnum.CANCEL.getValue());
        int count = ((TopmanOrderHeadMapper)this.baseMapper).updateById((Object)orderHead);
        int supplierCount = this.supplierTopmanOrderHeadMapper.updateById((Object)supplierTopmanOrderHead);
        if (count == 0 || supplierCount == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
    }

    private void insertData(TopmanOrderHead topmanOrderHead, List<TopmanOrderItem> topmanOrderItemList, List<TopmanOrderCost> topmanOrderCostList) {
        if (!CollectionUtils.isEmpty(topmanOrderItemList)) {
            int itemNumber = 0;
            for (TopmanOrderItem entity : topmanOrderItemList) {
                entity.setHeadId(topmanOrderHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)topmanOrderHead);
                entity.setItemStatus(topmanOrderHead.getStatus());
                entity.setToElsAccount(topmanOrderHead.getTopManAccount());
                entity.setOrderNumber(topmanOrderHead.getReceiptsNum());
                entity.setItemNumber(String.valueOf(++itemNumber));
            }
            if (!topmanOrderItemList.isEmpty()) {
                this.topmanOrderItemMapper.insertBatchSomeColumn(topmanOrderItemList);
            }
        }
        if (!CollectionUtils.isEmpty(topmanOrderCostList)) {
            for (TopmanOrderCost entity : topmanOrderCostList) {
                entity.setHeadId(topmanOrderHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)topmanOrderHead);
                entity.setToElsAccount(topmanOrderHead.getTopManAccount());
            }
            if (!topmanOrderCostList.isEmpty()) {
                this.topmanOrderCostMapper.insertBatchSomeColumn(topmanOrderCostList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.check(id);
        this.topmanOrderItemMapper.deleteByMainId(id);
        this.topmanOrderCostMapper.deleteByMainId(id);
        this.topmanOrderHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.check(id);
            this.topmanOrderItemMapper.deleteByMainId(id.toString());
            this.topmanOrderCostMapper.deleteByMainId(id.toString());
            this.topmanOrderHeadMapper.deleteById((Serializable)((Object)id));
        }
    }

    private void check(String id) {
        TopmanOrderHead topmanOrderHead = (TopmanOrderHead)((Object)super.getById((Serializable)((Object)id)));
        if (topmanOrderHead == null) {
            throw new ELSBootException("\u5934\u90e8ID" + id + "\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u8be5\u8bb0\u5f55\u662f\u5426\u88ab\u5220\u9664");
        }
        if (!TopmanOrderStatusEnum.CONTRACT_NEW.getValue().equals(topmanOrderHead.getStatus())) {
            throw new ELSBootException("\u5934\u90e8ID" + id + "\u7684\u64cd\u4f5c\u8bb0\u5f55\u72b6\u6001\u65e0\u6548\uff1a\u53ea\u80fd\u7f16\u8f91\u72b6\u6001\u4e3a\u65b0\u5efa\u7684\u8fbe\u4eba\u8ba2\u5355");
        }
        if (!TenantContext.getTenant().equals(topmanOrderHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u5934\u90e8ID" + id + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void checkRow(TopmanOrderItem orderItem) {
        if (orderItem == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(orderItem.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8ba2\u5355\u884cID" + orderItem.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void checkHead(TopmanOrderHead orderHead) {
        if (orderHead == null) {
            throw new ELSBootException("\u7cfb\u7edf\u4e2d\u67e5\u8be2\u4e0d\u5230\u8be5\u8ba2\u5355\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6570\u636e");
        }
        if (!TenantContext.getTenant().equals(orderHead.getElsAccount())) {
            throw new ELSBootException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8ba2\u5355\u884cID" + orderHead.getId() + "\u7684\u6570\u636e\u8bb0\u5f55");
        }
    }

    @Override
    public void validated(TopmanOrderHeadVO headVO) {
        List<TopmanOrderCost> costList;
        Assert.hasText((String)headVO.getCompany(), (String)I18nUtil.translate((String)"", (String)"\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getTopManId(), (String)I18nUtil.translate((String)"", (String)"\u8fbe\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        List<TopmanOrderItem> itemList = headVO.getTopmanOrderItemList();
        if (!CollectionUtils.isEmpty(itemList)) {
            for (TopmanOrderItem item : itemList) {
                Assert.isTrue((item.getPrice() != null || item.getNetPrice() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8ba2\u5355\u884c\u7684\u542b\u7a0e\u5355\u4ef7\u548c\u672a\u7a0e\u5355\u4ef7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a"));
                Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
                Assert.hasText((String)item.getPriceBase(), (String)I18nUtil.translate((String)"i18n_alert_empty_notBriceBase", (String)"\u4ef7\u683c\u57fa\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
        if (!CollectionUtils.isEmpty(costList = headVO.getTopmanOrderCostList())) {
            for (TopmanOrderCost cost : costList) {
                Assert.isTrue((cost.getTaxAmount() != null || cost.getNetAmount() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8ba2\u5355\u5934\u8d39\u7528\u7684\u542b\u7a0e\u91d1\u989d\u548c\u672a\u7a0e\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a"));
                Assert.hasText((String)cost.getCostType(), (String)I18nUtil.translate((String)"i18n_alert_empty_notCostType", (String)"\u8d39\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        }
    }
}

