/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.enterpriseresource.entity.EnterpriseKsTopManResultEntity;
import com.els.modules.enterpriseresource.entity.EnterpriseTopManParamEntity;
import com.els.modules.enterpriseresource.mapper.EnterpriseKsTopManMapper;
import com.els.modules.enterpriseresource.service.EnterpriseKsTopManService;
import com.els.modules.enterpriseresource.vo.EnterpriseKsTopManVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseKsTopManServiceImpl
extends BaseServiceImpl<EnterpriseKsTopManMapper, EnterpriseTopManParamEntity>
implements EnterpriseKsTopManService {
    @Override
    public IPage<EnterpriseKsTopManResultEntity> listKsAll(SimplePostRequestParam<EnterpriseKsTopManVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        return ((EnterpriseKsTopManMapper)this.baseMapper).listKsAll((Page<EnterpriseKsTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser());
    }

    @Override
    public IPage<EnterpriseKsTopManResultEntity> listKsPublic(SimplePostRequestParam<EnterpriseKsTopManVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        ksQueryWrapper.eq((Object)"decide_status", (Object)"1");
        ksQueryWrapper.isNull((Object)"sub_account");
        return ((EnterpriseKsTopManMapper)this.baseMapper).listKsAll((Page<EnterpriseKsTopManResultEntity>)page, ksQueryWrapper, SysUtil.getLoginUser());
    }

    @Override
    public IPage<EnterpriseKsTopManResultEntity> listKsMyTopMan(SimplePostRequestParam<EnterpriseKsTopManVO> topManDto) {
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper<?> ksQueryWrapper = this.getKsQueryWrapper(topManDto);
        LoginUser loginUser = SysUtil.getLoginUser();
        ksQueryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        return ((EnterpriseKsTopManMapper)this.baseMapper).listKsAll((Page<EnterpriseKsTopManResultEntity>)page, ksQueryWrapper, loginUser);
    }

    private QueryWrapper<?> getKsQueryWrapper(SimplePostRequestParam<EnterpriseKsTopManVO> topManDto) {
        String[] columns;
        String column;
        EnterpriseKsTopManVO filterInfo = (EnterpriseKsTopManVO)topManDto.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        EnterpriseKsTopManVO.ScreenItem screenItem = filterInfo.getScreenItem();
        this.handleInTitle(screenItem.getContentType(), query, "content_type_name");
        this.handleInTitle(screenItem.getIndustry(), query, "industry_name");
        this.handleInTitle(screenItem.getContentForm(), query, "content_form_name");
        List<EnterpriseKsTopManVO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
        if (starRecommendation != null && starRecommendation.size() > 0) {
            query.and(wrapper -> {
                for (EnterpriseKsTopManVO.ScreenItemField screenItemField : starRecommendation) {
                    ((QueryWrapper)wrapper.like((Object)"star_tag_ids", (Object)screenItemField)).or();
                }
            });
        }
        List<EnterpriseKsTopManVO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        block10: for (int i = 0; talentInfos != null && i < talentInfos.size(); ++i) {
            EnterpriseKsTopManVO.ScreenItemField screenItemField = talentInfos.get(i);
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, query, "fans_num");
                    continue block10;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    query.eq((Object)"topman_sex", (Object)value);
                    continue block10;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ((QueryWrapper)query.eq((Object)"province_code", (Object)Integer.parseInt((String)strings.get(0)))).eq((Object)"city_code", (Object)Integer.parseInt((String)strings.get(1)));
                    continue block10;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        }
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)q.like((Object)"topman_name", (Object)keyWord)).or(a -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)a.eq((Object)"topman_id", (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new EnterpriseKsTopManResultEntity()));
        }
        return query;
    }

    private void handleInTitle(List<EnterpriseKsTopManVO.ScreenItemField> list, QueryWrapper<?> query, String field) {
        if (list == null || list.size() == 0) {
            return;
        }
        List collect = list.stream().map(EnterpriseKsTopManVO.ScreenItemField::getTitle).collect(Collectors.toList());
        query.in((Object)field, collect);
    }

    private void handleMinMax(String value, QueryWrapper<?> query, String field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.between((Object)field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.le((Object)field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.ge((Object)field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new RuntimeException(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }
}

