/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enterpriseresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.enterpriseresource.dto.ZhiHuTopManDTO;
import com.els.modules.enterpriseresource.entity.ZhiHuTopManInformation;
import com.els.modules.enterpriseresource.mapper.EnterpriseZhiHuTopManMapper;
import com.els.modules.enterpriseresource.service.EnterpriseZhiHuTopManService;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnterpriseZhiHuTopManServiceImpl
extends BaseServiceImpl<EnterpriseZhiHuTopManMapper, ZhiHuTopManInformation>
implements EnterpriseZhiHuTopManService {
    @Autowired
    private EnterpriseZhiHuTopManMapper enterpriseZhiHuTopManMapper;

    @Override
    public IPage<ZhiHuTopManInformation> listZhiHuAll(SimplePostRequestParam<ZhiHuTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    @Override
    public IPage<ZhiHuTopManInformation> listZhiHuPublic(SimplePostRequestParam<ZhiHuTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    @Override
    public IPage<ZhiHuTopManInformation> listZhiHuMyTopMan(SimplePostRequestParam<ZhiHuTopManDTO> topManDto) {
        return this.selectList(topManDto);
    }

    private IPage<ZhiHuTopManInformation> selectList(SimplePostRequestParam<ZhiHuTopManDTO> topManDto) {
        ZhiHuTopManDTO filterInfo = (ZhiHuTopManDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        IPage<ZhiHuTopManInformation> pageList = new IPage<ZhiHuTopManInformation>();
        Page page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        ZhiHuTopManInformation zhiHuTopManInformation = new ZhiHuTopManInformation();
        this.getQueryWrapper(topManDto, (QueryWrapper<ZhiHuTopManInformation>)queryWrapper, zhiHuTopManInformation);
        switch (taskType) {
            case "allTopMan": {
                pageList = this.enterpriseZhiHuTopManMapper.listZhiHuAll((Page<ZhiHuTopManInformation>)page, (QueryWrapper<ZhiHuTopManInformation>)queryWrapper, SysUtil.getLoginUser(), zhiHuTopManInformation);
                break;
            }
            case "publicTopMan": {
                queryWrapper.eq((Object)"decideStatus", (Object)"1");
                queryWrapper.isNull((Object)"leader");
                pageList = this.enterpriseZhiHuTopManMapper.listZhiHuAll((Page<ZhiHuTopManInformation>)page, (QueryWrapper<ZhiHuTopManInformation>)queryWrapper, SysUtil.getLoginUser(), zhiHuTopManInformation);
                break;
            }
            case "myTopMan": {
                queryWrapper.eq((Object)"leader", (Object)SysUtil.getLoginUser().getSubAccount());
                pageList = this.enterpriseZhiHuTopManMapper.listZhiHuAll((Page<ZhiHuTopManInformation>)page, (QueryWrapper<ZhiHuTopManInformation>)queryWrapper, SysUtil.getLoginUser(), zhiHuTopManInformation);
                break;
            }
            default: {
                throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u7c7b\u578b");
            }
        }
        return pageList;
    }

    private void getQueryWrapper(SimplePostRequestParam<ZhiHuTopManDTO> topManDto, QueryWrapper<ZhiHuTopManInformation> queryWrapper, ZhiHuTopManInformation zhiHuTopManInformation) {
        ZhiHuTopManDTO.ScreenItem screenItem;
        ZhiHuTopManDTO filterInfo = (ZhiHuTopManDTO)topManDto.getFilterInfo();
        String keyWord = topManDto.getKeyWord();
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            queryWrapper.lambda().eq(ZhiHuTopManInformation::getName, (Object)keyWord.trim());
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<ZhiHuTopManDTO.ScreenItemField> otherFilter;
            List<ZhiHuTopManDTO.ScreenItemField> talentInfo;
            List<ZhiHuTopManDTO.ScreenItemField> featuredTag;
            List<ZhiHuTopManDTO.ScreenItemField> videoTime;
            List<ZhiHuTopManDTO.ScreenItemField> contentType;
            List<ZhiHuTopManDTO.ScreenItemField> talentType = screenItem.getFieldType();
            if (CollectionUtils.isNotEmpty(talentType)) {
                zhiHuTopManInformation.setBadges(talentType.get(0).getTitle().trim());
            }
            if (CollectionUtils.isNotEmpty(contentType = screenItem.getContentType())) {
                contentType.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u56de\u7b54/\u6587\u7ae0": {
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getOrderType, (Object)1);
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getOrderSecondType, (Object)0);
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getOrderThirdType, (Object)0);
                            break;
                        }
                        case "\u89c6\u9891": {
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getOrderType, (Object)2);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(videoTime = screenItem.getVideoTime())) {
                videoTime.forEach(a -> queryWrapper.lambda().eq(ZhiHuTopManInformation::getOrderThirdType, (Object)a.getValue().toString()));
            }
            if (CollectionUtils.isNotEmpty(featuredTag = screenItem.getFeaturedTag())) {
                String value = featuredTag.get(0).getValue().toString();
                queryWrapper.lambda().eq(ZhiHuTopManInformation::getTags, (Object)value);
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u7c89\u4e1d\u603b\u6570": {
                            EnterpriseZhiHuTopManServiceImpl.getFanParam(a.getValue().toString(), queryWrapper, "follower_count");
                            break;
                        }
                        case "\u8d26\u53f7\u7b49\u7ea7": {
                            String blogAuthentication = a.getValue().toString();
                            queryWrapper.lambda().eq(ZhiHuTopManInformation::getLevel, (Object)blogAuthentication);
                            break;
                        }
                        case "\u662f\u5426\u7b7e\u7ea6MCN": {
                            String blogInfluence = a.getValue().toString();
                            queryWrapper.lambda().eq(ZhiHuTopManInformation::getIsSignMcn, (Object)blogInfluence);
                            break;
                        }
                        case "\u8fbe\u4eba\u62a5\u4ef7": {
                            EnterpriseZhiHuTopManServiceImpl.getFanParam(a.getValue().toString(), queryWrapper, "");
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherFilter = screenItem.getOtherFilter())) {
                otherFilter.forEach(a -> {
                    String title;
                    switch (title = a.getTitle()) {
                        case "\u786e\u8ba4\u72b6\u6001": {
                            queryWrapper.lambda().eq(ZhiHuTopManInformation::getDecideStatus, (Object)a.getValue().toString());
                            break;
                        }
                        case "\u8d1f\u8d23\u4eba": {
                            queryWrapper.lambda().eq(ZhiHuTopManInformation::getLeader, (Object)a.getValue().toString());
                            break;
                        }
                        case "\u89c6\u9891-\u811a\u672c\u64b0\u5199\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getIsVideoX, (Object)a.getValue().toString());
                            break;
                        }
                        case "\u89c6\u9891-\u5168\u7247\u5b9a\u5236\uff08\u542b\u89c6\u9891\u53d1\u5e03\uff09": {
                            queryWrapper.lambda().like(ZhiHuTopManInformation::getOrderSecondType, (Object)"2");
                            break;
                        }
                        case "\u5e26\u8d27\u80fd\u529b\u8005": {
                            queryWrapper.lambda().eq(ZhiHuTopManInformation::getIsProductX, (Object)a.getValue().toString());
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
        }
        EnterpriseZhiHuTopManServiceImpl.sort(topManDto, queryWrapper);
    }

    public static void getFanParam(Object str, QueryWrapper<ZhiHuTopManInformation> queryWrapper, String column) {
        String value = str.toString();
        if (value.startsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.le((Object)column, (Object)split[1]);
        } else if (value.endsWith("-")) {
            String[] split = value.split("-");
            queryWrapper.gt((Object)column, (Object)split[0]);
        } else {
            String[] split = value.split("-");
            queryWrapper.between((Object)column, (Object)split[0], (Object)split[1]);
        }
    }

    public static void sort(SimplePostRequestParam<ZhiHuTopManDTO> topManDto, QueryWrapper<ZhiHuTopManInformation> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn()) && !"default".equals(topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            queryWrapper.orderBy(true, order, (Object[])new String[]{EnterpriseZhiHuTopManServiceImpl.camelToUnderline(column)});
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }
}

