/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHead;
import com.els.modules.purchasercooperation.entity.PurchaserTalentSampleItem;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentManageHeadMapper;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentSampleItemMapper;
import com.els.modules.purchasercooperation.service.PurchaserTalentSampleItemService;
import com.els.modules.samplesend.entity.SampleTopMainHead;
import com.els.modules.samplesend.entity.SampleTopMainItem;
import com.els.modules.samplesend.mapper.SampleTopMainHeadMapper;
import com.els.modules.samplesend.mapper.SampleTopMainItemMapper;
import com.els.modules.suppliercooperation.entity.SupplierTalentSampleItem;
import com.els.modules.suppliercooperation.service.SupplierTalentSampleItemService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaserTalentSampleItemServiceImpl
extends BaseServiceImpl<PurchaserTalentSampleItemMapper, PurchaserTalentSampleItem>
implements PurchaserTalentSampleItemService {
    @Autowired
    private SupplierTalentSampleItemService sampleItemService;
    @Autowired
    private SampleTopMainHeadMapper sampleTopMainHeadMapper;
    @Autowired
    private PurchaserTalentManageHeadMapper purchaserTalentManageHeadMapper;
    @Autowired
    private SampleTopMainItemMapper sampleTopMainItemMapper;

    @Override
    public int insertBatch(List<PurchaserTalentSampleItem> purchaserTalentSampleItemList) {
        purchaserTalentSampleItemList.forEach(a -> {
            if (a.getHeadId() == null) {
                throw new ELSBootException("\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        int i = ((PurchaserTalentSampleItemMapper)this.baseMapper).insertBatchSomeColumn(purchaserTalentSampleItemList);
        return i;
    }

    @Override
    public void deleteById(List<PurchaserTalentSampleItem> purchaserTalentSampleItemList) {
        List<PurchaserTalentSampleItem> purchaserTalentSampleItems = ((PurchaserTalentSampleItemMapper)this.baseMapper).selectByIds(purchaserTalentSampleItemList, TenantContext.getTenant());
        purchaserTalentSampleItems.forEach(a -> Assert.isTrue((boolean)"0".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u5220\u9664\u65b0\u5efa\u72b6\u6001\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u884c\u72b6\u6001\u662f\u5426\u4e3a\u65b0\u5efa")));
        ((PurchaserTalentSampleItemMapper)this.baseMapper).deleteBatchIds(purchaserTalentSampleItemList);
    }

    @Override
    @Transactional
    public void affirmTakeById(String status, List<PurchaserTalentSampleItem> purchaserTalentSampleItemList) {
        Map<String, Object> map = this.checkSample(status, purchaserTalentSampleItemList);
        List sampleItems = (List)map.get("supplier");
        PurchaserTalentSampleItem purchaserTalentSampleItem = new PurchaserTalentSampleItem();
        String s = "4".equals(status) ? "3" : status;
        purchaserTalentSampleItem.setItemStatus(s);
        purchaserTalentSampleItem.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentSampleItem.setUpdateTime(new Date());
        ((PurchaserTalentSampleItemMapper)this.baseMapper).updateStatus(purchaserTalentSampleItem, purchaserTalentSampleItemList);
        this.sampleItemService.affirmTakeById(false, s, sampleItems);
        if ("3".equals(status)) {
            PurchaserTalentManageHead byId = (PurchaserTalentManageHead)((Object)this.purchaserTalentManageHeadMapper.selectById((Serializable)((Object)purchaserTalentSampleItemList.get(0).getHeadId())));
            this.updateStatusByBillCode(byId.getBillNumber());
            List sampleTopMainItems = (List)map.get("sampleTopMainItem");
            this.sampleTopMainItemMapper.updateStatus((SampleTopMainItem)((Object)sampleTopMainItems.get(0)), sampleTopMainItems);
        }
    }

    private Map<String, Object> checkSample(String status, List<PurchaserTalentSampleItem> purchaserTalentSampleItemList) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        ArrayList sampleItems = new ArrayList(purchaserTalentSampleItemList.size());
        ArrayList sampleTopMainItemList = new ArrayList(purchaserTalentSampleItemList.size());
        if (CollectionUtils.isNotEmpty(purchaserTalentSampleItemList)) {
            purchaserTalentSampleItemList.forEach(a -> {
                if ("3".equals(status)) {
                    Assert.isTrue((boolean)"2".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u5df2\u53d1\u8d27\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                    SampleTopMainItem sampleTopMainItem = new SampleTopMainItem();
                    sampleTopMainItem.setId(a.getId());
                    sampleTopMainItem.setItemStatus(status);
                    sampleTopMainItem.setUpdateTime(new Date());
                    sampleTopMainItemList.add(sampleTopMainItem);
                    paramMap.put("sampleTopMainItem", sampleTopMainItemList);
                }
                SupplierTalentSampleItem sampleItem = new SupplierTalentSampleItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)sampleItem));
                sampleItems.add(sampleItem);
                paramMap.put("supplier", sampleItems);
            });
        }
        return paramMap;
    }

    @Override
    public void updateStatusByBillCode(String sourceBillCode) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().eq(SampleTopMainHead::getSourceBillCode, (Object)sourceBillCode)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).set(SampleTopMainHead::getBillStatus, (Object)"3")).set(BaseEntity::getUpdateBy, (Object)SysUtil.getLoginUser().getSubAccount())).set(BaseEntity::getUpdateTime, (Object)new Date());
        this.sampleTopMainHeadMapper.update(null, (Wrapper)updateWrapper);
    }
}

