/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.release.base;

import com.fdd.api.client.release.FddAccountClient;
import com.fdd.api.client.release.FddCertificateClient;
import com.fdd.api.client.release.FddCertificationClient;
import com.fdd.api.client.release.FddCompanyClient;
import com.fdd.api.client.release.FddContractClient;
import com.fdd.api.client.release.FddEvidenceClient;
import com.fdd.api.client.release.FddFileClient;
import com.fdd.api.client.release.FddMultifunctionClient;
import com.fdd.api.client.release.FddOnlineTemplateClient;
import com.fdd.api.client.release.FddPersonClient;
import com.fdd.api.client.release.FddSealClient;
import com.fdd.api.client.release.FddSignClient;
import com.fdd.api.client.release.FddSmsClient;
import com.fdd.api.client.release.FddUKeyClient;
import com.fdd.api.client.release.base.FddBaseApiClient;
import com.fdd.api.client.release.base.proxy.ClientProxy;
import com.fdd.api.client.release.impl.FddAccountClientImpl;
import com.fdd.api.client.release.impl.FddCertificateClientImpl;
import com.fdd.api.client.release.impl.FddCertificationClientImpl;
import com.fdd.api.client.release.impl.FddCompanyClientImpl;
import com.fdd.api.client.release.impl.FddContractClientImpl;
import com.fdd.api.client.release.impl.FddEvidenceClientImpl;
import com.fdd.api.client.release.impl.FddFileClientImpl;
import com.fdd.api.client.release.impl.FddMultifunctionClientImpl;
import com.fdd.api.client.release.impl.FddOnlineTemplateClientImpl;
import com.fdd.api.client.release.impl.FddPersonClientImpl;
import com.fdd.api.client.release.impl.FddRaClientImpl;
import com.fdd.api.client.release.impl.FddSealClientImpl;
import com.fdd.api.client.release.impl.FddSignClientImpl;
import com.fdd.api.client.release.impl.FddSmsClientImpl;
import com.fdd.api.client.release.impl.FddUKeyClientImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class ClientFactory {
    private static Map<String, Object> clientContainer;
    private static String hostUrl;
    private static String appId;
    private static String appSecret;
    private static String ACCOUNT_CLIENT_NAME;
    private static String CERTIFICATE_CLIENT_NAME;
    private static String CERTIFICATION_CLIENT_NAME;
    private static String COMPANY_CLIENT_NAME;
    private static String CONTRACT_CLIENT_NAME;
    private static String EVIDENCE_CLIENT_NAME;
    private static String SMS_CLIENT_NAME;
    private static String FACE_VERIFY_CLIENT_NAME;
    private static String FILE_CLIENT_NAME;
    private static String CONTRACT_TEMPLATE_CLIENT_NAME;
    private static String SMS_CLIENT_NAME_NEW;
    private static String SYSTEM_DISPLAY_CLIENT_NAME;
    private static String SEAL_CLIENT_NAME;
    private static String SIGN_CLIENT_NAME;
    private static String MULTIFUNCTION_CLIENT_NAME;
    private static String UKEY_CLIENT_NAME;
    private static String PERSON_CLIENT_NAME;
    private static String RA_CLIENT_NAME;

    private ClientFactory() {
        if (clientContainer == null) {
            ClientFactory.initClientContainer();
        }
    }

    private static void initClientContainer() {
        clientContainer = new HashMap<String, Object>();
    }

    public static ClientFactory instance(String hostUrl, String appId, String appSecret) {
        ClientFactory.setHostUrl(hostUrl);
        ClientFactory.setAppId(appId);
        ClientFactory.setAppSecret(appSecret);
        return SingleHolder.instance;
    }

    public static <T> T apiClient(String name, Class<? extends FddBaseApiClient> clazz) throws Exception {
        Object client;
        if (clientContainer == null) {
            ClientFactory.initClientContainer();
        }
        if ((client = clientContainer.get(name)) == null) {
            FddBaseApiClient targetClient = clazz.newInstance();
            ClientFactory.initClient(targetClient);
            client = Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), (InvocationHandler)new ClientProxy(targetClient));
            clientContainer.put(name, client);
        }
        return (T)client;
    }

    public FddAccountClient accountClient() {
        try {
            return (FddAccountClient)ClientFactory.apiClient(ACCOUNT_CLIENT_NAME, FddAccountClientImpl.class);
        }
        catch (Exception e) {
            FddAccountClientImpl client = new FddAccountClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddCertificateClient certificateClient() {
        try {
            return (FddCertificateClient)ClientFactory.apiClient(CERTIFICATE_CLIENT_NAME, FddCertificateClientImpl.class);
        }
        catch (Exception e) {
            FddCertificateClientImpl client = new FddCertificateClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddCertificationClient certificationClient() {
        try {
            return (FddCertificationClient)ClientFactory.apiClient(CERTIFICATION_CLIENT_NAME, FddCertificationClientImpl.class);
        }
        catch (Exception e) {
            FddCertificationClientImpl client = new FddCertificationClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddContractClient contractClient() {
        try {
            return (FddContractClient)ClientFactory.apiClient(CONTRACT_CLIENT_NAME, FddContractClientImpl.class);
        }
        catch (Exception e) {
            FddContractClientImpl client = new FddContractClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddEvidenceClient evidenceClient() {
        try {
            FddEvidenceClient client = (FddEvidenceClient)ClientFactory.apiClient(EVIDENCE_CLIENT_NAME, FddEvidenceClientImpl.class);
            return client;
        }
        catch (Exception e) {
            FddEvidenceClientImpl client = new FddEvidenceClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddSmsClient smsClient() {
        try {
            FddSmsClient client = (FddSmsClient)ClientFactory.apiClient(SMS_CLIENT_NAME_NEW, FddSmsClientImpl.class);
            return client;
        }
        catch (Exception e) {
            FddSmsClientImpl client = new FddSmsClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddFileClient fileClient() {
        try {
            return (FddFileClient)ClientFactory.apiClient(FILE_CLIENT_NAME, FddFileClientImpl.class);
        }
        catch (Exception e) {
            FddFileClientImpl client = new FddFileClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddSealClient sealClient() {
        try {
            FddSealClient sealClient = (FddSealClient)ClientFactory.apiClient(SEAL_CLIENT_NAME, FddSealClientImpl.class);
            return sealClient;
        }
        catch (Exception e) {
            FddSealClientImpl client = new FddSealClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddMultifunctionClient multifunctionClient() {
        try {
            return (FddMultifunctionClient)ClientFactory.apiClient(MULTIFUNCTION_CLIENT_NAME, FddMultifunctionClientImpl.class);
        }
        catch (Exception e) {
            FddMultifunctionClientImpl client = new FddMultifunctionClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddSignClient signClient() {
        try {
            return (FddSignClient)ClientFactory.apiClient(SIGN_CLIENT_NAME, FddSignClientImpl.class);
        }
        catch (Exception e) {
            FddSignClientImpl client = new FddSignClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddUKeyClient uKeyClient() {
        try {
            return (FddUKeyClient)ClientFactory.apiClient(UKEY_CLIENT_NAME, FddUKeyClientImpl.class);
        }
        catch (Exception e) {
            FddUKeyClientImpl client = new FddUKeyClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddCompanyClient companyClient() {
        try {
            return (FddCompanyClient)ClientFactory.apiClient(COMPANY_CLIENT_NAME, FddCompanyClientImpl.class);
        }
        catch (Exception e) {
            FddCompanyClientImpl client = new FddCompanyClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddPersonClient personClient() {
        try {
            return (FddPersonClient)ClientFactory.apiClient(PERSON_CLIENT_NAME, FddPersonClientImpl.class);
        }
        catch (Exception e) {
            FddPersonClientImpl client = new FddPersonClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddOnlineTemplateClient onlineTemplateClient() {
        try {
            return (FddOnlineTemplateClient)ClientFactory.apiClient(CONTRACT_TEMPLATE_CLIENT_NAME, FddOnlineTemplateClientImpl.class);
        }
        catch (Exception e) {
            FddOnlineTemplateClientImpl client = new FddOnlineTemplateClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    public FddRaClientImpl raClient() {
        try {
            return (FddRaClientImpl)ClientFactory.apiClient(RA_CLIENT_NAME, FddRaClientImpl.class);
        }
        catch (Exception e) {
            FddRaClientImpl client = new FddRaClientImpl();
            ClientFactory.initClient(client);
            return client;
        }
    }

    private static void initClient(FddBaseApiClient client) {
        client.setAppId(appId);
        client.setAppSecret(appSecret);
        client.setHostUrl(hostUrl);
        client.initApiUrlConstant(hostUrl);
    }

    public static ClientFactory instance() {
        return SingleHolder.instance;
    }

    public static void setHostUrl(String hostUrl) {
        ClientFactory.hostUrl = hostUrl;
    }

    public static void setAppId(String appId) {
        ClientFactory.appId = appId;
    }

    public static void setAppSecret(String appSecret) {
        ClientFactory.appSecret = appSecret;
    }

    static {
        hostUrl = "http://172.18.2.40:8130/";
        appId = "100000";
        appSecret = "vNTbK2CTNuQzm0ociYIEdbF2";
        ACCOUNT_CLIENT_NAME = "accountClient";
        CERTIFICATE_CLIENT_NAME = "certificateClient";
        CERTIFICATION_CLIENT_NAME = "certificationClient";
        COMPANY_CLIENT_NAME = "companyClient";
        CONTRACT_CLIENT_NAME = "contractClient";
        EVIDENCE_CLIENT_NAME = "evidenceClient";
        SMS_CLIENT_NAME = "smsClient";
        FACE_VERIFY_CLIENT_NAME = "faceVerifyClient";
        FILE_CLIENT_NAME = "fileClient";
        CONTRACT_TEMPLATE_CLIENT_NAME = "contractTemplateClient";
        SMS_CLIENT_NAME_NEW = "smsClient";
        SYSTEM_DISPLAY_CLIENT_NAME = "systemDisplayClient";
        SEAL_CLIENT_NAME = "sealClient";
        SIGN_CLIENT_NAME = "signClient";
        MULTIFUNCTION_CLIENT_NAME = "multifunctionClient";
        UKEY_CLIENT_NAME = "uKeyClientName";
        PERSON_CLIENT_NAME = "personClient";
        RA_CLIENT_NAME = "raClient";
    }

    private static class SingleHolder {
        private static final ClientFactory instance = new ClientFactory();

        private SingleHolder() {
        }
    }
}

