/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.release.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.fdd.api.client.constant.ApiUrlConstant;
import com.fdd.api.client.dto.BaseDTO;
import com.fdd.api.client.dto.ContractNoDTO;
import com.fdd.api.client.dto.ManualReceiptSignDTO;
import com.fdd.api.client.dto.ManualSignDTO;
import com.fdd.api.client.dto.MergeSignDTO;
import com.fdd.api.client.dto.SananOrderNoDTO;
import com.fdd.api.client.enums.CommonEnum;
import com.fdd.api.client.exception.ReturnValueNotRestResultException;
import com.fdd.api.client.release.base.InputStreamCacher;
import com.fdd.api.client.res.RestResult;
import com.fdd.api.client.util.DateUtil;
import com.fdd.api.client.util.SignUtil;
import com.fdd.api.client.util.StringUtils;
import com.fdd.api.client.util.http.HttpUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class FddBaseApiClient {
    private String hostUrl;
    private String appId;
    private String appSecret;
    public ApiUrlConstant apiUrlConstant;
    private final int returnStringLengthLimit = 300;

    public BaseDTO getBaseDTO() {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setAppId(this.appId);
        baseDTO.setTimestamp(DateUtil.getTimeStamp());
        baseDTO.setSignType("SHA256");
        baseDTO.setAppKey(this.appSecret);
        return baseDTO;
    }

    public RestResult sendPostRequest(String url, Object object) throws Exception {
        if (null == object) {
            RestResult result = new RestResult();
            result.setResult(CommonEnum.BUSINESS_PARAMETER_ERROR.getValue(), "\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        BaseDTO baseDTO = this.getBaseDTO();
        baseDTO = SignUtil.sign(baseDTO, object);
        String json = HttpUtil.postUrlAsJson(url, baseDTO, "UTF-8");
        RestResult result = JSON.parseObject(json, RestResult.class);
        return result;
    }

    public RestResult jointStringRequest(String url, Object object) throws Exception {
        RestResult<String> result = new RestResult<String>();
        BaseDTO baseDTO = this.getBaseDTO();
        baseDTO = SignUtil.sign(baseDTO, object);
        StringBuilder builder = new StringBuilder();
        builder.append(url).append("?").append("appId").append("=").append(baseDTO.getAppId()).append("&signType").append("=").append(baseDTO.getSignType()).append("&sign").append("=").append(baseDTO.getSign()).append("&timestamp").append("=").append(URLEncoder.encode(baseDTO.getTimestamp(), "UTF-8")).append("&bizContent").append("=").append(baseDTO.getBizContent());
        result.setData(builder.toString());
        return result;
    }

    public RestResult submitFormForViewContract(String url, ContractNoDTO dto) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, dto);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        HashMap<String, String> header = null;
        if (dto.getMobileDevice() != null && dto.getMobileDevice().booleanValue()) {
            header = new HashMap<String, String>();
            header.put("user-agent", "webOS");
        }
        String s = HttpUtil.postUrl(url, fileParams, header, "UTF-8");
        RestResult result = JSON.parseObject(s, RestResult.class);
        return result;
    }

    public RestResult submitFormForViewContract(String url, SananOrderNoDTO dto) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, dto);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        HashMap<String, String> header = null;
        if (dto.getMobileDevice() != null && dto.getMobileDevice().booleanValue()) {
            header = new HashMap<String, String>();
            header.put("user-agent", "webOS");
        }
        String s = HttpUtil.postUrl(url, fileParams, header, "UTF-8");
        RestResult result = JSON.parseObject(s, RestResult.class);
        return result;
    }

    public RestResult submitForm(String url, Object object) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, object);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        String s = HttpUtil.postUrl(url, fileParams, null, "UTF-8");
        RestResult result = JSON.parseObject(s, RestResult.class);
        return result;
    }

    public RestResult submitManualSignPageRequest(String url, ManualSignDTO dto) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, dto);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        HashMap<String, String> header = null;
        if (dto.getMobileDevice() != null && dto.getMobileDevice().booleanValue()) {
            header = new HashMap<String, String>();
            header.put("user-agent", "webOS");
        }
        String s = HttpUtil.postUrl(url, fileParams, header, "UTF-8");
        RestResult result = JSON.parseObject(s, RestResult.class);
        return result;
    }

    public RestResult submitForm(String url, Map<String, File> fileMaps, Object object) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, object);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        RestResult result = HttpUtil.postMultipartFiles(url, fileMaps, fileParams, null);
        return result;
    }

    public RestResult uploadFile(File file, Integer uploadType, String docType) throws Exception {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put("uploadType", uploadType);
        fileMap.put("docType", docType);
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, fileMap);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        RestResult result = HttpUtil.postMultipartFiles(this.apiUrlConstant.API_FILE_UPLOAD_URL, file, fileParams, null);
        return result;
    }

    public RestResult downloadFileForJSONParam(String downloadUrl, Object object) throws Exception {
        RestResult result = new RestResult();
        if (null == object) {
            result.setResult(CommonEnum.BUSINESS_PARAMETER_ERROR.getValue(), "\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseDTO baseDTO = this.getBaseDTO();
        baseDTO = SignUtil.sign(baseDTO, object);
        URL url = new URL(downloadUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.setRequestProperty("accept", "application/json");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.90 Safari/537.36");
        if (baseDTO != null) {
            byte[] writebytes = JSON.toJSONString(baseDTO).getBytes();
            conn.setRequestProperty("Content-Length", String.valueOf(writebytes.length));
            OutputStream outwritestream = conn.getOutputStream();
            outwritestream.write(JSON.toJSONString(baseDTO).getBytes());
            outwritestream.flush();
            outwritestream.close();
        }
        if (conn.getResponseCode() == 200) {
            int contentLength = conn.getContentLength();
            InputStream inputStream = conn.getInputStream();
            InputStreamCacher cacher = new InputStreamCacher(inputStream);
            try {
                result = this.transferInputStreamToString(cacher.getInputStream());
            }
            catch (ReturnValueNotRestResultException e) {
                result.setData(cacher.getInputStream());
            }
            return result;
        }
        result.setResult(CommonEnum.ERROR.getValue(), CommonEnum.ERROR.getValueInFact());
        return result;
    }

    private RestResult transferInputStreamToString(InputStream inputStream) throws Exception {
        String s;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuilder sb = new StringBuilder();
        while ((s = reader.readLine()) != null) {
            sb.append(s);
            if (sb.length() <= 300) continue;
            throw new ReturnValueNotRestResultException("\u8fd4\u56de\u6d41\u975eRestResult\u8fd4\u56de\u503c");
        }
        inputStream.reset();
        reader.close();
        String str = sb.toString();
        RestResult result = null;
        try {
            if (StringUtils.isNotBlank(str) && str.contains("RestResult")) {
                str = str.replaceAll("RestResult", "").replaceAll("=", ":");
                int index = str.lastIndexOf(", data:");
                String temp1 = str.substring(0, index);
                str = temp1 + "}";
            }
            result = JSON.parseObject(str, RestResult.class);
        }
        catch (JSONException e) {
            throw new ReturnValueNotRestResultException("\u8fd4\u56de\u6d41\u975eRestResult\u8fd4\u56de\u503c");
        }
        catch (Exception e) {
            throw new ReturnValueNotRestResultException("\u4e0b\u8f7d\u63a5\u53e3\u8fd4\u56de\u503c\u89e3\u6790\u5f02\u5e38");
        }
        return result;
    }

    public RestResult downloadFile(String downloadUrl, Map<String, Object> params) throws Exception {
        RestResult result = new RestResult();
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, params);
        StringBuffer sendParams = new StringBuffer();
        sendParams.append("appId=").append(fileDTO.getAppId()).append("&timestamp=").append(fileDTO.getTimestamp()).append("&signType=").append(fileDTO.getSignType()).append("&sign=").append(fileDTO.getSign()).append("&bizContent=").append(fileDTO.getBizContent());
        URL url = new URL(downloadUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.90 Safari/537.36");
        byte[] bypes = sendParams.toString().getBytes();
        conn.getOutputStream().write(bypes);
        if (conn.getResponseCode() == 200) {
            InputStream inputStream = conn.getInputStream();
            InputStreamCacher cacher = new InputStreamCacher(inputStream);
            try {
                result = this.transferInputStreamToString(cacher.getInputStream());
            }
            catch (ReturnValueNotRestResultException e) {
                result.setData(cacher.getInputStream());
            }
            return result;
        }
        result.setResult(CommonEnum.ERROR.getValue(), CommonEnum.ERROR.getValueInFact());
        return result;
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public ApiUrlConstant initApiUrlConstant(String hostUrl) {
        this.apiUrlConstant = new ApiUrlConstant(hostUrl);
        return this.apiUrlConstant;
    }

    public String toString() {
        return "AbstractApiClient{hostUrl='" + this.hostUrl + '\'' + ", appId='" + this.appId + '\'' + ", appSecret='" + this.appSecret + '\'' + '}';
    }

    public RestResult submitFile(File file, String url) throws Exception {
        HashMap fileMap = new HashMap();
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, fileMap);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        RestResult result = HttpUtil.postMultipartFiles(this.apiUrlConstant.API_VERIFY_CONTRACT, file, fileParams, null);
        return result;
    }

    public RestResult sendPostRequestForMergeSign(String url, MergeSignDTO dto) throws Exception {
        if (null == dto) {
            RestResult result = new RestResult();
            result.setResult(CommonEnum.BUSINESS_PARAMETER_ERROR.getValue(), "\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        BaseDTO baseDTO = this.getBaseDTO();
        baseDTO = SignUtil.sign(baseDTO, dto);
        HashMap<String, String> headers = null;
        if (dto.getMobileDevice() != null && dto.getMobileDevice().booleanValue()) {
            headers = new HashMap<String, String>();
            headers.put("user-agent", "webOS");
        }
        String json = HttpUtil.postUrlAsJsonWithHeaders(url, baseDTO, "UTF-8", headers);
        RestResult result = JSON.parseObject(json, RestResult.class);
        return result;
    }

    public RestResult submitManualReceiptSignPageRequest(String url, ManualReceiptSignDTO dto) throws Exception {
        BaseDTO fileDTO = this.getBaseDTO();
        fileDTO = SignUtil.sign(fileDTO, dto);
        HashMap<String, Object> fileParams = new HashMap<String, Object>();
        fileParams.put("appId", fileDTO.getAppId());
        fileParams.put("timestamp", fileDTO.getTimestamp());
        fileParams.put("signType", fileDTO.getSignType());
        fileParams.put("sign", fileDTO.getSign());
        fileParams.put("bizContent", fileDTO.getBizContent());
        HashMap<String, String> header = null;
        if (dto.getMobileDevice() != null && dto.getMobileDevice().booleanValue()) {
            header = new HashMap<String, String>();
            header.put("user-agent", "webOS");
        }
        String s = HttpUtil.postUrl(url, fileParams, header, "UTF-8");
        RestResult result = JSON.parseObject(s, RestResult.class);
        return result;
    }
}

