/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.release.base.proxy;

import com.fdd.api.client.enums.CommonEnum;
import com.fdd.api.client.release.base.annotation.ParameterCheck;
import com.fdd.api.client.res.RestResult;
import com.fdd.api.client.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClientProxy
implements InvocationHandler {
    private final String stringType = "java.lang.String";
    private final String restResultType = "RestResult";
    private final String dtoPackage = "com.fdd.api.client.dto";
    private Object targetObject;

    public ClientProxy(Object targetObject) {
        this.targetObject = targetObject;
    }

    public Object newProxy(Object targetObject) {
        this.targetObject = targetObject;
        return Proxy.newProxyInstance(targetObject.getClass().getClassLoader(), targetObject.getClass().getInterfaces(), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        String checkResult = this.checkParam(args);
        if (StringUtils.isNotBlank(checkResult)) {
            if (method.getReturnType().toString().contains("RestResult")) {
                return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), checkResult);
            }
            return null;
        }
        Object ret = method.invoke(this.targetObject, args);
        return ret;
    }

    private String checkParam(Object[] args) throws IllegalAccessException {
        for (Object obj : args) {
            Field[] declaredFields;
            String checkResult;
            if (obj == null || !StringUtils.isNotBlank(checkResult = this.checkParam(declaredFields = obj.getClass().getDeclaredFields(), obj))) continue;
            return checkResult;
        }
        return null;
    }

    private String checkParam(Field[] declaredFields, Object instance) throws IllegalAccessException {
        for (Field field : declaredFields) {
            String result;
            Field[] childFields;
            field.setAccessible(true);
            ParameterCheck annotation = field.getAnnotation(ParameterCheck.class);
            if (annotation != null) {
                String valueStr;
                int lengthLimit;
                String name = field.getName();
                Object value = field.get(instance);
                boolean notEmpty = annotation.notEmpty();
                if (notEmpty) {
                    if (value == null) {
                        return "\u53c2\u6570 [ " + name + " ] \u4e0d\u80fd\u4e3a\u7a7a";
                    }
                    if (this.isStringType(field) && StringUtils.isBlank(String.valueOf(value))) {
                        return "\u53c2\u6570 [ " + name + " ] \u4e0d\u80fd\u4e3a\u7a7a";
                    }
                }
                if (value != null && this.isStringType(field) && (lengthLimit = annotation.lengthLimit()) > 0 && StringUtils.isNotBlank(valueStr = String.valueOf(value)) && valueStr.length() > lengthLimit) {
                    return "\u53c2\u6570 [ " + name + " ] \u957f\u5ea6\u8d85\u9650,\u6700\u957f\u4e0d\u80fd\u8d85\u8fc7 " + lengthLimit;
                }
            }
            if (!this.inDTOPackage(field) || field.get(instance) == null || (childFields = field.getType().getDeclaredFields()).length <= 0 || !StringUtils.isNotBlank(result = this.checkParam(childFields, field.get(instance)))) continue;
            return result;
        }
        return null;
    }

    private boolean isStringType(Field field) {
        return field.getGenericType().toString().contains("java.lang.String");
    }

    private boolean inDTOPackage(Field field) {
        return field.getGenericType().toString().contains("com.fdd.api.client.dto");
    }
}

