/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.release.impl;

import com.fdd.api.client.dto.BatchGenerateContractDTO;
import com.fdd.api.client.dto.ContractCarbonCopyDTO;
import com.fdd.api.client.dto.ContractDTO;
import com.fdd.api.client.dto.ContractDownloadDTO;
import com.fdd.api.client.dto.ContractNoDTO;
import com.fdd.api.client.dto.ContractPictureDTO;
import com.fdd.api.client.dto.ContractSearchDTO;
import com.fdd.api.client.dto.ContractTypeDTO;
import com.fdd.api.client.dto.ContractVerifyDTO;
import com.fdd.api.client.dto.GenerateContractDTO;
import com.fdd.api.client.dto.JudicialReportDTO;
import com.fdd.api.client.dto.MergeContractDTO;
import com.fdd.api.client.dto.SananOrderNoDTO;
import com.fdd.api.client.dto.SananOrderNoDownloadDTO;
import com.fdd.api.client.dto.TemplateDTO;
import com.fdd.api.client.dto.WatermarkDTO;
import com.fdd.api.client.dto.WatermarkInfoDTO;
import com.fdd.api.client.release.FddContractClient;
import com.fdd.api.client.release.base.FddBaseApiClient;
import com.fdd.api.client.res.RestResult;
import com.fdd.api.client.util.StringUtils;
import java.util.HashMap;

public class FddContractClientImpl
extends FddBaseApiClient
implements FddContractClient {
    @Override
    public RestResult saveContract(ContractDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_UPLOAD_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult generateContract(GenerateContractDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_GENERATE_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult archiveContract(ContractNoDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_ARCHIVE_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult downloadContract(ContractDownloadDTO dto) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String docNo = dto.getDocNo();
        WatermarkInfoDTO watermarkInfo = dto.getWatermarkInfo();
        if (StringUtils.isNotBlank(docNo)) {
            params.put("docNo", docNo);
        }
        if (watermarkInfo != null) {
            params.put("watermarkInfo", watermarkInfo);
        }
        RestResult result = this.downloadFile(this.apiUrlConstant.API_DOWNLOAD_CONTRACT_URL, params);
        return result;
    }

    @Override
    public RestResult downloadContract(SananOrderNoDownloadDTO dto) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sananOrderNo", dto.getSananOrderNo());
        if (null != dto.getWatermarkInfo()) {
            params.put("watermarkInfo", dto.getWatermarkInfo());
        }
        return this.downloadFile(this.apiUrlConstant.API_DOWNLOAD_CONTRACT_URL, params);
    }

    @Override
    public RestResult downloadFileContract(ContractDownloadDTO dto) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String docNo = dto.getDocNo();
        WatermarkInfoDTO watermarkInfo = dto.getWatermarkInfo();
        if (StringUtils.isNotBlank(docNo)) {
            params.put("docNo", docNo);
        }
        if (watermarkInfo != null) {
            params.put("watermarkInfo", watermarkInfo);
        }
        RestResult result = this.downloadFileForJSONParam(this.apiUrlConstant.API_DOWNLOAD_FILE_CONTRACT_URL, params);
        return result;
    }

    @Override
    public RestResult viewContract(ContractNoDTO dto) throws Exception {
        RestResult restResult = this.submitFormForViewContract(this.apiUrlConstant.API_VIEW_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult viewContract(SananOrderNoDTO dto) throws Exception {
        RestResult restResult = this.submitFormForViewContract(this.apiUrlConstant.API_VIEW_CONTRACT_URL, dto);
        return restResult;
    }

    @Deprecated
    private RestResult viewContractParam(ContractDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_CONTRACT_PARAM_VIEW_URL, dto);
        return restResult;
    }

    @Deprecated
    private RestResult contractPicture(ContractPictureDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_CONTRACT_PICTURE_URL, dto);
        return restResult;
    }

    @Override
    public RestResult mergeContract(MergeContractDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_MERGE_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult revokeContract(ContractNoDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_REVOKE_CONTRACT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult saveContractTemplate(TemplateDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_UPLOAD_TEMPLATE_URL, dto);
        return restResult;
    }

    @Override
    public RestResult signStatus(ContractNoDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.CONTRACT_SIGN_STATUS_URL, dto);
        return restResult;
    }

    @Override
    public RestResult addWatermark(WatermarkDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_ADD_WATERMARK_INFO_URL, dto);
        return restResult;
    }

    @Override
    public RestResult judicialReport(JudicialReportDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_JUDICIAL_LOCAL_DEPLOYMENT_CONTRACT_REPORT_URL, dto);
        return restResult;
    }

    @Override
    public RestResult verifyContract(ContractVerifyDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_VERIFY_CONTRACT, dto);
        return restResult;
    }

    @Override
    public RestResult searchContract(ContractSearchDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_SEARCH_CONTRACT, dto);
        return restResult;
    }

    @Override
    public RestResult batchGenerateContract(BatchGenerateContractDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_BATCH_GENERATE_CONTRACT, dto);
        return restResult;
    }

    @Override
    public RestResult carbonCopy(ContractCarbonCopyDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_CARBON_COPY_CONTRACT, dto);
        return restResult;
    }

    @Override
    public RestResult typeList(ContractTypeDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.API_LIST_CONTRACT_TYPE, dto);
        return restResult;
    }

    @Override
    public RestResult docNoListBySananOrderNo(SananOrderNoDTO dto) throws Exception {
        RestResult restResult = this.sendPostRequest(this.apiUrlConstant.DOC_NO_LIST_BY_SANAN_ORDER_NO_URL, dto);
        return restResult;
    }
}

