/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.release.impl;

import com.fdd.api.client.constant.OssConstants;
import com.fdd.api.client.dto.UploadAndSaveContractDTO;
import com.fdd.api.client.dto.UploadAndSaveContractTemplateDTO;
import com.fdd.api.client.dto.UploadAndSaveSealDTO;
import com.fdd.api.client.dto.UploadAndUpdateSealDTO;
import com.fdd.api.client.enums.BusinessEnum;
import com.fdd.api.client.enums.CommonEnum;
import com.fdd.api.client.release.FddMultifunctionClient;
import com.fdd.api.client.release.base.ClientFactory;
import com.fdd.api.client.release.base.FddBaseApiClient;
import com.fdd.api.client.res.RestResult;
import com.fdd.api.client.util.StringUtils;
import java.util.Arrays;

public class FddMultifunctionClientImpl
extends FddBaseApiClient
implements FddMultifunctionClient {
    private ClientFactory clientFactory = ClientFactory.instance();

    @Override
    public RestResult uploadAndSaveContract(UploadAndSaveContractDTO dto) throws Exception {
        if (dto.getFile() == null) {
            return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), "\u53c2\u6570\u6821\u9a8c\u5931\u8d25, [ file ] \u4e3a\u7a7a");
        }
        int uploadType = Arrays.asList(OssConstants.ALLOW_IMAGE_DOC_TYPES).contains(dto.getDocExtension()) ? 2 : 1;
        RestResult result = this.uploadFile(dto.getFile(), uploadType, dto.getDocExtension());
        if (result.isSuccess().booleanValue()) {
            String docPath = (String)result.getData();
            if (StringUtils.isNotBlank(docPath)) {
                dto.setDocPath(docPath);
                dto.setFile(null);
                dto.setUploadType(null);
                dto.setDocType(null);
                return this.clientFactory.contractClient().saveContract(dto);
            }
            return new RestResult(BusinessEnum.ERROR.getValue(), BusinessEnum.ERROR.getValueInFact());
        }
        return result;
    }

    @Override
    public RestResult uploadAndSaveSeal(UploadAndSaveSealDTO dto) throws Exception {
        if (dto.getFile() == null) {
            return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), "\u53c2\u6570\u6821\u9a8c\u5931\u8d25, [ file ] \u4e3a\u7a7a");
        }
        RestResult result = this.uploadFile(dto.getFile(), 2, dto.getSealExtension());
        if (result.isSuccess().booleanValue()) {
            String uuid = (String)result.getData();
            if (StringUtils.isNotBlank(uuid)) {
                dto.setFile(null);
                dto.setPath(uuid);
                return this.clientFactory.sealClient().addSeal(dto);
            }
            return null;
        }
        return result;
    }

    @Override
    public RestResult uploadAndUpdateSeal(UploadAndUpdateSealDTO dto) throws Exception {
        if (dto.getFile() == null) {
            return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), "\u53c2\u6570\u6821\u9a8c\u5931\u8d25, [ file ] \u4e3a\u7a7a");
        }
        RestResult result = this.uploadFile(dto.getFile(), 2, dto.getSealExtension());
        if (result.isSuccess().booleanValue()) {
            String uuid = (String)result.getData();
            if (StringUtils.isNotBlank(uuid)) {
                dto.setFile(null);
                dto.setPath(uuid);
                return this.clientFactory.sealClient().updateSeal(dto);
            }
            return null;
        }
        return result;
    }

    @Override
    public RestResult uploadAndSaveContractTemplate(UploadAndSaveContractTemplateDTO dto) throws Exception {
        if (dto.getFile() == null) {
            return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), "\u53c2\u6570\u6821\u9a8c\u5931\u8d25, [ file ] \u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(dto.getTempExtension())) {
            return new RestResult(CommonEnum.ARGUMENT_VALID_ERROR.getValue(), "\u53c2\u6570\u6821\u9a8c\u5931\u8d25, [ tempExtension ] \u4e3a\u7a7a");
        }
        RestResult result = this.uploadFile(dto.getFile(), 1, dto.getTempExtension());
        if (result.isSuccess().booleanValue()) {
            String tempPath = (String)result.getData();
            if (StringUtils.isNotBlank(tempPath)) {
                dto.setTempPath(tempPath);
                dto.setFile(null);
                return this.clientFactory.contractClient().saveContractTemplate(dto);
            }
            return null;
        }
        return result;
    }
}

