/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.util;

import com.alibaba.fastjson.JSON;
import com.fdd.api.client.dto.BaseDTO;
import com.fdd.api.client.enums.SignTypeEnum;
import com.fdd.api.client.util.crypt.CryptTool;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SignUtil {
    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", "13430517865");
        map.put("adminAccountId", "");
        map.put("companyName", "");
        map.put("type", 1);
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setAppId("988888");
        baseDTO.setTimestamp("2019-01-05 14:33:39");
        baseDTO.setSignType("SHA256");
        baseDTO.setAppKey("VxdDAVR0mY1R7j4WgQ0mnm2R");
        baseDTO = SignUtil.sign(baseDTO, map);
    }

    public static String bizContent(Object object) throws Exception {
        String jsonObject = JSON.toJSONString(object);
        String encodedObject = URLEncoder.encode(jsonObject, "UTF-8");
        String biz_content = CryptTool.encryptBASE64(encodedObject.getBytes("UTF-8"));
        return biz_content;
    }

    public static BaseDTO sign(BaseDTO baseDTO, Object object) throws Exception {
        String appId = baseDTO.getAppId();
        String signType = baseDTO.getSignType();
        String timestamp = baseDTO.getTimestamp();
        String appKey = baseDTO.getAppKey();
        String bizContent = SignUtil.bizContent(object);
        baseDTO.setBizContent(bizContent);
        String sign = SignUtil.getSign(appId, appKey, signType, timestamp, bizContent);
        baseDTO.setSign(sign.trim());
        return baseDTO;
    }

    public static String getSign(String appId, String appKey, String signType, String timestamp, String bizContent) throws Exception {
        String sign = null;
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("appId", appId);
        map.put("signType", signType);
        map.put("timestamp", timestamp);
        map.put("bizContent", bizContent);
        ArrayList list = new ArrayList(map.keySet());
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        for (String key : list) {
            Object value = map.get(key);
            if (null == value || "".equals(value)) continue;
            builder.append(key).append("=").append(value).append("&");
        }
        String content = builder.substring(0, builder.length() - 1);
        switch (SignTypeEnum.valueOf(signType)) {
            case SHA256: {
                String sha256 = CryptTool.sha256(CryptTool.sha256(content) + appKey);
                sign = CryptTool.encryptBASE64(sha256.getBytes("UTF-8"));
                sign = CryptTool.encryptBASE64(sha256.getBytes());
                break;
            }
            case SHA1: {
                String sha1 = CryptTool.sha1(CryptTool.sha1(content) + appKey);
                sign = CryptTool.encryptBASE64(sha1.getBytes("UTF-8"));
                break;
            }
            case MD5: {
                String md5 = CryptTool.md5(CryptTool.md5(content) + appKey);
                sign = CryptTool.encryptBASE64(md5.getBytes("UTF-8"));
                break;
            }
        }
        return sign;
    }
}

