/*
 * Decompiled with CFR 0.152.
 */
package com.fdd.api.client.util.http;

import com.alibaba.fastjson.JSON;
import com.fdd.api.client.enums.BusinessEnum;
import com.fdd.api.client.exception.BaseException;
import com.fdd.api.client.res.RestResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.90 Safari/537.36";

    public static Boolean isHttp(String param) {
        if (param.indexOf(HTTP) != -1 || param.indexOf(HTTPS) != -1) {
            return true;
        }
        return false;
    }

    public static String postUrlAsJson(String url, Object params, String encode) throws IOException {
        HttpPost httpPost = HttpUtil.getHttpPostJson(url, params, encode);
        String result = HttpUtil.executeHttpRequest(httpPost, null);
        return result;
    }

    public static CloseableHttpResponse postUrlForDownload(String url, Object params, String encode) throws IOException {
        HttpPost httpPost = HttpUtil.getHttpPostJson(url, params, encode);
        httpPost.addHeader("Accept-Encoding", "identity");
        CloseableHttpResponse response = HttpUtil.executeHttpRequestForDownload(httpPost, null);
        return response;
    }

    private static HttpPost getHttpPostJson(String url, Object params, String encode) {
        HttpPost httpPost = new HttpPost(url);
        if (params != null) {
            StringEntity entity = new StringEntity(JSON.toJSONString(params), "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity(entity);
        }
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeHttpRequest(HttpUriRequest request, Map<String, String> reqHeader) throws IOException {
        CloseableHttpClient client = null;
        String result = null;
        try {
            HttpResponse response;
            HttpClientBuilder builder = HttpClients.custom();
            builder.setUserAgent(USER_AGENT);
            client = builder.build();
            if (reqHeader != null) {
                for (String name : reqHeader.keySet()) {
                    request.addHeader(name, reqHeader.get(name));
                }
            }
            if ((response = client.execute(request)).getStatusLine().getStatusCode() != 200) {
                throw new BaseException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25,\u72b6\u6001\u7801 = {" + response.getStatusLine().getStatusCode() + "},\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            }
            result = EntityUtils.toString(response.getEntity(), Charset.forName("UTF-8"));
        }
        catch (Throwable throwable) {
            ((CloseableHttpClient)client).close();
            throw throwable;
        }
        client.close();
        return result;
    }

    private static CloseableHttpResponse executeHttpRequestForDownload(HttpUriRequest request, Map<String, String> reqHeader) throws IOException {
        CloseableHttpClient client = null;
        String result = null;
        try {
            Header[] headers;
            CloseableHttpResponse response;
            client = HttpClients.createDefault();
            if (reqHeader != null) {
                for (String string : reqHeader.keySet()) {
                    request.addHeader(string, reqHeader.get(string));
                }
            }
            if ((response = client.execute(request)).getStatusLine().getStatusCode() == 200) {
                CloseableHttpResponse closeableHttpResponse = response;
                return closeableHttpResponse;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("httpStatus:");
            stringBuffer.append(response.getStatusLine().getStatusCode());
            stringBuffer.append(response.getStatusLine().getReasonPhrase());
            stringBuffer.append(", Header: ");
            for (Header header : headers = response.getAllHeaders()) {
                stringBuffer.append(header.getName());
                stringBuffer.append(":");
                stringBuffer.append(header.getValue());
            }
            throw new BaseException(result);
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestResult postMultipartFiles(String url, File file, Map<String, Object> params, Integer timeout) {
        RestResult result = new RestResult();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart("file", new FileBody(file));
            ContentType contentType = ContentType.create("text/html", "UTF-8");
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            httpPost.setHeader("User-Agent", USER_AGENT);
            CloseableHttpResponse response = httpClient.execute(httpPost);
            if (timeout == null) {
                timeout = 180000;
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(requestConfig);
            HttpEntity responseEntity = response.getEntity();
            String.valueOf(response.getStatusLine().getStatusCode());
            if (response.getStatusLine().getStatusCode() != 200) {
                result.setResult(BusinessEnum.ERROR.getValue(), "\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString(responseEntity, Charset.forName("UTF-8"));
                result = JSON.parseObject(resultStr, RestResult.class);
            }
        }
        catch (Exception e) {
            result.setResult(BusinessEnum.ERROR.getValue(), "HTTP\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            StringWriter w = new StringWriter();
            e.printStackTrace(new PrintWriter(w));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestResult postMultipartFiles(String url, Map<String, File> fileMaps, Map<String, Object> params, Integer timeout) throws IOException {
        RestResult result = new RestResult();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (fileMaps != null && fileMaps.size() > 0) {
                Set<Map.Entry<String, File>> entries = fileMaps.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    if (entry == null || entry.getValue() == null) continue;
                    builder.addPart(entry.getKey(), new FileBody((File)entry.getValue()));
                }
            }
            ContentType contentType = ContentType.create("text/html", "UTF-8");
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            httpPost.setHeader("User-Agent", USER_AGENT);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute(httpPost);
            if (timeout == null) {
                timeout = 180000;
            }
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(requestConfig);
            HttpEntity responseEntity = closeableHttpResponse.getEntity();
            String.valueOf(closeableHttpResponse.getStatusLine().getStatusCode());
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                result.setResult(BusinessEnum.ERROR.getValue(), "\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (responseEntity != null) {
                String resultStr = EntityUtils.toString(responseEntity, Charset.forName("UTF-8"));
                result = JSON.parseObject(resultStr, RestResult.class);
            }
        }
        catch (Exception e) {
            result.setResult(BusinessEnum.ERROR.getValue(), "HTTP\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
        }
        finally {
            httpClient.close();
        }
        return result;
    }

    public static String postUrl(String url, Map<String, Object> params, Map<String, String> reqHeader, String encode) throws IOException {
        HttpPost httpPost = HttpUtil.getHttpPost(url, params, encode);
        String result = HttpUtil.executeHttpRequest(httpPost, reqHeader);
        return result;
    }

    private static HttpPost getHttpPost(String url, Map<String, Object> params, String encode) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (params != null) {
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            for (String name : params.keySet()) {
                form.add(new BasicNameValuePair(name, params.get(name).toString()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, encode);
            httpPost.setEntity(entity);
        }
        return httpPost;
    }

    public static String postUrlAsJsonWithHeaders(String url, Object params, String encode, Map<String, String> headers) throws IOException {
        HttpPost httpPost = HttpUtil.getHttpPostJson(url, params, encode);
        String result = HttpUtil.executeHttpRequest(httpPost, headers);
        return result;
    }
}

