/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.raindrops.core.cache.utils;

import com.els.tso.raindrops.core.tool.utils.Func;
import com.els.tso.raindrops.core.tool.utils.SpringUtil;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

public class CacheUtil {
    private static CacheManager cacheManager = (CacheManager)SpringUtil.getBean(CacheManager.class);

    public static Cache getCache(String cacheName) {
        return cacheManager.getCache(cacheName);
    }

    @Nullable
    public static Object get(String cacheName, String keyPrefix, Object key) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        return CacheUtil.getCache(cacheName).get((Object)keyPrefix.concat(String.valueOf(key))).get();
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, @Nullable Class<T> type) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        return (T)CacheUtil.getCache(cacheName).get((Object)keyPrefix.concat(String.valueOf(key)), type);
    }

    @Nullable
    public static <T> T get(String cacheName, String keyPrefix, Object key, Callable<T> valueLoader) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return null;
        }
        try {
            Cache.ValueWrapper valueWrapper = CacheUtil.getCache(cacheName).get((Object)keyPrefix.concat(String.valueOf(key)));
            Object value = null;
            if (valueWrapper == null) {
                T call = valueLoader.call();
                if (Func.isNotEmpty(call)) {
                    CacheUtil.getCache(cacheName).put((Object)keyPrefix.concat(String.valueOf(key)), call);
                    value = call;
                }
            } else {
                value = valueWrapper.get();
            }
            return (T)value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void put(String cacheName, String keyPrefix, Object key, @Nullable Object value) {
        CacheUtil.getCache(cacheName).put((Object)keyPrefix.concat(String.valueOf(key)), value);
    }

    public static void evict(String cacheName, String keyPrefix, Object key) {
        if (Func.hasEmpty((Object[])new Object[]{cacheName, keyPrefix, key})) {
            return;
        }
        CacheUtil.getCache(cacheName).evict((Object)keyPrefix.concat(String.valueOf(key)));
    }

    public static void clear(String cacheName) {
        if (Func.isEmpty((Object)cacheName)) {
            return;
        }
        CacheUtil.getCache(cacheName).clear();
    }
}

