/*
 *      Copyright (c) 2018-2028, Chill Zhuang All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 *
 *  Redistributions of source code must retain the above copyright notice,
 *  this list of conditions and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *  Neither the name of the dreamlu.net developer nor the names of its
 *  contributors may be used to endorse or promote products derived from
 *  this software without specific prior written permission.
 *  Author: Chill 庄骞 (smallchill@163.com)
 */

package com.els.tso.raindrops.core.log.config;

import com.els.tso.raindrops.core.launch.props.RaindropsProperties;
import com.els.tso.raindrops.core.launch.server.ServerInfo;
import com.els.tso.raindrops.core.log.aspect.ApiLogAspect;
import com.els.tso.raindrops.core.log.event.ErrorLogListener;
import com.els.tso.raindrops.core.log.event.UsualLogListener;
import com.els.tso.raindrops.core.log.feign.ILogClient;
import com.els.tso.raindrops.core.log.logger.RaindropsLogger;
import com.els.tso.raindrops.core.log.event.ApiLogListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 日志工具自动配置
 *
 * @author Chill
 */
@Configuration
@ConditionalOnWebApplication
public class RaindropsLogToolAutoConfiguration {

	@Bean
	public ApiLogAspect apiLogAspect() {
		return new ApiLogAspect();
	}

	@Bean
	public RaindropsLogger raindropsLogger() {
		return new RaindropsLogger();
	}

	@Bean
	@ConditionalOnMissingBean(name = "apiLogListener")
	public ApiLogListener apiLogListener(ILogClient logService, ServerInfo serverInfo, RaindropsProperties raindropsProperties) {
		return new ApiLogListener(logService, serverInfo, raindropsProperties);
	}

	@Bean
	@ConditionalOnMissingBean(name = "errorEventListener")
	public ErrorLogListener errorEventListener(ILogClient logService, ServerInfo serverInfo, RaindropsProperties raindropsProperties) {
		return new ErrorLogListener(logService, serverInfo, raindropsProperties);
	}

	@Bean
	@ConditionalOnMissingBean(name = "usualEventListener")
	public UsualLogListener usualEventListener(ILogClient logService, ServerInfo serverInfo, RaindropsProperties raindropsProperties) {
		return new UsualLogListener(logService, serverInfo, raindropsProperties);
	}

}
