/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.activiti.service.impl;

import com.els.tso.activiti.dto.TaskOutDTO;
import com.els.tso.activiti.enumeration.AuditStatusEnum;
import com.els.tso.activiti.exception.AuditException;
import com.els.tso.activiti.model.ActivitiResultMO;
import com.els.tso.activiti.service.ActivitiOptService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivitiOptServiceImpl
implements ActivitiOptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivitiOptServiceImpl.class);
    @Autowired
    protected FormService formService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ManagementService managerService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private IdentityService identityService;

    private void checkParams(String taskId) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new AuditException("taskId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkProcess(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new AuditException("\u5f53\u524d\u6d41\u7a0b\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
    }

    private void checkTask(String taskId, String userId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new AuditException("\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        if (userId == null || !userId.equals(task.getAssignee())) {
            throw new AuditException("\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c!");
        }
    }

    private void checkHistoryTask(String taskId, String userId) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (historicTaskInstance == null) {
            throw new AuditException("\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        if (userId == null || !userId.equals(historicTaskInstance.getAssignee())) {
            throw new AuditException("\u5f53\u524d\u4efb\u52a1\u4e0d\u5c5e\u4e8e\u5f53\u524d\u7528\u6237,\u4e0d\u80fd\u64cd\u4f5c!");
        }
    }

    @Override
    public ActivitiResultMO submit(String processDefinitionKey, String userId, String businessKey, String auditOpinion, Map<String, Object> variables) {
        if (StringUtils.isEmpty((CharSequence)processDefinitionKey)) {
            throw new AuditException("processDefinitionKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivitiResultMO result = new ActivitiResultMO();
        this.identityService.setAuthenticatedUserId(userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
        if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
            processInstance.getProcessVariables().put("submit_opinion", auditOpinion);
        }
        result.setProcessInstanceId(processInstance.getProcessInstanceId());
        result.setAuditStatus(AuditStatusEnum.IN_AUDIT.getValue());
        result.setSubmitUser(userId);
        List<Task> tasks = this.getProcessTasks(processInstance.getProcessInstanceId());
        if (tasks != null) {
            Set<String> auditUserList = tasks.parallelStream().map(TaskInfo::getAssignee).collect(Collectors.toSet());
            result.setNextAuditUserList(auditUserList);
        }
        return result;
    }

    @Override
    public ActivitiResultMO complete(String taskId, String userId, String auditOpinion, Map<String, Object> variables) {
        this.checkParams(taskId);
        this.checkTask(taskId, userId);
        this.taskService.claim(taskId, userId);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processInstanceId = task.getProcessInstanceId();
        if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
            this.taskService.addComment(taskId, processInstanceId, auditOpinion);
        }
        this.taskService.complete(taskId, variables);
        List<Task> tasks = this.getProcessTasks(processInstanceId);
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        if (tasks == null || tasks.size() == 0) {
            result.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getValue());
        } else {
            result.setAuditStatus(AuditStatusEnum.IN_AUDIT.getValue());
            Set<String> auditUserList = tasks.parallelStream().map(TaskInfo::getAssignee).collect(Collectors.toSet());
            result.setNextAuditUserList(auditUserList);
        }
        return result;
    }

    @Override
    public ActivitiResultMO refuse(String taskId, String userId, String auditOpinion) {
        this.checkParams(taskId);
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processInstanceId = task.getProcessInstanceId();
        this.checkProcess(processInstanceId);
        this.checkTask(taskId, userId);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String startUserId = processInstance.getStartUserId();
        this.runtimeService.deleteProcessInstance(processInstanceId, auditOpinion);
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        result.setAuditStatus(AuditStatusEnum.AUDIT_NOPASS.getValue());
        result.setNextAuditUserList(Collections.singleton(startUserId));
        return result;
    }

    @Override
    public ActivitiResultMO reject(String taskId, String userId, String auditOpinion) {
        return null;
    }

    @Override
    public ActivitiResultMO cancelSubmit(String userId, String processInstanceId, String auditOpinion) {
        this.checkProcess(processInstanceId);
        String startUserId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getStartUserId();
        if (startUserId != null && !startUserId.equals(userId)) {
            throw new AuditException("\u975e\u63d0\u4ea4\u7528\u6237\u4e0d\u80fd\u64a4\u9500");
        }
        this.identityService.setAuthenticatedUserId(userId);
        this.runtimeService.deleteProcessInstance(processInstanceId, auditOpinion);
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        result.setAuditStatus(AuditStatusEnum.UN_AUDIT.getValue());
        result.setNextAuditUserList(taskList.stream().map(TaskInfo::getAssignee).collect(Collectors.toSet()));
        return result;
    }

    @Override
    public ActivitiResultMO cancelComplete(String userId, String taskId, String auditOpinion) {
        this.checkParams(taskId);
        this.checkHistoryTask(taskId, userId);
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        String processInstanceId = historicTaskInstance.getProcessInstanceId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicTaskInstance.getProcessDefinitionId());
        String myActivityId = null;
        List haiList = this.historyService.createHistoricActivityInstanceQuery().executionId(historicTaskInstance.getExecutionId()).finished().list();
        for (HistoricActivityInstance hai : haiList) {
            if (!taskId.equals(hai.getTaskId())) continue;
            myActivityId = hai.getActivityId();
            break;
        }
        if (myActivityId == null) {
            throw new AuditException(String.format("taskId:%s \u4efb\u52a1\u4e0d\u5b58\u5728\u65e0\u6cd5\u64a4\u9500;", taskId));
        }
        FlowNode myFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(myActivityId);
        List list = ((TaskQuery)this.taskService.createTaskQuery().executionId(historicTaskInstance.getExecutionId())).list();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(historicTaskInstance.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        ArrayList oriSequenceFlows = new ArrayList(flowNode.getOutgoingFlows());
        flowNode.getOutgoingFlows().clear();
        ArrayList<SequenceFlow> newSequenceFlowList = new ArrayList<SequenceFlow>();
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setSourceFlowElement((FlowElement)flowNode);
        newSequenceFlow.setTargetFlowElement((FlowElement)myFlowNode);
        newSequenceFlowList.add(newSequenceFlow);
        flowNode.setOutgoingFlows(newSequenceFlowList);
        list.forEach(taskTmp -> {
            this.identityService.setAuthenticatedUserId(userId);
            if (StringUtils.isNotBlank((CharSequence)auditOpinion)) {
                this.taskService.addComment(taskTmp.getId(), taskTmp.getProcessInstanceId(), auditOpinion);
            }
            this.taskService.complete(taskTmp.getId());
        });
        flowNode.setOutgoingFlows(oriSequenceFlows);
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        ActivitiResultMO result = new ActivitiResultMO();
        result.setProcessInstanceId(processInstanceId);
        result.setSubmitUser(userId);
        result.setAuditStatus(AuditStatusEnum.IN_AUDIT.getValue());
        result.setNextAuditUserList(taskList.stream().map(TaskInfo::getAssignee).collect(Collectors.toSet()));
        return result;
    }

    @Override
    public InputStream showDiagram(String processInstanceId) {
        return this.getProcessDiagram(processInstanceId);
    }

    @Override
    public String createUser(String userId, String userName) {
        User user = this.identityService.newUser(userId);
        user.setFirstName(userName);
        this.identityService.saveUser(user);
        return user.getId();
    }

    @Override
    public String createUserGroup(String groupId, String groupName, String userId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            Group groupNew = this.identityService.newGroup(groupId);
            groupNew.setName(groupName);
            this.identityService.saveGroup(groupNew);
        }
        this.identityService.createMembership(userId, groupId);
        return groupId;
    }

    private List<Task> getProcessTasks(String processInstanceId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
    }

    @Override
    public List<TaskOutDTO> todoList(String userId) {
        return this.todoPageList(userId, 1, Integer.MAX_VALUE);
    }

    @Override
    public List<TaskOutDTO> todoPageList(String userId, int pageNum, int pageSize) {
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userId)).orderByTaskCreateTime()).desc()).listPage((pageNum - 1) * pageSize, pageSize);
        return tasks.parallelStream().map(this::converse).collect(Collectors.toList());
    }

    private TaskOutDTO converse(Task task) {
        TaskOutDTO outDTO = new TaskOutDTO();
        outDTO.setId(task.getId());
        outDTO.setAssignee(task.getAssignee());
        outDTO.setCreateTime(task.getCreateTime());
        outDTO.setDelegationState(task.getDelegationState());
        outDTO.setDescription(task.getDescription());
        outDTO.setDueDate(task.getDueDate());
        outDTO.setFormKey(task.getFormKey());
        outDTO.setName(task.getName());
        outDTO.setParentTaskId(task.getParentTaskId());
        outDTO.setPriority(task.getPriority());
        outDTO.setProcessInstanceId(task.getProcessInstanceId());
        outDTO.setOwner(task.getOwner());
        return outDTO;
    }

    @Override
    public long todoListCount(String userId) {
        return ((TaskQuery)this.taskService.createTaskQuery().taskAssignee(userId)).count();
    }

    public InputStream getProcessDiagram(String processInstanceId) {
        BpmnModel model;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null && (model = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId())) != null && model.getLocationMap().size() > 0) {
            DefaultProcessDiagramGenerator generator = new DefaultProcessDiagramGenerator();
            return generator.generateDiagram(model, "jpeg", this.runtimeService.getActiveActivityIds(processInstanceId));
        }
        return null;
    }
}

