/*
 * Decompiled with CFR 0.152.
 */
package com.els.tso.activiti.controller;

import com.els.tso.activiti.dto.ActivitiInDTO;
import com.els.tso.activiti.service.ActivitiOptService;
import com.els.tso.core.dto.R;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/activiti"})
public class ActivitiOptController {
    private final ActivitiOptService activitiOptService;

    public ActivitiOptController(ActivitiOptService activitiOptService) {
        this.activitiOptService = activitiOptService;
    }

    @PostMapping(value={"/submit"})
    public R<?> submit(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.submit(activitiInDTO.getProcessDefinitionKey(), activitiInDTO.getUserId(), activitiInDTO.getBusinessKey(), activitiInDTO.getAuditOpinion(), activitiInDTO.getVariables()));
    }

    @PostMapping(value={"/complete"})
    public R<?> complete(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.complete(activitiInDTO.getTaskId(), activitiInDTO.getUserId(), activitiInDTO.getAuditOpinion(), activitiInDTO.getVariables()));
    }

    @PostMapping(value={"/refuse"})
    public R<?> refuse(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.refuse(activitiInDTO.getTaskId(), activitiInDTO.getUserId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping(value={"/reject"})
    public R<?> reject(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.reject(activitiInDTO.getTaskId(), activitiInDTO.getUserId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping(value={"/cancel_submit"})
    public R<?> cancelSubmit(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.cancelSubmit(activitiInDTO.getUserId(), activitiInDTO.getProcessInstanceId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping(value={"/cancel_complete"})
    public R<?> cancelComplete(@RequestBody ActivitiInDTO activitiInDTO) {
        return R.ok((Object)this.activitiOptService.cancelComplete(activitiInDTO.getUserId(), activitiInDTO.getTaskId(), activitiInDTO.getAuditOpinion()));
    }

    @PostMapping(value={"/importProcess"})
    public R<?> importProcess(@RequestPart(value="file") MultipartFile multipartFile) {
        return R.ok((Object)multipartFile.getName());
    }

    @GetMapping(value={"/diagram"})
    public ResponseEntity<?> showDiagram(String processInstanceId) {
        InputStream in = this.activitiOptService.showDiagram(processInstanceId);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"image/jpeg")).body((Object)new InputStreamResource(in));
    }

    @GetMapping(value={"/diagram1"})
    public ResponseEntity<?> showDiagram1(String processInstanceId) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        InputStream in = this.activitiOptService.showDiagram(processInstanceId);
        byte[] media = IOUtils.toByteArray((InputStream)in);
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.IMAGE_JPEG);
        return new ResponseEntity((Object)media, (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/diagram2"})
    public void showDiagram2(String processInstanceId, HttpServletResponse response) throws IOException {
        InputStream in = this.activitiOptService.showDiagram(processInstanceId);
        response.setContentType("image/jpeg");
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/user/{userId}"})
    public R<?> createUser(@PathVariable(value="userId") String userId, String userName) {
        HashMap map = Maps.newHashMap();
        map.put("userId", this.activitiOptService.createUser(userId, userName));
        return R.ok((Object)map);
    }

    @PostMapping(value={"/group/{groupId}"})
    public R<?> createUserGroup(@PathVariable(value="groupId") String groupId, String groupName, String userId) {
        HashMap map = Maps.newHashMap();
        map.put("groupId", this.activitiOptService.createUserGroup(groupId, groupName, userId));
        return R.ok((Object)map);
    }

    @GetMapping(value={"/todo_list/{userId}"})
    public R<?> todoList(@PathVariable(value="userId") String userId) {
        return R.ok(this.activitiOptService.todoList(userId));
    }

    @GetMapping(value={"/todo_page_list/{userId}"})
    public R<?> todoPageList(@PathVariable(value="userId") String userId, int pageNum, int pageSize) {
        return R.ok(this.activitiOptService.todoPageList(userId, pageNum, pageSize));
    }

    @GetMapping(value={"/todo_list_count"})
    public R<?> todoListCount(String userId) {
        return R.ok((Object)this.activitiOptService.todoListCount(userId));
    }

    @GetMapping(value={"/audit_hist_list"})
    public R<?> auditHisList(String processInstanceId) {
        return R.ok(this.activitiOptService.auditHisList(processInstanceId));
    }

    @GetMapping(value={"/check_just_before"})
    public R<?> checkJustBefore(String taskId) {
        return R.ok((Object)this.activitiOptService.isFlowNodeJustBefore(taskId));
    }

    @GetMapping(value={"/check_just_submit"})
    public R<?> checkJustSubmit(String processInstanceId) {
        return R.ok((Object)this.activitiOptService.isJustSubmit(processInstanceId));
    }
}

