package com.els.tso.auth.aop;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.tso.auth.constant.ShiroConstant;
import com.els.tso.auth.entity.Permission;
import com.els.tso.auth.entity.RolePermission;
import com.els.tso.auth.entity.UserRole;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IShiroService;
import com.els.tso.auth.service.IUserRoleService;
import com.els.tso.auth.utils.ShiroHelper;
import com.els.tso.base.service.RedisCacheService;
import com.els.tso.common.dto.R;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Aspect
@Component
public class ResetUserPermissionAspect {
    @Autowired
    private IPermissionService permissionService;
    @Autowired
    private RedisCacheService redisCacheService;
    @Autowired
    private IUserRoleService userRoleService;
    private static final Logger logger = LoggerFactory.getLogger(ResetUserPermissionAspect.class);

   /* @Pointcut("execution (public * com.els.tso..controller..*(..))")
    public void permissionAspect() {
    }*/

    @AfterReturning(returning = "result", pointcut = "@annotation(com.els.tso.auth.annotation.ResetUserPermission)")
    public void afterReturn(JoinPoint joinPoint, Object result) {
        if (R.class.equals(result.getClass())) {
            R RResult = (R) result;
            Object data = RResult.getData();
            //刷新Redis用户权限
            if (UserRole.class.equals(data.getClass())) {
                UserRole userRole = (UserRole) data;
                setRedisPermissionByUserID(userRole.getUserId());
            }
            //刷新Redis用户权限
            if (RolePermission.class.equals(data.getClass())) {
                RolePermission rolePermission = (RolePermission) data;
                List<UserRole> userRoleList = userRoleService.list(new QueryWrapper<>(new UserRole(null, rolePermission.getRoleId())));
                userRoleList.forEach((t) ->
                    setRedisPermissionByUserID(t.getUserId())
                );
            }
        }
    }

    public void setRedisPermissionByUserID(String userID) {
        List<Permission> permissionList = permissionService.getPermissionByUserID(userID);
        Set<String> permissions = ShiroHelper.getPermissionIdSetByPermissionList(permissionList);
        redisCacheService.set(ShiroConstant.USER_PERMISSION_REDIS_KEY + userID, permissions);
    }


}
