package com.els.tso.auth.config;

import com.els.tso.auth.constant.ShiroConstant;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.auth.service.IShiroService;
import com.els.tso.auth.utils.ShiroHelper;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;


@Configuration
@EnableAutoConfiguration
public class ShiroConfig {
    @Autowired
    private ShiroRealm shiroRealm;
    @Autowired
    private IPermissionService permissionService;

    /**
     * 注入安全管理器
     *
     * @return SecurityManager
     */
    @Bean
    public SecurityManager securityManager() {
        // 将自定义 Realm 加进来
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm(shiroRealm);
        return securityManager;
    }

    /**
     * shiroFilter配置
     *
     * @param securityManager
     * @return
     */
    @Bean
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        // 设置登录页面
        shiroFilterFactoryBean.setLoginUrl(ShiroConstant.LOGIN_URL);
        // 设置登录成功跳转页面
        shiroFilterFactoryBean.setSuccessUrl(ShiroConstant.SUCCESS_URL);
        Map<String, String> filterChainDefinitionMap =
            permissionService.initShrioFilterChainDefinitionMap();
        //roles验证
//      filterChainDefinitionMap.put(permission.getPermissionUrl(), "roles[" + role.getRoleName() + "]");
        //未授权界面;
        shiroFilterFactoryBean.setUnauthorizedUrl(ShiroConstant.UNAUTHORIZED_URL);
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return shiroFilterFactoryBean;
    }


}
