package com.els.tso.auth.config;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.tso.auth.constant.ShiroConstant;
import com.els.tso.auth.entity.*;
import com.els.tso.auth.service.*;
import com.els.tso.auth.utils.ShiroHelper;
import com.els.tso.base.service.RedisCacheService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.util.*;
import java.util.stream.Collectors;


@Configuration
public class ShiroRealm extends AuthorizingRealm {
    @Autowired
    private IUserService iUserService;

    @Autowired
    private IPermissionService permissionService;

    @Autowired
    private RedisCacheService redisCacheService;


    /**
     * 根据用户角色授权
     */
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        // 获取用户code
        String userCode = (String) principals.getPrimaryPrincipal();
        User user = getUserByCode(userCode);
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        // 设置用户角色
//        CopyOnWriteArraySet<String> roles = new CopyOnWriteArraySet<>();
//        authorizationInfo.setRoles(roles);
        //获取用户权限
        Set<String> set= (Set<String>)redisCacheService.get(ShiroConstant.USER_PERMISSION_REDIS_KEY + user.getId());
//        Set set = redisCacheService.getSet(ShiroConstant.USERPERMISSION+user.getId());
        if (set!=null&&set.size()>0){
            authorizationInfo.setStringPermissions(set);
        }else {
            List<Permission> permissionList = permissionService.getPermissionByUserID(user.getId() + "");
            Set<String> permissions = ShiroHelper.getPermissionIdSetByPermissionList(permissionList);
            authorizationInfo.setStringPermissions(permissions);
            redisCacheService.set(ShiroConstant.USER_PERMISSION_REDIS_KEY+user.getId(),permissions);
        }
        return authorizationInfo;
    }

    /**
     * 验证账号密码
     *
     * @param token
     * @return
     * @throws AuthenticationException
     */
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String userCode = (String) token.getPrincipal();
        User user = getUserByCode(userCode);
        Subject subject = SecurityUtils.getSubject();
        subject.getSession().setAttribute("user", user);
        // 验证账号密码
        SimpleAuthenticationInfo authorizationInfo =
            new SimpleAuthenticationInfo(user.getUserCode(), user.getPassword(),
                this.getClass().getSimpleName());
        return authorizationInfo;
    }

    public User getUserByCode(String code) {
        if (StringUtils.isEmpty(code)) {
            return null;
        }
        User user = new User();
        user.setUserCode(code);
        QueryWrapper<User> queryWrapper = new QueryWrapper<User>(user);
        user = iUserService.getOne(queryWrapper);
        if (user == null) {
            return null;
        }
        return user;
    }
}
