package com.els.tso.auth.controller;

import com.els.tso.auth.entity.User;
import com.els.tso.auth.utils.MD5Util;
import com.els.tso.common.dto.R;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;


@RestController
public class LoginController {
    /**
     * 验证码账号密码
     *
     * @param
     * @param request
     * @return
     */
    @RequestMapping("/userLogin")
//    public R userLogin(@RequestBody User user, HttpServletRequest request) {
    public R userLogin(@RequestParam String userCode, @RequestParam String password, HttpServletRequest request) {

        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken usernamePasswordToken =
            new UsernamePasswordToken(userCode, MD5Util.encode(password));
        try {
            subject.login(usernamePasswordToken);
            return R.ok();
        } catch (Exception e) {
            e.printStackTrace();
            return R.fail("账号或者密码错误", null);
        }
    }


}
