package com.els.tso.auth.controller;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.tso.auth.entity.Permission;
import com.els.tso.auth.service.IPermissionService;
import com.els.tso.common.dto.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 权限表 tso前端控制器
 * </p>
 *
 * @author daipengjie
 * @since 2021-01-06
 */
@RestController
@RequestMapping("/permission")
public class PermissionController {
    @Autowired
    private IPermissionService permissionService;

    /**
     * 条件查询
     *
     * @param permission
     * @return
     */
    @GetMapping("/list")
    public R<?> list(@RequestBody Permission permission) {
        //查询条件
        QueryWrapper<Permission> queryWrapper = new QueryWrapper<>();
        queryWrapper.setEntity(permission);
        List<Permission> list = permissionService.list(queryWrapper);
        //查询返回
        return R.ok(list);
    }

    /**
     * 单个查询
     *
     * @param id
     * @return
     */
    @GetMapping("/one")
    public R<?> list(Long id) {
        return R.ok(permissionService.getById(id));
    }

    /**
     * 更新或新增
     *
     * @param permission
     * @return
     */
    @PostMapping("/save")
    public R<?> add(@RequestBody Permission permission) {
        return R.ok(permissionService.saveOrUpdate(permission));
    }

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @DeleteMapping("/delete")
    public R<?> delete(Long id) {
        return R.ok(permissionService.removeById(id));
    }


}

